/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.properties;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.AbstractProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import java.lang.constant.Constable;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBuilder {
    static final Logger LOGGER = LoggerFactory.getLogger(PropertyBuilder.class);

    public static Property build(String type, String format, Map<PropertyId, Object> args) {
        Map<PropertyId, Object> fixedArgs;
        Map<PropertyId, Object> safeArgs;
        Processor processor = Processor.fromType(type, format);
        if (processor == null) {
            return null;
        }
        Map<Object, Object> map = safeArgs = args == null ? Collections.emptyMap() : args;
        if (format != null) {
            fixedArgs = new EnumMap(PropertyId.class);
            fixedArgs.putAll(safeArgs);
            fixedArgs.put(PropertyId.FORMAT, format);
        } else {
            fixedArgs = safeArgs;
        }
        return processor.build(fixedArgs);
    }

    public static Property merge(Property property, Map<PropertyId, Object> args) {
        Processor processor;
        if (args != null && !args.isEmpty() && (processor = Processor.fromProperty(property)) != null) {
            processor.merge(property, args);
        }
        return property;
    }

    public static Model toModel(Property property) {
        Processor processor = Processor.fromProperty(property);
        if (processor != null) {
            return processor.toModel(property);
        }
        return null;
    }

    private static enum Processor {
        BOOLEAN(BooleanProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return BooleanProperty.isType(type, format);
            }

            @Override
            protected BooleanProperty create() {
                return new BooleanProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof BooleanProperty) {
                    BooleanProperty resolved = (BooleanProperty)property;
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((Boolean)null);
                        }
                    }
                }
                return property;
            }
        }
        ,
        BYTE_ARRAY(ByteArrayProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return ByteArrayProperty.isType(type, format);
            }

            @Override
            protected ByteArrayProperty create() {
                return new ByteArrayProperty();
            }
        }
        ,
        BINARY(BinaryProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return BinaryProperty.isType(type, format);
            }

            @Override
            protected BinaryProperty create() {
                return new BinaryProperty();
            }
        }
        ,
        DATE(DateProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return DateProperty.isType(type, format);
            }

            @Override
            protected DateProperty create() {
                return new DateProperty();
            }
        }
        ,
        DATE_TIME(DateTimeProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return DateTimeProperty.isType(type, format);
            }

            @Override
            protected DateTimeProperty create() {
                return new DateTimeProperty();
            }
        }
        ,
        INT(IntegerProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return IntegerProperty.isType(type, format);
            }

            @Override
            protected IntegerProperty create() {
                return new IntegerProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof IntegerProperty) {
                    IntegerProperty resolved = (IntegerProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((Integer)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    IntegerProperty resolved = (IntegerProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    Integer defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        LONG(LongProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return LongProperty.isType(type, format);
            }

            @Override
            protected LongProperty create() {
                return new LongProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof LongProperty) {
                    LongProperty resolved = (LongProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((Long)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    LongProperty resolved = (LongProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    Long defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        FLOAT(FloatProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return FloatProperty.isType(type, format);
            }

            @Override
            protected FloatProperty create() {
                return new FloatProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof FloatProperty) {
                    FloatProperty resolved = (FloatProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((Float)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    FloatProperty resolved = (FloatProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    Float defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        DOUBLE(DoubleProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return DoubleProperty.isType(type, format);
            }

            @Override
            protected DoubleProperty create() {
                return new DoubleProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof DoubleProperty) {
                    DoubleProperty resolved = (DoubleProperty)property;
                    this.mergeNumeric(resolved, args);
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        String value = (String)PropertyId.DEFAULT.findValue(args);
                        if (value != null) {
                            resolved.setDefault(value);
                        } else {
                            resolved.setDefault((Double)null);
                        }
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    DoubleProperty resolved = (DoubleProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    Double defaultValue = resolved.getDefault();
                    if (defaultValue != null) {
                        model.setDefaultValue(defaultValue.toString());
                    }
                    return model;
                }
                return null;
            }
        }
        ,
        INTEGER(BaseIntegerProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return BaseIntegerProperty.isType(type, format);
            }

            @Override
            protected BaseIntegerProperty create() {
                return new BaseIntegerProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof BaseIntegerProperty) {
                    BaseIntegerProperty resolved = (BaseIntegerProperty)property;
                    this.mergeNumeric(resolved, args);
                }
                return property;
            }
        }
        ,
        DECIMAL(DecimalProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return DecimalProperty.isType(type, format);
            }

            @Override
            protected DecimalProperty create() {
                return new DecimalProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof DecimalProperty) {
                    DecimalProperty resolved = (DecimalProperty)property;
                    this.mergeNumeric(resolved, args);
                }
                return property;
            }
        }
        ,
        FILE(FileProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return FileProperty.isType(type, format);
            }

            @Override
            protected FileProperty create() {
                return new FileProperty();
            }
        }
        ,
        REFERENCE(RefProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return RefProperty.isType(type, format);
            }

            @Override
            protected RefProperty create() {
                return new RefProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof RefProperty) {
                    RefProperty resolved = (RefProperty)property;
                    RefModel model = new RefModel(resolved.get$ref());
                    model.setDescription(resolved.getDescription());
                    return model;
                }
                return null;
            }
        }
        ,
        E_MAIL(EmailProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return EmailProperty.isType(type, format);
            }

            @Override
            protected EmailProperty create() {
                return new EmailProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof EmailProperty) {
                    this.mergeString((EmailProperty)property, args);
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    return this.createStringModel((StringProperty)property);
                }
                return null;
            }
        }
        ,
        UUID(UUIDProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return UUIDProperty.isType(type, format);
            }

            @Override
            protected UUIDProperty create() {
                return new UUIDProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof UUIDProperty) {
                    Object value;
                    UUIDProperty resolved = (UUIDProperty)property;
                    if (args.containsKey((Object)PropertyId.DEFAULT)) {
                        value = (String)PropertyId.DEFAULT.findValue(args);
                        property.setDefault((String)value);
                    }
                    if (args.containsKey((Object)PropertyId.MIN_LENGTH)) {
                        value = (Integer)PropertyId.MIN_LENGTH.findValue(args);
                        resolved.setMinLength((Integer)value);
                    }
                    if (args.containsKey((Object)PropertyId.MAX_LENGTH)) {
                        value = (Integer)PropertyId.MAX_LENGTH.findValue(args);
                        resolved.setMaxLength((Integer)value);
                    }
                    if (args.containsKey((Object)PropertyId.PATTERN)) {
                        value = (String)PropertyId.PATTERN.findValue(args);
                        resolved.setPattern((String)value);
                    }
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    UUIDProperty resolved = (UUIDProperty)property;
                    ModelImpl model = this.createModel(resolved);
                    model.setDefaultValue(resolved.getDefault());
                    return model;
                }
                return null;
            }
        }
        ,
        OBJECT(ObjectProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return ObjectProperty.isType(type, format);
            }

            @Override
            protected ObjectProperty create() {
                return new ObjectProperty();
            }
        }
        ,
        ARRAY(ArrayProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return ArrayProperty.isType(type);
            }

            @Override
            protected ArrayProperty create() {
                return new ArrayProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof ArrayProperty) {
                    ArrayProperty resolved = (ArrayProperty)property;
                    ArrayModel model = new ArrayModel().items(resolved.getItems()).description(resolved.getDescription());
                    return model;
                }
                return null;
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof ArrayProperty) {
                    Integer value;
                    ArrayProperty resolved = (ArrayProperty)property;
                    if (args.containsKey((Object)PropertyId.MIN_ITEMS)) {
                        value = (Integer)PropertyId.MIN_ITEMS.findValue(args);
                        resolved.setMinItems(value);
                    }
                    if (args.containsKey((Object)PropertyId.MAX_ITEMS)) {
                        value = (Integer)PropertyId.MAX_ITEMS.findValue(args);
                        resolved.setMaxItems(value);
                    }
                }
                return property;
            }
        }
        ,
        MAP(MapProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return MapProperty.isType(type, format);
            }

            @Override
            protected MapProperty create() {
                return new MapProperty();
            }

            @Override
            public Model toModel(Property property) {
                if (property instanceof MapProperty) {
                    MapProperty resolved = (MapProperty)property;
                    return this.createModel(property).additionalProperties(resolved.getAdditionalProperties());
                }
                return null;
            }
        }
        ,
        STRING(StringProperty.class){

            @Override
            protected boolean isType(String type, String format) {
                return StringProperty.isType(type, format);
            }

            @Override
            protected StringProperty create() {
                return new StringProperty();
            }

            @Override
            public Property merge(Property property, Map<PropertyId, Object> args) {
                super.merge(property, args);
                if (property instanceof StringProperty) {
                    this.mergeString((StringProperty)property, args);
                }
                return property;
            }

            @Override
            public Model toModel(Property property) {
                if (this.isType(property)) {
                    return this.createStringModel((StringProperty)property);
                }
                return null;
            }
        };

        private final Class<? extends Property> type;

        private Processor(Class<? extends Property> type) {
            this.type = type;
        }

        public static Processor fromType(String type, String format) {
            for (Processor item : Processor.values()) {
                if (!item.isType(type, format)) continue;
                return item;
            }
            LOGGER.debug("no property for " + type + ", " + format);
            return null;
        }

        public static Processor fromProperty(Property property) {
            for (Processor item : Processor.values()) {
                if (!item.isType(property)) continue;
                return item;
            }
            LOGGER.error("no property for " + (property == null ? "null" : property.getClass().getName()));
            return null;
        }

        protected abstract boolean isType(String var1, String var2);

        protected boolean isType(Property property) {
            return this.type.isInstance(property);
        }

        protected abstract Property create();

        protected <N extends AbstractNumericProperty> N mergeNumeric(N property, Map<PropertyId, Object> args) {
            Constable value;
            if (args.containsKey((Object)PropertyId.MINIMUM)) {
                value = (Double)PropertyId.MINIMUM.findValue(args);
                property.setMinimum((Double)value);
            }
            if (args.containsKey((Object)PropertyId.MAXIMUM)) {
                value = (Double)PropertyId.MAXIMUM.findValue(args);
                property.setMaximum((Double)value);
            }
            if (args.containsKey((Object)PropertyId.EXCLUSIVE_MINIMUM)) {
                value = (Boolean)PropertyId.EXCLUSIVE_MINIMUM.findValue(args);
                property.setExclusiveMinimum((Boolean)value);
            }
            if (args.containsKey((Object)PropertyId.EXCLUSIVE_MAXIMUM)) {
                value = (Boolean)PropertyId.EXCLUSIVE_MAXIMUM.findValue(args);
                property.setExclusiveMaximum((Boolean)value);
            }
            return property;
        }

        protected <N extends StringProperty> N mergeString(N property, Map<PropertyId, Object> args) {
            Object value;
            if (args.containsKey((Object)PropertyId.DEFAULT)) {
                value = (String)PropertyId.DEFAULT.findValue(args);
                property.setDefault((String)value);
            }
            if (args.containsKey((Object)PropertyId.MIN_LENGTH)) {
                value = (Integer)PropertyId.MIN_LENGTH.findValue(args);
                property.setMinLength((Integer)value);
            }
            if (args.containsKey((Object)PropertyId.MAX_LENGTH)) {
                value = (Integer)PropertyId.MAX_LENGTH.findValue(args);
                property.setMaxLength((Integer)value);
            }
            if (args.containsKey((Object)PropertyId.PATTERN)) {
                value = (String)PropertyId.PATTERN.findValue(args);
                property.setPattern((String)value);
            }
            if (args.containsKey((Object)PropertyId.ENUM)) {
                value = (List)PropertyId.ENUM.findValue(args);
                property.setEnum((List<String>)value);
            }
            return property;
        }

        protected ModelImpl createModel(Property property) {
            return new ModelImpl().type(property.getType()).format(property.getFormat()).description(property.getDescription());
        }

        protected ModelImpl createStringModel(StringProperty property) {
            ModelImpl model = this.createModel(property);
            model.setDefaultValue(property.getDefault());
            return model;
        }

        public Property build(Map<PropertyId, Object> args) {
            return this.merge(this.create(), args);
        }

        public Property merge(Property property, Map<PropertyId, Object> args) {
            if (args.containsKey((Object)PropertyId.READ_ONLY)) {
                property.setReadOnly((Boolean)PropertyId.READ_ONLY.findValue(args));
            }
            if (property instanceof AbstractProperty) {
                List values;
                Object value;
                AbstractProperty resolved = (AbstractProperty)property;
                if (resolved.getFormat() == null) {
                    resolved.setFormat((String)PropertyId.FORMAT.findValue(args));
                }
                if (args.containsKey((Object)PropertyId.TITLE)) {
                    value = (String)PropertyId.TITLE.findValue(args);
                    resolved.setTitle((String)value);
                }
                if (args.containsKey((Object)PropertyId.DESCRIPTION)) {
                    value = (String)PropertyId.DESCRIPTION.findValue(args);
                    resolved.setDescription((String)value);
                }
                if (args.containsKey((Object)PropertyId.EXAMPLE)) {
                    value = (String)PropertyId.EXAMPLE.findValue(args);
                    resolved.setExample(value);
                }
                if (args.containsKey((Object)PropertyId.VENDOR_EXTENSIONS)) {
                    value = (Map)PropertyId.VENDOR_EXTENSIONS.findValue(args);
                    resolved.setVendorExtensionMap((Map<String, Object>)value);
                }
                if (args.containsKey((Object)PropertyId.ENUM) && (values = (List)PropertyId.ENUM.findValue(args)) != null) {
                    AbstractProperty p;
                    if (property instanceof IntegerProperty) {
                        p = (IntegerProperty)property;
                        for (String value2 : values) {
                            try {
                                ((IntegerProperty)p)._enum(Integer.parseInt(value2));
                            }
                            catch (Exception e) {}
                        }
                    }
                    if (property instanceof LongProperty) {
                        p = (LongProperty)property;
                        for (String value2 : values) {
                            try {
                                ((LongProperty)p)._enum(Long.parseLong(value2));
                            }
                            catch (Exception e) {}
                        }
                    }
                    if (property instanceof DoubleProperty) {
                        p = (DoubleProperty)property;
                        for (String value2 : values) {
                            try {
                                ((DoubleProperty)p)._enum(Double.parseDouble(value2));
                            }
                            catch (Exception e) {}
                        }
                    }
                    if (property instanceof FloatProperty) {
                        p = (FloatProperty)property;
                        for (String value2 : values) {
                            try {
                                ((FloatProperty)p)._enum(Float.valueOf(Float.parseFloat(value2)));
                            }
                            catch (Exception e) {}
                        }
                    }
                    if (property instanceof DateProperty) {
                        p = (DateProperty)property;
                        for (String value2 : values) {
                            try {
                                ((DateProperty)p)._enum(value2);
                            }
                            catch (Exception e) {}
                        }
                    }
                    if (property instanceof DateTimeProperty) {
                        p = (DateTimeProperty)property;
                        for (String value2 : values) {
                            try {
                                ((DateTimeProperty)p)._enum(value2);
                            }
                            catch (Exception e) {}
                        }
                    }
                    if (property instanceof UUIDProperty) {
                        p = (UUIDProperty)property;
                        for (String value2 : values) {
                            try {
                                ((UUIDProperty)p)._enum(value2);
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            }
            return property;
        }

        public Model toModel(Property property) {
            return this.createModel(property);
        }
    }

    public static enum PropertyId {
        ENUM("enum"),
        TITLE("title"),
        DESCRIPTION("description"),
        DEFAULT("default"),
        PATTERN("pattern"),
        DESCRIMINATOR("discriminator"),
        MIN_ITEMS("minItems"),
        MAX_ITEMS("maxItems"),
        MIN_PROPERTIES("minProperties"),
        MAX_PROPERTIES("maxProperties"),
        MIN_LENGTH("minLength"),
        MAX_LENGTH("maxLength"),
        MINIMUM("minimum"),
        MAXIMUM("maximum"),
        EXCLUSIVE_MINIMUM("exclusiveMinimum"),
        EXCLUSIVE_MAXIMUM("exclusiveMaximum"),
        UNIQUE_ITEMS("uniqueItems"),
        EXAMPLE("example"),
        TYPE("type"),
        FORMAT("format"),
        READ_ONLY("readOnly"),
        REQUIRED("required"),
        VENDOR_EXTENSIONS("vendorExtensions");

        private String propertyName;

        private PropertyId(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public <T> T findValue(Map<PropertyId, Object> args) {
            Object value = args.get((Object)this);
            return (T)value;
        }
    }
}

