/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.models.refs.GenericRef;
import io.swagger.models.refs.RefFormat;
import io.swagger.models.refs.RefType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GenericRefTest {
    private void assertRefFormat(GenericRef ref, RefFormat expectedFormat) {
        Assert.assertEquals((Object)ref.getFormat(), (Object)expectedFormat);
    }

    @Test(description="it should correctly identify URL refs")
    public void identifyURLRefs() {
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "http://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "http://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "https://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "https://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "http://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "http://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "https://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "https://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "http://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "http://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "https://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "https://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.PATH, "http://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.PATH, "http://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.PATH, "https://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.PATH, "https://my.company.com/models/model.json#/thing"), RefFormat.URL);
    }

    @Test(description="it should correctly identify internal refs")
    public void identifyInternalRefs() {
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "#/definitions/foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "#/parameters/foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "#/responses/foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.PATH, "#/paths/foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "Foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "Foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "Foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.PATH, "Foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "httpNotUrl"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "httpNotUrl"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "httpNotUrl"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.PATH, "httpNotUrl"), RefFormat.INTERNAL);
    }

    @Test(description="it should correctly identify relative refs")
    public void identifyRelativeRefs() {
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "./path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "./path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "../path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "../path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "./path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "./path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "../path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "../path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "./path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "./path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "../path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.RESPONSE, "../path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PATH, "./path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PATH, "./path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PATH, "../path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PATH, "../path/to/model.json#/thing"), RefFormat.RELATIVE);
    }

    private void assertRefStringIsUnchanged(RefType refType, String refStr) {
        this.assertRefString(refType, refStr, refStr);
    }

    private void assertRefString(RefType refType, String refStr, String expectedRefStr) {
        GenericRef refObj = new GenericRef(refType, refStr);
        Assert.assertEquals((String)refObj.getRef(), (String)expectedRefStr);
    }

    private void assertSimpleRefMatchesRef(RefType refType, String refStr) {
        this.assertSimpleRef(refType, refStr, refStr);
    }

    private void assertSimpleRef(RefType refType, String refStr, String expectedSimpleRef) {
        GenericRef refObj = new GenericRef(refType, refStr);
        Assert.assertEquals((String)refObj.getSimpleRef(), (String)expectedSimpleRef);
    }

    @Test(description="it should give back the right ref string")
    public void giveBackRightRefString() {
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "./path/to/model.json");
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "./path/to/model.json#/thing");
        this.assertRefStringIsUnchanged(RefType.PARAMETER, "./path/to/parameters.json");
        this.assertRefStringIsUnchanged(RefType.PARAMETER, "./path/to/parameters.json#/thing");
        this.assertRefStringIsUnchanged(RefType.PATH, "./path/to/parameters.json");
        this.assertRefStringIsUnchanged(RefType.PATH, "./path/to/parameters.json#/thing");
        this.assertRefStringIsUnchanged(RefType.RESPONSE, "./path/to/parameters.json");
        this.assertRefStringIsUnchanged(RefType.RESPONSE, "./path/to/parameters.json#/thing");
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "#/definitions/foo");
        this.assertRefStringIsUnchanged(RefType.PARAMETER, "#/parameters/foo");
        this.assertRefStringIsUnchanged(RefType.PATH, "#/paths/foo");
        this.assertRefStringIsUnchanged(RefType.RESPONSE, "#/responses/foo");
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "http://my.company.com/models/model.json");
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "http://my.company.com/models/model.json#/thing");
        this.assertRefStringIsUnchanged(RefType.PARAMETER, "http://my.company.com/models/model.json");
        this.assertRefStringIsUnchanged(RefType.PARAMETER, "http://my.company.com/models/model.json#/thing");
        this.assertRefStringIsUnchanged(RefType.RESPONSE, "http://my.company.com/models/model.json");
        this.assertRefStringIsUnchanged(RefType.RESPONSE, "http://my.company.com/models/model.json#/thing");
        this.assertRefStringIsUnchanged(RefType.PATH, "http://my.company.com/models/model.json");
        this.assertRefStringIsUnchanged(RefType.PATH, "http://my.company.com/models/model.json#/thing");
        this.assertRefString(RefType.DEFINITION, "foo", "#/definitions/foo");
        this.assertRefString(RefType.PARAMETER, "foo", "#/parameters/foo");
        this.assertRefString(RefType.RESPONSE, "foo", "#/responses/foo");
        this.assertRefString(RefType.PATH, "foo", "#/paths/foo");
        this.assertRefString(RefType.DEFINITION, "httpNotUrl", "#/definitions/httpNotUrl");
        this.assertRefString(RefType.PARAMETER, "httpNotUrl", "#/parameters/httpNotUrl");
        this.assertRefString(RefType.RESPONSE, "httpNotUrl", "#/responses/httpNotUrl");
        this.assertRefString(RefType.PATH, "httpNotUrl", "#/paths/httpNotUrl");
    }

    @Test(description="it should give back the right simple ref")
    public void giveBackRightSimpleRef() {
        this.assertSimpleRefMatchesRef(RefType.DEFINITION, "./path/to/model.json");
        this.assertSimpleRefMatchesRef(RefType.DEFINITION, "./path/to/model.json#/thing");
        this.assertSimpleRefMatchesRef(RefType.PARAMETER, "./path/to/parameters.json#/param");
        this.assertSimpleRefMatchesRef(RefType.PARAMETER, "./path/to/parameters.json#/param");
        this.assertSimpleRefMatchesRef(RefType.RESPONSE, "./path/to/parameters.json#/param");
        this.assertSimpleRefMatchesRef(RefType.RESPONSE, "./path/to/parameters.json#/param");
        this.assertSimpleRefMatchesRef(RefType.PATH, "./path/to/parameters.json#/param");
        this.assertSimpleRefMatchesRef(RefType.PATH, "./path/to/parameters.json#/param");
        this.assertSimpleRefMatchesRef(RefType.DEFINITION, "http://my.company.com/models/model.json");
        this.assertSimpleRefMatchesRef(RefType.DEFINITION, "http://my.company.com/models/model.json#/thing");
        this.assertSimpleRefMatchesRef(RefType.PARAMETER, "http://my.company.com/models/model.json");
        this.assertSimpleRefMatchesRef(RefType.PARAMETER, "http://my.company.com/models/model.json#/thing");
        this.assertSimpleRefMatchesRef(RefType.PATH, "http://my.company.com/models/model.json");
        this.assertSimpleRefMatchesRef(RefType.PATH, "http://my.company.com/models/model.json#/thing");
        this.assertSimpleRefMatchesRef(RefType.RESPONSE, "http://my.company.com/models/model.json");
        this.assertSimpleRefMatchesRef(RefType.RESPONSE, "http://my.company.com/models/model.json#/thing");
        this.assertSimpleRef(RefType.DEFINITION, "#/definitions/foo", "foo");
        this.assertSimpleRef(RefType.PARAMETER, "#/parameters/foo", "foo");
        this.assertSimpleRef(RefType.RESPONSE, "#/responses/foo", "foo");
        this.assertSimpleRef(RefType.PATH, "#/paths/foo", "foo");
        this.assertSimpleRef(RefType.DEFINITION, "foo", "foo");
        this.assertSimpleRef(RefType.PARAMETER, "foo", "foo");
        this.assertSimpleRef(RefType.RESPONSE, "foo", "foo");
        this.assertSimpleRef(RefType.PATH, "foo", "foo");
        this.assertSimpleRef(RefType.DEFINITION, "httpNotUrl", "httpNotUrl");
        this.assertSimpleRef(RefType.PARAMETER, "httpNotUrl", "httpNotUrl");
        this.assertSimpleRef(RefType.RESPONSE, "httpNotUrl", "httpNotUrl");
        this.assertSimpleRef(RefType.PATH, "httpNotUrl", "httpNotUrl");
    }
}

