/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.models.RefModel;
import io.swagger.models.refs.RefFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RefModelTest {
    private void assertRefFormat(RefModel ref, RefFormat expectedFormat) {
        Assert.assertEquals((Object)ref.getRefFormat(), (Object)expectedFormat);
    }

    @Test(description="it should correctly identify ref formats")
    public void identifyRefFormats() {
        this.assertRefFormat(new RefModel("http://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new RefModel("http://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new RefModel("./models/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new RefModel("./models/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new RefModel("#/definitions/foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new RefModel("foo"), RefFormat.INTERNAL);
    }
}

