/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.models.parameters.RefParameter;
import io.swagger.models.refs.RefFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RefParameterTest {
    private void assertRefFormat(RefParameter ref, RefFormat expectedFormat) {
        Assert.assertEquals((Object)ref.getRefFormat(), (Object)expectedFormat);
    }

    @Test(description="it should correctly identify ref formats")
    public void identifyRefFormats() {
        this.assertRefFormat(new RefParameter("http://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new RefParameter("http://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new RefParameter("./models/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new RefParameter("./models/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new RefParameter("#/parameters/foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new RefParameter("foo"), RefFormat.INTERNAL);
    }
}

