/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.models.properties.RefProperty;
import io.swagger.models.refs.RefFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RefPropertyTest {
    private static final String PROP_1 = "prop1";
    private static final String PROP_2 = "prop2";

    private void assertRefFormat(RefProperty ref, RefFormat expectedFormat) {
        Assert.assertEquals((Object)ref.getRefFormat(), (Object)expectedFormat);
    }

    @Test(description="it should correctly identify ref formats")
    public void identifyRefFormats() {
        this.assertRefFormat(new RefProperty("http://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new RefProperty("http://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new RefProperty("./models/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new RefProperty("./models/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new RefProperty("#/definitions/foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new RefProperty("foo"), RefFormat.INTERNAL);
    }

    @Test
    public void testEquals() {
        RefProperty prop1 = new RefProperty();
        prop1.setName(PROP_1);
        prop1.setRequired(true);
        RefProperty prop2 = new RefProperty();
        prop2.setName(PROP_2);
        Assert.assertNotEquals((Object)prop1, (Object)prop2);
        prop2.setName(PROP_1);
        prop2.setRequired(true);
        Assert.assertEquals((Object)prop1, (Object)prop2);
    }
}

