/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.models.Model;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.exceptions.FieldNotFoundException;
import org.powermock.reflect.exceptions.MethodNotFoundException;
import org.testng.Assert;

public class TestUtils {
    private static final Logger LOGGER = Logger.getLogger(TestUtils.class.getName());

    private TestUtils() {
    }

    private static <T> Map<Field, Object> getPropertiesAndValues(Class<T> clazz, Set<String> exclusions, boolean defaultValues, boolean includeInherited) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Field[] fields;
        HashMap<Field, Object> propertiesAndDefaultValues = new HashMap<Field, Object>();
        for (Field field : fields = PowerMockito.fields(clazz)) {
            if (exclusions != null && exclusions.contains(field.getName()) || !includeInherited && field.getDeclaringClass() != clazz || Modifier.isStatic(field.getModifiers())) continue;
            Class<?> type = field.getType();
            Object value = null;
            value = defaultValues ? TestUtils.getTypeDefaultValue(type) : TestUtils.getTypeNonDefaultValue(type);
            propertiesAndDefaultValues.put(field, value);
        }
        return propertiesAndDefaultValues;
    }

    private static boolean implementsMethod(Class<?> clazz, String methodName) {
        try {
            Method[] methods;
            for (Method method : methods = PowerMockito.methods(clazz, (String[])new String[]{methodName})) {
                if (!method.getDeclaringClass().equals(clazz)) continue;
                return true;
            }
        }
        catch (MethodNotFoundException ex) {
            LOGGER.log(Level.INFO, ex.getMessage(), ex);
            return false;
        }
        return false;
    }

    public static <T> void testEquals(Class<T> clazz, Set<String> exclusions, boolean useInheritedFields) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object instance = Whitebox.newInstance(clazz);
        Object other = Whitebox.newInstance(clazz);
        Map<Field, Object> propertiesAndDefaultValues = TestUtils.getPropertiesAndValues(clazz, exclusions, true, useInheritedFields);
        Map<Field, Object> propertiesAndNonDefaultValues = TestUtils.getPropertiesAndValues(clazz, exclusions, false, useInheritedFields);
        TestUtils.testEquals(instance, other, propertiesAndDefaultValues, propertiesAndNonDefaultValues);
    }

    private static <T> Map<Field, Object> getPropertiesAndValues(Class<T> clazz, Set<String> exclusions, boolean defaultValues) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return TestUtils.getPropertiesAndValues(clazz, exclusions, defaultValues, false);
    }

    public static <T extends Model> void testClone(T instance, Object[] propertiesAndDefaultValues) {
        for (int i = 0; i < propertiesAndDefaultValues.length; i += 2) {
            String field = (String)propertiesAndDefaultValues[i];
            Object value = propertiesAndDefaultValues[i + 1];
            Whitebox.setInternalState(instance, (String)field, (Object)value);
        }
        Model cloned = (Model)instance.clone();
        for (int i = 0; i < propertiesAndDefaultValues.length; i += 2) {
            String field = (String)propertiesAndDefaultValues[i];
            Object value = propertiesAndDefaultValues[i + 1];
            Assert.assertEquals((Object)Whitebox.getInternalState((Object)cloned, (String)field), (Object)value, (String)("the value of the clone and the cloned instances must be se same for field " + field));
        }
    }

    public static <T> void testBuilders(Class<T> clazz, Set<String> exclusions) throws Exception {
        Map<Field, Object> propertiesAndNonDefaultValues = TestUtils.getPropertiesAndValues(clazz, exclusions, false, true);
        Object instance = null;
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException ex) {
            instance = Whitebox.newInstance(clazz);
        }
        for (Field field : propertiesAndNonDefaultValues.keySet()) {
            Method[] methods = new Method[]{};
            try {
                methods = PowerMockito.methods(instance.getClass(), (String[])new String[]{field.getName()});
            }
            catch (MethodNotFoundException ex) {
                continue;
            }
            for (Method method : methods) {
                Object value;
                if (method.getParameterTypes().length != 1 || (value = propertiesAndNonDefaultValues.get(field)) == null || !method.getParameterTypes()[0].isAssignableFrom(value.getClass())) continue;
                Object res = Whitebox.invokeMethod((Object)instance, (String)field.getName(), (Object[])new Object[]{value});
                Assert.assertEquals((Object)Whitebox.getInternalState((Object)res, (String)field.getName()), (Object)value, (String)("the value of the field must be the one that has just be set:" + field));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void testCommonMethods(Class<T> clazz, Set<String> exclusions) throws Exception {
        Constructor[] constructors;
        Object instance = null;
        for (Constructor constructor : constructors = PowerMockito.constructorsDeclaredIn(clazz, (Class[])new Class[0])) {
            Class[] types = constructor.getParameterTypes();
            ArrayList<Object> parameters = new ArrayList<Object>();
            for (Class<?> clazz2 : types) {
                parameters.add(TestUtils.getTypeNonDefaultValue(clazz2));
            }
            try {
                instance = Whitebox.invokeConstructor(clazz, (Class[])types, (Object[])parameters.toArray());
            }
            catch (Exception exx) {
                LOGGER.log(Level.INFO, exx.getMessage(), exx);
            }
        }
        if (instance == null) {
            try {
                instance = clazz.newInstance();
            }
            catch (InstantiationException ex) {
                LOGGER.log(Level.INFO, ex.getMessage(), ex);
                instance = Whitebox.newInstance(clazz);
            }
        }
        Method[] methods = new Method[]{};
        try {
            methods = PowerMockito.methodsDeclaredIn(instance.getClass(), (Class[])new Class[0]);
        }
        catch (MethodNotFoundException ex) {
            LOGGER.log(Level.INFO, ex.getMessage(), ex);
        }
        HashSet<String> commonMethodNames = new HashSet<String>(Arrays.asList("_default", "_enum", "example", "vendorExtension", "setEnum"));
        for (Method method : methods) {
            void var13_32;
            if (!commonMethodNames.contains(method.getName()) || exclusions != null && exclusions.contains(method.getName())) continue;
            System.out.println("testing common method: " + method);
            List<Object> parameters = new ArrayList<Object>();
            Class<?>[] types = method.getParameterTypes();
            if (types.length <= 2) {
                for (Class<?> type : types) {
                    parameters.add(TestUtils.getTypeNonDefaultValue(type));
                }
            }
            if (method.getName().equals("vendorExtension")) {
                parameters = Arrays.asList("x-vendor", "value");
            }
            Object[] parametersArray = parameters.toArray();
            String string = method.getName();
            if (method.getName().startsWith("set")) {
                String string2 = "g" + string.substring(1);
            } else {
                void var13_29;
                if (string.startsWith("_")) {
                    String string3 = string.substring(1);
                }
                String string4 = "get" + var13_29.substring(0, 1).toUpperCase() + var13_29.substring(1);
                if (parameters.size() > 1) {
                    String string5 = string4 + "s";
                }
            }
            Object value = parametersArray[0];
            boolean testWithUnknownString = false;
            if (parameters.size() == 1) {
                Method getMethod = null;
                try {
                    getMethod = PowerMockito.method(clazz, (String)var13_32, (Class[])new Class[0]);
                }
                catch (MethodNotFoundException ex) {
                    LOGGER.log(Level.INFO, ex.getMessage());
                    continue;
                }
                Class<String> retType = getMethod.getReturnType();
                if (value instanceof String && !retType.isAssignableFrom(String.class)) {
                    parametersArray[0] = value = TestUtils.getTypeNonDefaultValue(retType).toString();
                    testWithUnknownString = true;
                }
            }
            try {
                Whitebox.setInternalState((Object)instance, (String)"_enum", null);
            }
            catch (FieldNotFoundException ex) {
                LOGGER.log(Level.INFO, ex.getMessage());
            }
            Whitebox.invokeMethod((Object)instance, (String)method.getName(), (Object[])parametersArray);
            Object res = Whitebox.invokeMethod((Object)instance, (String)var13_32, (Object[])new Object[0]);
            if (parameters.size() > 1 && res instanceof Map) {
                res = ((Map)res).get(parameters.get(0));
                value = parameters.get(1);
            }
            if (value == null) {
                Assert.assertNull((Object)res, (String)("the value returned by " + (String)var13_32 + " must be null as we set it null through " + method));
            } else if (res instanceof Collection) {
                Assert.assertTrue((((Collection)res).contains(value) || res.equals(value) ? 1 : 0) != 0, (String)("the value returned by " + (String)var13_32 + " must contain the value set by " + method));
            } else {
                Assert.assertEquals((String)res.toString(), (String)value.toString(), (String)("the value returned by " + (String)var13_32 + " must be the same set by " + method));
            }
            if (!testWithUnknownString) continue;
            parametersArray[0] = value = "unknown string";
            Object actual = Whitebox.invokeMethod((Object)instance, (String)var13_32, (Object[])new Object[0]);
            Whitebox.invokeMethod((Object)instance, (String)method.getName(), (Object[])parametersArray);
            res = Whitebox.invokeMethod((Object)instance, (String)var13_32, (Object[])new Object[0]);
            Assert.assertEquals((Object)actual, (Object)res, (String)("the value must not change when passing an unknown value to " + method));
        }
    }

    public static <T> void testEquals(T instance, T other, Map<Field, Object> propertiesAndDefaultValues, Map<Field, Object> propertiesAndNonDefaultValues) {
        Assert.assertTrue((boolean)instance.equals(instance), (String)"an instance must be equals to itself");
        Assert.assertFalse((boolean)instance.equals(null), (String)"an instance must not be equals to null");
        Assert.assertFalse((boolean)instance.equals(new Object()), (String)"an instance must not be equals to an object of another class");
        for (Field field : propertiesAndDefaultValues.keySet()) {
            for (Field otherField : propertiesAndDefaultValues.keySet()) {
                if (field.equals(otherField)) continue;
                Whitebox.setInternalState(other, (String)otherField.getName(), (Object)propertiesAndNonDefaultValues.get(otherField));
                Whitebox.setInternalState(instance, (String)otherField.getName(), (Object)propertiesAndNonDefaultValues.get(otherField));
            }
            Object nonDefaultValue = propertiesAndNonDefaultValues.get(field);
            Whitebox.setInternalState(other, (String)field.getName(), (Object)nonDefaultValue);
            Object defaultValue = propertiesAndDefaultValues.get(field);
            Whitebox.setInternalState(instance, (String)field.getName(), (Object)defaultValue);
            boolean equals = instance.equals(other);
            Assert.assertFalse((boolean)equals, (String)("an instance can not be equals to another if they don't have the same values for the involved fields:" + field));
            Assert.assertFalse((boolean)other.equals(instance), (String)"an instance can not be equals to another if they don't have the same values for the involved fields");
            Assert.assertEquals((int)instance.hashCode(), (int)instance.hashCode(), (String)"hashcode must be consinstent between calls");
            Whitebox.setInternalState(instance, (String)field.getName(), (Object)nonDefaultValue);
        }
        Assert.assertTrue((boolean)instance.equals(other), (String)("if they have the same values, then the two instances must be equals: " + instance.getClass()));
        Assert.assertEquals((int)instance.hashCode(), (int)other.hashCode(), (String)"if two instances are equals, then they must have the same hashcode");
    }

    public static final Object getTypeDefaultValue(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return 0;
        }
        if (clazz == Short.TYPE) {
            return 0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    public static final <T> Object getTypeNonDefaultValue(Class<T> clazz) {
        if (clazz == Byte.TYPE) {
            return 1;
        }
        if (clazz == Short.TYPE) {
            return 1;
        }
        if (clazz == Integer.TYPE) {
            return 1;
        }
        if (clazz == Long.TYPE) {
            return 1L;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('z');
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(1.0f);
        }
        if (clazz == Double.TYPE) {
            return 1.0;
        }
        if (clazz == Boolean.TYPE) {
            return true;
        }
        if (clazz == String.class) {
            return "non null string";
        }
        if (clazz.equals(List.class)) {
            return new ArrayList();
        }
        if (clazz.isEnum()) {
            try {
                Object[] values = (Object[])Whitebox.invokeMethod(clazz, (String)"values", (Object[])new Object[0]);
                return values[0];
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, e.getMessage(), e);
            }
        }
        return PowerMockito.mock(clazz);
    }
}

