/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models;

import io.swagger.models.AbstractModel;
import io.swagger.models.ExternalDocs;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.Property;
import java.util.HashMap;
import java.util.Map;
import org.powermock.reflect.Whitebox;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractModelTest {
    private AbstractModel instance;
    private AbstractModel other;

    @BeforeMethod
    public void setUp() throws Exception {
        this.instance = new MyAbstractModel();
        ExternalDocs externalDocs = new ExternalDocs();
        this.instance.setExternalDocs(externalDocs);
        HashMap vendorExtensions = new HashMap();
        Whitebox.setInternalState((Object)this.instance, (String)"vendorExtensions", vendorExtensions);
        this.other = new MyAbstractModel();
        this.other.setExternalDocs(externalDocs);
        Whitebox.setInternalState((Object)this.other, (String)"vendorExtensions", vendorExtensions);
    }

    @Test
    public void testEqualsObject() {
        Assert.assertTrue((boolean)this.instance.equals((Object)this.instance), (String)"An instance must be equals to itself");
        Assert.assertFalse((boolean)this.instance.equals(null), (String)"An instance must not be equals to null");
        Assert.assertFalse((boolean)this.instance.equals(new Object()), (String)"An instance must not be equals to an object of another class");
        Assert.assertTrue((boolean)this.instance.equals((Object)this.other), (String)"Instances having the same field values must be equals");
    }

    @Test
    public void testEqualsWithDifferentExternalDocs() {
        this.instance.setExternalDocs(null);
        Assert.assertFalse((boolean)this.instance.equals((Object)this.other), (String)"Instance with null externaldocs can not equals other with non null external docs");
        Assert.assertFalse((boolean)this.other.equals((Object)this.instance), (String)"Instance with non null externaldocs can not equals other with  null external docs");
    }

    @Test
    public void testEqualsWithDifferentVendorExtensions() {
        Whitebox.setInternalState((Object)this.instance, (String)"vendorExtensions", (Object)null);
        Assert.assertFalse((boolean)this.instance.equals((Object)this.other), (String)"Instance with null vendorExtensions can not equals other with non null vendorExtensions");
        Assert.assertFalse((boolean)this.other.equals((Object)this.instance), (String)"Instance with non null vendorExtensions can not equals other with  null vendorExtensions");
    }

    @Test
    public void testEqualsAndHashCode() {
        ExternalDocs externalDocs = new ExternalDocs();
        this.instance.setExternalDocs(externalDocs);
        this.other.setExternalDocs(externalDocs);
        Assert.assertEquals((Object)this.instance, (Object)this.other, (String)"The two instances must be equal since they have the same externalDocs");
        Assert.assertEquals((int)this.instance.hashCode(), (int)this.other.hashCode(), (String)"Hash code value must be the same since the two instances have the same externalDocs");
    }

    @Test
    public void testGetExternalDocs() {
        ExternalDocs value = new ExternalDocs();
        this.instance.setExternalDocs(value);
        Assert.assertEquals((Object)value, (Object)this.instance.getExternalDocs(), (String)"The instance externalDocs must be the one that have been set");
    }

    @Test
    public void testGetTitle() {
        String title = "title";
        this.instance.setTitle(title);
        Assert.assertEquals((String)title, (String)this.instance.getTitle(), (String)"The instance title must be the one that have been set");
    }

    @Test
    public void testGetVendorExtensions() {
        String name = "x-name";
        String value = "value";
        this.instance.setVendorExtension(name, (Object)value);
        Assert.assertEquals((Object)value, this.instance.getVendorExtensions().get(name), (String)"Must be able to retrieve the value from the map");
    }

    @Test
    public void testCloneTo() {
        ModelImpl clone = new ModelImpl();
        ExternalDocs externalDocs = new ExternalDocs();
        this.instance.setExternalDocs(externalDocs);
        this.instance.cloneTo((Object)clone);
        Assert.assertEquals((Object)externalDocs, (Object)clone.getExternalDocs(), (String)"The instance and the clone must have the same value");
    }

    @Test
    public void testClone() {
        Assert.assertNull((Object)this.instance.clone(), (String)"The default clone method from abstract model must return null");
    }

    @Test
    public void testGetReference() {
        String reference = "reference";
        this.instance.setReference(reference);
        Assert.assertEquals((String)reference, (String)this.instance.getReference(), (String)"The obtained reference value must be the same that we have set");
    }

    private static class MyAbstractModel
    extends AbstractModel {
        private MyAbstractModel() {
        }

        public String getDescription() {
            return null;
        }

        public void setDescription(String description) {
        }

        public Map<String, Property> getProperties() {
            return null;
        }

        public void setProperties(Map<String, Property> properties) {
        }

        public Object getExample() {
            return null;
        }

        public void setExample(Object example) {
        }
    }
}

