/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models;

import io.swagger.TestUtils;
import io.swagger.models.ModelImpl;
import io.swagger.models.Xml;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockTestCase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@PrepareForTest(value={})
public class ModelImplTest
extends PowerMockTestCase {
    private ModelImpl instance;
    Object[] propertiesAndValues;

    @BeforeMethod
    public void setUp() throws Exception {
        this.instance = new ModelImpl();
        this.propertiesAndValues = new Object[]{"additionalProperties", new ArrayProperty(), "description", "description", "discriminator", "discriminator", "example", new Object(), "format", "format", "isSimple", true, "name", "name", "properties", new HashMap(), "required", new ArrayList(), "type", "type", "xml", new Xml(), "defaultValue", "defaultValue"};
    }

    @Test
    public void testClone() {
        this.propertiesAndValues = new Object[]{"additionalProperties", new ArrayProperty(), "description", "description", "discriminator", "discriminator", "example", new Object(), "isSimple", true, "name", "name", "properties", new HashMap(), "required", new ArrayList(), "type", "type", "xml", new Xml(), "defaultValue", "defaultValue"};
        TestUtils.testClone(this.instance, this.propertiesAndValues);
    }

    @Test
    public void testGetProperties() {
        Assert.assertNull((Object)this.instance.getProperties(), (String)"New instance must have null as properties");
    }

    @Test
    public void testEnum() {
        ArrayList _enum = new ArrayList();
        Assert.assertEquals((Collection)this.instance._enum(_enum).getEnum(), _enum);
        this.instance.setEnum(null);
        String value = "value";
        this.instance._enum(value);
        Assert.assertTrue((boolean)this.instance.getEnum().contains(value), (String)"The enums list must contain the new one");
    }

    @Test
    public void testConstructor() {
        this.instance = new ModelImpl();
        Assert.assertNull((Object)this.instance.getDiscriminator(), (String)"New instance must have null discriminator");
        Assert.assertNull((Object)this.instance.getDescription(), (String)"New instance must have null description");
        Assert.assertFalse((boolean)this.instance.isSimple(), (String)"New instance must not be simple");
        Assert.assertNull((Object)this.instance.getAdditionalProperties(), (String)"New instance must have null additionalProperties");
        Assert.assertNull((Object)this.instance.getExample(), (String)"New instance must have null example");
        Assert.assertNull((Object)this.instance.getDefaultValue(), (String)"New instance must have null default value");
        Assert.assertNull((Object)this.instance.getXml(), (String)"New instance must have null Xml");
    }

    @Test
    public void testProperty() {
        String key = "key";
        ArrayProperty property = new ArrayProperty();
        this.instance.property(key, (Property)property);
        Assert.assertEquals(this.instance.getProperties().get(key), (Object)property, (String)"Must be able to retrieve the set value from the map");
        Assert.assertTrue((boolean)this.instance.required(key).getRequired().contains(key), (String)"The set key must be contained in the required list");
    }

    @Test
    public void testSetRequired() {
        String required = "required";
        ArrayProperty property = new ArrayProperty();
        this.instance.property(required, (Property)property);
        this.instance.setRequired(Arrays.asList(required));
        Assert.assertTrue((boolean)this.instance.getRequired().contains(required), (String)"The set key must be contained in the required list");
    }

    @Test
    public void testAddProperty() {
        String badKey = "badKey";
        String key = "key";
        ArrayProperty property = new ArrayProperty();
        this.instance.property(key, (Property)property);
        this.instance.addProperty(badKey, null);
        Assert.assertNull(this.instance.getProperties().get(badKey), (String)"The bad key must not be added to the properties");
        this.instance.setRequired(Arrays.asList(key));
        this.instance.addProperty(key, (Property)property);
        Assert.assertEquals(this.instance.getProperties().get(key), (Object)property, (String)"Must be able to retrieve the set value from the map");
    }

    @Test
    public void testAddRequiredOnNonExistingProperty() {
        String badPropertyName = "missingProperty";
        String key = "key";
        ArrayProperty property = new ArrayProperty();
        this.instance.property(key, (Property)property);
        this.instance.addRequired(key);
        Assert.assertEquals((int)1, (int)this.instance.getRequired().size());
        Assert.assertEquals((int)1, (int)this.instance.getSpecSpecifiedRequired().size());
        this.instance.addRequired(badPropertyName);
        Assert.assertEquals((int)1, (int)this.instance.getRequired().size());
        Assert.assertEquals((int)2, (int)this.instance.getSpecSpecifiedRequired().size());
    }
}

