/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models;

import io.swagger.TestUtils;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OperationTest {
    private Operation operation;

    @BeforeMethod
    public void setup() {
        this.operation = new Operation();
    }

    @Test
    public void testBuilders() throws Exception {
        TestUtils.testBuilders(Operation.class, new HashSet<String>(Arrays.asList("deprecated", "vendorExtensions")));
    }

    @Test
    public void testAddScheme() {
        this.operation.addScheme(Scheme.HTTP);
        Assert.assertTrue((boolean)this.operation.getSchemes().contains(Scheme.HTTP), (String)"The newly added scheme must be contained in the schemes list");
    }

    @Test
    public void testScheme() {
        this.operation.scheme(Scheme.HTTPS);
        Assert.assertTrue((boolean)this.operation.getSchemes().contains(Scheme.HTTPS), (String)"The newly added scheme must be contained in the schemes list");
    }

    @Test
    public void testConsumes() {
        this.operation.consumes("consumes");
        Assert.assertTrue((boolean)this.operation.getConsumes().contains("consumes"), (String)"The newly added consumes must be contained in the consumes list");
    }

    @Test
    public void testProduces() {
        this.operation.produces("produces");
        Assert.assertTrue((boolean)this.operation.getProduces().contains("produces"), (String)"The newly added produces must be contained in the produces list");
    }

    @Test
    public void testSecurity() {
        SecurityRequirement requirement = new SecurityRequirement();
        requirement.setName("name");
        requirement.setScopes(new ArrayList());
        this.operation.security(requirement);
        Assert.assertTrue((boolean)((Map)this.operation.getSecurity().get(0)).keySet().contains("name"), (String)"The newly added name must be contained in the security list");
        requirement.setScopes(null);
        this.operation.security(requirement);
        Assert.assertTrue((boolean)((List)((Map)this.operation.getSecurity().get(1)).get("name")).isEmpty(), (String)"The security requirement added with a null scope must be empty");
    }

    @Test
    public void testParameter() {
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        this.operation.setParameters(null);
        this.operation.parameter(parameter);
        Assert.assertTrue((boolean)this.operation.getParameters().contains(parameter), (String)"The newly added parameter must be contained in the parameters list");
    }

    @Test
    public void testResponse() {
        Response response = (Response)Mockito.mock(Response.class);
        this.operation.response(44, response);
        Assert.assertEquals((Object)this.operation.getResponsesObject().get((Object)"44"), (Object)response, (String)"The newly added response must be contained in the responses map");
        Assert.assertEquals(this.operation.getResponses().get("44"), (Object)response, (String)"The newly added response must be contained in the responses map");
    }

    @Test
    public void testDefaultResponse() {
        Response response = (Response)Mockito.mock(Response.class);
        this.operation.defaultResponse(response);
        Assert.assertEquals((Object)this.operation.getResponsesObject().get((Object)"default"), (Object)response, (String)"The default response should be the one that have just been set");
    }

    @Test
    public void testDeprecated() {
        this.operation.deprecated(Boolean.valueOf(false));
        Assert.assertFalse((boolean)this.operation.isDeprecated(), (String)"Must have deprecated false after set to false");
    }

    @Test
    public void testSetDeprecated() {
        this.operation.setDeprecated(Boolean.valueOf(true));
        Assert.assertTrue((boolean)this.operation.isDeprecated(), (String)"Must be deprecated after set to true");
    }

    @Test
    public void testVendorExtensions() {
        String vendorName = "x-vendor";
        String value = "value";
        this.operation.setVendorExtension(vendorName, (Object)value);
        this.operation.vendorExtensions(new HashMap());
        Assert.assertEquals(this.operation.getVendorExtensions().get(vendorName), (Object)value, (String)"Must be able to retrieve the same value from the map");
    }

    @Test
    public void testTag() {
        this.operation.tag("tag");
        Assert.assertTrue((boolean)this.operation.getTags().contains("tag"), (String)"The newly tag  must be contained in the tags list");
    }

    @Test
    public void testSetSummary() {
        this.operation.setSummary("summary");
        Assert.assertEquals((String)this.operation.getSummary(), (String)"summary", (String)"The get summary must equal the set one");
    }

    @Test
    public void testSetDescription() {
        this.operation.setDescription("description");
        Assert.assertEquals((String)this.operation.getDescription(), (String)"description", (String)"The get description must equal the set one");
    }

    @Test
    public void testSetOperationId() {
        this.operation.setOperationId("operationId");
        Assert.assertEquals((String)this.operation.getOperationId(), (String)"operationId", (String)"The get OperaionId must equal the set one");
    }

    @Test
    public void testSetExternalDocs() {
        ExternalDocs externalDocs = new ExternalDocs();
        this.operation.setExternalDocs(externalDocs);
        Assert.assertEquals((Object)this.operation.getExternalDocs(), (Object)externalDocs, (String)"The get externalDocs must equal the set one");
    }
}

