/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models;

import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.parameters.Parameter;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PathTest {
    @Test
    public void testOperations() {
        Path path = new Path();
        Assert.assertTrue((boolean)path.isEmpty(), (String)"A new path must be empty");
        Operation get = new Operation();
        path.set("get", get);
        Assert.assertFalse((boolean)path.isEmpty(), (String)"A path with operations must not be empty");
        Assert.assertTrue((boolean)path.getOperations().contains(get), (String)"The path must contain the operations that have been put");
        Assert.assertEquals(path.getOperationMap().get(HttpMethod.GET), (Object)get, (String)"The operation that has been put must be the same that we get");
        Operation put = new Operation();
        path.set("put", put);
        Assert.assertTrue((boolean)path.getOperations().contains(put), (String)"The path must contain the operations that have been put");
        Assert.assertEquals(path.getOperationMap().get(HttpMethod.PUT), (Object)get, (String)"The operation that has been put must be the same that we get");
        Operation post = new Operation();
        path.set("post", post);
        Assert.assertTrue((boolean)path.getOperations().contains(post), (String)"The path must contain the operations that have been put");
        Assert.assertEquals(path.getOperationMap().get(HttpMethod.POST), (Object)get, (String)"The operation that has been put must be the same that we get");
        Operation head = new Operation();
        path.set("head", head);
        Assert.assertTrue((boolean)path.getOperations().contains(head), (String)"The path must contain the operations that have been put");
        Assert.assertEquals(path.getOperationMap().get(HttpMethod.HEAD), (Object)get, (String)"The operation that has been put must be the same that we get");
        Operation delete = new Operation();
        path.set("delete", delete);
        Assert.assertTrue((boolean)path.getOperations().contains(delete), (String)"The path must contain the operations that have been put");
        Assert.assertEquals(path.getOperationMap().get(HttpMethod.DELETE), (Object)get, (String)"The operation that has been put must be the same that we get");
        Operation patch = new Operation();
        path.set("patch", patch);
        Assert.assertTrue((boolean)path.getOperations().contains(patch), (String)"The path must contain the operations that have been put");
        Assert.assertEquals(path.getOperationMap().get(HttpMethod.PATCH), (Object)get, (String)"The operation that has been put must be the same that we get");
        Operation options = new Operation();
        path.set("options", options);
        Assert.assertTrue((boolean)path.getOperations().contains(options), (String)"The path must contain the operations that have been put");
        Assert.assertEquals(path.getOperationMap().get(HttpMethod.OPTIONS), (Object)get, (String)"The operation that has been put must be the same that we get");
        Path operation = path.set("", null);
        Assert.assertNull((Object)operation, (String)"The returned operation must be null as we set an unknown method");
    }

    @Test
    public void testParameters() {
        Path path = new Path();
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        path.setParameters(null);
        path.addParameter(parameter);
        Assert.assertTrue((boolean)path.getParameters().contains(parameter), (String)"The parameters list must contain the newly added one");
    }

    @Test
    public void testSetVendorExtension() {
        Path path = new Path();
        String vendorName = "x-vendor";
        String value = "value";
        path.setVendorExtension(vendorName, (Object)value);
        Assert.assertEquals(path.getVendorExtensions().get(vendorName), (Object)value, (String)"Must be able to retrieve the same value from the map");
    }
}

