/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models;

import io.swagger.models.ComposedModel;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Model;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SwaggerTest {
    private Swagger swagger;
    private SecurityRequirement requirement;

    @BeforeMethod
    public void setup() {
        this.swagger = new Swagger();
        this.requirement = new SecurityRequirement();
    }

    @Test
    public void testAddScheme() {
        this.swagger.addScheme(Scheme.HTTP);
        Assert.assertTrue((boolean)this.swagger.getSchemes().contains(Scheme.HTTP), (String)"The newly added scheme must be contained in the schemes list");
    }

    @Test
    public void testScheme() {
        this.swagger.scheme(Scheme.HTTPS);
        Assert.assertTrue((boolean)this.swagger.getSchemes().contains(Scheme.HTTPS), (String)"The newly added scheme must be contained in the schemes list");
    }

    @Test
    public void testConsumes() {
        this.swagger.consumes("consumes");
        Assert.assertTrue((boolean)this.swagger.getConsumes().contains("consumes"), (String)"The newly added consumes must be contained in the consumes list");
    }

    @Test
    public void testProduces() {
        this.swagger.produces("produces");
        Assert.assertTrue((boolean)this.swagger.getProduces().contains("produces"), (String)"The newly added produces must be contained in the produces list");
    }

    @Test
    public void testSecurity() {
        this.swagger.security(this.requirement);
        Assert.assertTrue((boolean)this.swagger.getSecurity().contains(this.requirement), (String)"The newly added requiement must be contained in the requiements list");
    }

    @Test
    public void testSetSecurityRequirement() {
        this.swagger.setSecurityRequirement(new ArrayList<SecurityRequirement>(Arrays.asList(this.requirement)));
        Assert.assertTrue((boolean)this.swagger.getSecurity().contains(this.requirement), (String)"The newly added requiement must be contained in the requiement list");
    }

    @Test
    public void testAddSecurityDefinition() {
        this.swagger.addSecurityDefinition(this.requirement);
        Assert.assertTrue((boolean)this.swagger.getSecurity().contains(this.requirement), (String)"The newly added requiement must be contained in the requiement list");
    }

    @Test
    public void testParameter() {
        Parameter parameter = (Parameter)Mockito.mock(Parameter.class);
        this.swagger.setParameters(null);
        String key = "key";
        Assert.assertNull((Object)this.swagger.getParameter(key), (String)"Cannot retrieve a key without adding it first");
        this.swagger.parameter(key, parameter);
        Assert.assertEquals(this.swagger.getParameters().get(key), (Object)parameter, (String)"Must be able to retrieve the added key");
        Assert.assertEquals((Object)this.swagger.getParameter(key), (Object)parameter, (String)"Must be able to retrieave the added key");
    }

    @Test
    public void testResponse() {
        Response response = (Response)Mockito.mock(Response.class);
        this.swagger.response("44", response);
        Assert.assertEquals(this.swagger.getResponses().get("44"), (Object)response, (String)"Must be able to retrieve the added response");
    }

    @Test
    public void testVendorExtension() {
        String vendorName = "x-vendor";
        String value = "value";
        this.swagger.vendorExtension(vendorName, (Object)value);
        this.swagger.vendorExtensions(new HashMap());
        Assert.assertEquals(this.swagger.getVendorExtensions().get(vendorName), (Object)value, (String)"Must be able to retrieve the same value from the map");
        this.swagger.setVendorExtension(vendorName, (Object)value);
        Assert.assertEquals(this.swagger.getVendorExtensions().get(vendorName), (Object)value, (String)"Must be able to retrieve the same value from the map");
        this.swagger.vendorExtensions(null);
        Assert.assertEquals(this.swagger.getVendorExtensions().get(vendorName), (Object)value, (String)"Must be able to retrieve the same value from the map");
        this.swagger = new Swagger();
        this.swagger.vendorExtensions(new HashMap());
        Assert.assertNull(this.swagger.getVendorExtensions().get(vendorName), (String)"Can not retrieve the key from an empty map");
    }

    @Test
    public void testTag() {
        Tag tag = new Tag();
        tag.setName("name");
        this.swagger.tag(tag);
        Assert.assertTrue((boolean)this.swagger.getTags().contains(tag), (String)"The newly added tag must be contained in the tags list");
        this.swagger.tag(tag);
        Assert.assertTrue((boolean)this.swagger.getTags().contains(tag), (String)"The newly added tag must be contained in the tags list");
        this.swagger.tags(Arrays.asList(tag));
        Assert.assertTrue((boolean)this.swagger.getTags().contains(tag), (String)"The newly added tag must be contained in the tags list");
    }

    @Test
    public void testSetExternalDocs() {
        ExternalDocs externalDocs = new ExternalDocs();
        this.swagger.setExternalDocs(externalDocs);
        Assert.assertEquals((Object)this.swagger.getExternalDocs(), (Object)externalDocs, (String)"The get externalDocs must be the same as the set one");
    }

    @Test
    public void testPath() {
        String key = "key";
        this.swagger.setPaths(null);
        Assert.assertNull((Object)this.swagger.getPaths(), (String)"If paths is set to null, then it must resolve to null");
        Assert.assertNull((Object)this.swagger.getPath(key), (String)"If paths is set to null, then you cannot retrieve any key from it");
        Path path = new Path();
        this.swagger.path(key, path);
        Assert.assertEquals(this.swagger.getPaths().get(key), (Object)path, (String)"Must be able to retrieve the path");
        Assert.assertEquals((Object)this.swagger.getPath(key), (Object)path, (String)"Must be able to retrieve the path");
    }

    @Test
    public void testSecurityDefinition() {
        BasicAuthDefinition securityDefinition = new BasicAuthDefinition();
        String name = "name";
        this.swagger.securityDefinition(name, (SecuritySchemeDefinition)securityDefinition);
        Assert.assertEquals(this.swagger.getSecurityDefinitions().get(name), (Object)securityDefinition, (String)"Must be able to retrieve the added security definition");
    }

    @Test
    public void testModel() {
        ComposedModel model = new ComposedModel();
        String name = "name";
        this.swagger.model(name, (Model)model);
        Assert.assertEquals(this.swagger.getDefinitions().get(name), (Object)model, (String)"Must be able to retrieve the added model");
    }
}

