/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.auth;

import io.swagger.models.auth.OAuth2Definition;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OAuth2DefinitionTest {
    private OAuth2Definition auth2Definition = new OAuth2Definition();
    private String tokenUrl = "tokenUrl";
    private String authorizationUrl = "authorizationUrl";
    private String name = "name";
    private String description = "description";

    @Test
    public void testImplicit() {
        this.auth2Definition.implicit(this.authorizationUrl);
        Assert.assertEquals((String)this.auth2Definition.getAuthorizationUrl(), (String)this.authorizationUrl, (String)"The get authorization must be the same as the set one");
        Assert.assertEquals((String)this.auth2Definition.getFlow(), (String)"implicit", (String)"Flow must be implicit after calling implicit()");
    }

    @Test
    public void testPassword() {
        this.auth2Definition.password(this.tokenUrl);
        Assert.assertEquals((String)this.auth2Definition.getTokenUrl(), (String)this.tokenUrl, (String)"The getTokenUrl must be the same as the set one");
        Assert.assertEquals((String)this.auth2Definition.getFlow(), (String)"password", (String)"Flow must be password after calling password()");
    }

    @Test
    public void testApplication() {
        this.auth2Definition.application(this.tokenUrl);
        Assert.assertEquals((String)this.auth2Definition.getTokenUrl(), (String)this.tokenUrl, (String)"The getTokenUrl must be the same as the set one");
        Assert.assertEquals((String)this.auth2Definition.getFlow(), (String)"application", (String)"Flow must be application after calling application()");
    }

    @Test
    public void testAccessCode() {
        this.auth2Definition.accessCode(this.authorizationUrl, this.tokenUrl);
        Assert.assertEquals((String)this.auth2Definition.getTokenUrl(), (String)this.tokenUrl, (String)"The getTokenUrl must be the same as the set one");
        Assert.assertEquals((String)this.auth2Definition.getAuthorizationUrl(), (String)this.authorizationUrl, (String)"The get authorizationUrl must be the same as the set one");
        Assert.assertEquals((String)this.auth2Definition.getFlow(), (String)"accessCode", (String)"Flow must be accessCode after calling accessCode()");
    }

    @Test
    public void testScope() {
        this.auth2Definition.scope(this.name, this.description);
        Assert.assertEquals((String)((String)this.auth2Definition.getScopes().get(this.name)), (String)this.description, (String)"Must be able to retrieve the set scope");
    }
}

