/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.parameters;

import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractSerializableParameterTest {
    private AbstractSerializableParameter<?> instance;
    private String example;
    private Object defaultValue;

    @BeforeMethod
    public void setup() {
        this.instance = new CookieParameter();
        this.defaultValue = null;
    }

    @Test
    public void testGettersAndSetters() {
        String type = "type";
        this.instance.setType(type);
        Assert.assertEquals((String)this.instance.getType(), (String)type, (String)"The get type must be the same as the set one");
        String format = "format";
        this.instance.setFormat(format);
        Assert.assertEquals((String)this.instance.getFormat(), (String)format, (String)"The get format must be the same as the set one");
        String collectionFormat = "collectionFormat";
        this.instance.setCollectionFormat(collectionFormat);
        Assert.assertEquals((String)this.instance.getCollectionFormat(), (String)collectionFormat, (String)"The get collectionFormat must be the same as the set one");
        BooleanProperty items = new BooleanProperty();
        this.instance.setItems((Property)items);
        Assert.assertEquals((Object)this.instance.getItems(), (Object)items, (String)"The get items must be the same as the set one");
        List<String> _enum = Arrays.asList("_enum");
        this.instance._enum(_enum);
        this.instance.setEnum(_enum);
        Assert.assertEquals((Collection)this.instance.getEnum(), _enum, (String)"The get _enum must be the same as the set one");
        Boolean exclusiveMaximum = true;
        this.instance.setExclusiveMaximum(exclusiveMaximum);
        Assert.assertEquals((Boolean)this.instance.isExclusiveMaximum(), (Boolean)exclusiveMaximum, (String)"The get exclusiveMaximum must be the same as the set one");
        Double maximum = 1.0;
        this.instance.setMaximum(new BigDecimal(maximum));
        Assert.assertEquals((Object)this.instance.getMaximum(), (Object)new BigDecimal(maximum), (String)"The get maximum must be the same as the set one");
        Boolean exclusiveMinimum = true;
        this.instance.setExclusiveMinimum(exclusiveMinimum);
        Assert.assertEquals((Boolean)this.instance.isExclusiveMinimum(), (Boolean)exclusiveMinimum, (String)"The get exclusiveMinimum must be the same as the set one");
        Double minimum = 0.1;
        this.instance.setMinimum(new BigDecimal(minimum));
        Assert.assertEquals((Object)this.instance.getMinimum(), (Object)new BigDecimal(minimum), (String)"The get minimum must be the same as the set one");
        String example = "example";
        this.instance.setExample(example);
        Assert.assertEquals((Object)this.instance.getExample(), (Object)example, (String)"The get example must be the same as the set one");
        Integer maxItems = 100;
        this.instance.setMaxItems(maxItems);
        Assert.assertEquals((Integer)this.instance.getMaxItems(), (Integer)maxItems, (String)"The get maxItems must be the same as the set one");
        Integer minItems = 10;
        this.instance.setMinItems(minItems);
        Assert.assertEquals((Integer)this.instance.getMinItems(), (Integer)minItems, (String)"The get minItems must be the same as the set one");
        Integer maxLength = 500;
        this.instance.setMaxLength(maxLength);
        Assert.assertEquals((Integer)this.instance.getMaxLength(), (Integer)maxLength, (String)"The get maxLength must be the same as the set one");
        Integer minLength = 25;
        this.instance.setMinLength(minLength);
        Assert.assertEquals((Integer)this.instance.getMinLength(), (Integer)minLength, (String)"The get minLength must be the same as the set one");
        String pattern = "String pattern";
        this.instance.setPattern(pattern);
        Assert.assertEquals((String)this.instance.getPattern(), (String)pattern, (String)"The get pattern must be the same as the set one");
        Boolean uniqueItems = true;
        this.instance.setUniqueItems(uniqueItems);
        Assert.assertEquals((Boolean)this.instance.isUniqueItems(), (Boolean)uniqueItems, (String)"The get uniqueItems must be the same as the set one");
        Integer multipleOf = 5;
        this.instance.setMultipleOf((Number)multipleOf);
        Assert.assertEquals((Object)this.instance.getMultipleOf(), (Object)multipleOf, (String)"The get multipleOf must be the same as the set one");
        String defaultValue = "defaultValue";
        this.instance.setDefaultValue(defaultValue);
        Assert.assertEquals((Object)this.instance.getDefaultValue(), (Object)defaultValue, (String)"The get defaultValue must be the same as the set one");
        this.instance.required(true);
        Assert.assertTrue((boolean)this.instance.getRequired(), (String)"The get required must be the same as the set one");
        StringProperty property = new StringProperty();
        property._enum(_enum);
        this.instance.property((Property)property);
        Assert.assertEquals((Collection)this.instance.getEnum(), _enum, (String)"The get _enum must be the same as the set one");
        Assert.assertEquals((String)this.instance.getType(), (String)property.getType(), (String)"The get type must be the same as the set property type");
        ArrayProperty arrayProperty = new ArrayProperty();
        arrayProperty.items((Property)items);
        this.instance.property((Property)arrayProperty);
        Assert.assertEquals((Object)this.instance.getItems(), (Object)items, (String)"The get items must be the same as the set one");
        Assert.assertEquals((String)this.instance.getType(), (String)arrayProperty.getType(), (String)"The get type must be the same as the set property type");
        Assert.assertEquals((String)this.instance.getDefaultCollectionFormat(), (String)"csv", (String)"The get collection format must be csv");
    }

    @Test
    public void testGetDefaultWithBaseIntegerProperty() {
        this.instance.setProperty((Property)new BaseIntegerProperty());
        this.defaultValue = 14;
        this.instance.setDefault(this.defaultValue);
        Assert.assertEquals((Object)this.instance.getDefault(), (Object)14L, (String)"The get default must be the same as the set one");
    }

    @Test
    public void testGetDefaultWithDecimalProperty() {
        this.instance.setProperty((Property)new DecimalProperty());
        this.defaultValue = 14.1;
        this.instance.setDefault(this.defaultValue);
        Assert.assertEquals((Object)this.instance.getDefault(), (Object)14.1, (String)"The get default must be the same as the set one");
        this.defaultValue = "wrong format";
        this.instance.setDefault(this.defaultValue);
        Assert.assertEquals((Object)this.instance.getDefault(), (Object)this.defaultValue, (String)"The get default must be the same as the set one");
        this.instance.setProperty((Property)new ArrayProperty());
        Assert.assertEquals((Object)this.instance.getDefault(), (Object)this.defaultValue, (String)"Default must not change when we set an array property");
    }

    @Test
    public void testGetDefaultWithBooleanProperty() {
        this.instance.setProperty((Property)new BooleanProperty());
        this.defaultValue = true;
        this.instance.setDefault(this.defaultValue);
        Assert.assertEquals((Object)this.instance.getDefault(), (Object)true, (String)"The get default must be the same as the set one");
    }

    @Test
    public void testGetDefault() {
        Assert.assertNull((Object)this.instance.getDefault(), (String)"The default value must be null for any new instance");
    }

    @Test
    public void testGetExampleWithBaseIntegerProperty() {
        this.instance.setProperty((Property)new BaseIntegerProperty());
        String example = "14";
        this.instance.setExample(example);
        Assert.assertEquals((Object)this.instance.getExample(), (Object)14L, (String)"The get example must be the same as the set one");
    }

    @Test
    public void testGetExampleWithDecimalProperty() {
        this.instance.setProperty((Property)new DecimalProperty());
        this.example = "14.1";
        this.instance.setExample(this.example);
        Assert.assertEquals((Object)this.instance.getExample(), (Object)14.1, (String)"The get example must be the same as the set one");
        this.example = "wrong format";
        this.instance.setExample(this.example);
        Assert.assertEquals((Object)this.instance.getExample(), (Object)this.example, (String)"The example value must not change when the format is wrong");
        this.instance.setProperty((Property)new ArrayProperty());
        Assert.assertEquals((Object)this.instance.getExample(), (Object)this.example, (String)"The example value must not change when when set an array property");
    }

    @Test
    public void testGetExampleWithEmptyString() {
        this.instance.setProperty((Property)new LongProperty());
        this.example = null;
        this.instance.setExample(this.example);
        Assert.assertEquals((Object)this.instance.getExample(), null, (String)"The example must be null if the value is null");
        this.instance.setProperty((Property)new LongProperty());
        this.example = "";
        this.instance.setExample(this.example);
        Assert.assertEquals((Object)this.instance.getExample(), (Object)"", (String)"The example must be empty string if the value is an empty string");
    }

    @Test
    public void testGetExampleWithBooleanProperty() {
        this.instance.setProperty((Property)new BooleanProperty());
        this.example = "true";
        this.instance.setExample(this.example);
        Assert.assertEquals((Object)this.instance.getExample(), (Object)true, (String)"The get example must be the same as the set one");
    }

    @Test
    public void testGetExample() {
        Assert.assertNull((Object)this.instance.getExample(), (String)"A new instance example must be null");
    }
}

