/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.parameters;

import io.swagger.models.parameters.SerializableParameter;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SerializableParameterTest {
    private static final String REQUIRED_PARAMETER_METHODS = "requiredParameterMethods";

    @DataProvider(name="requiredParameterMethods")
    public Iterator<Object[]> createRequiredParameterMethods() {
        String[] requiredMethods = new String[]{"maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "multipleOf"};
        ArrayList<Object[]> resultList = new ArrayList<Object[]>(requiredMethods.length);
        for (String requiredMethod : requiredMethods) {
            resultList.add(new Object[]{requiredMethod});
        }
        return resultList.iterator();
    }

    @Test(dataProvider="requiredParameterMethods")
    public void testSerializableParameterReadMethod(String requiredParameter) {
        String errorMsg = "SerializableParameter - missing property: " + requiredParameter;
        try {
            Assert.assertNotNull((Object)new PropertyDescriptor(requiredParameter, SerializableParameter.class).getReadMethod(), (String)errorMsg);
        }
        catch (IntrospectionException e) {
            Assert.fail((String)(errorMsg + ", " + e.getMessage()), (Throwable)e);
        }
    }

    @Test(dataProvider="requiredParameterMethods")
    public void testSerializableParameterWriteMethod(String requiredParameter) {
        String errorMsg = "SerializableParameter - missing property: " + requiredParameter;
        try {
            Assert.assertNotNull((Object)new PropertyDescriptor(requiredParameter, SerializableParameter.class).getWriteMethod(), (String)errorMsg);
        }
        catch (IntrospectionException e) {
            Assert.fail((String)(errorMsg + ", " + e.getMessage()), (Throwable)e);
        }
    }
}

