/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.properties;

import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.models.properties.UntypedProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PropertyBuilderTest {
    private static final String STRING_FORMATS = "stringFormats";
    private static final String FROM_SPEC = "fromSpec";
    private static final String BY_IMPLEMENTATION = "predefined";
    private static final String CUSTOM_OR_PLAIN = "customOrPlain";
    private HashMap<PropertyBuilder.PropertyId, Object> args;
    private List<String> _enum;

    @DataProvider(name="predefined")
    public Iterator<Object[]> createPredefinedProperties() {
        Property[] properties = new Property[]{new DecimalProperty(), new FloatProperty(), new DoubleProperty(), new BaseIntegerProperty(), new IntegerProperty(), new LongProperty(), new StringProperty(), new UUIDProperty(), new BooleanProperty(), new ByteArrayProperty(), new ArrayProperty(), new ObjectProperty(), new DateTimeProperty(), new DateProperty(), new RefProperty(), new EmailProperty(), new UntypedProperty()};
        ArrayList<Object[]> resultList = new ArrayList<Object[]>(properties.length);
        for (Property property : properties) {
            resultList.add(new Object[]{property.getType(), property.getFormat(), property.getClass()});
        }
        return resultList.iterator();
    }

    @DataProvider(name="stringFormats")
    public Iterator<Object[]> createPredefinedStringFormats() {
        ArrayList<Object[]> resultList = new ArrayList<Object[]>();
        for (StringProperty.Format format : StringProperty.Format.values()) {
            resultList.add(new Object[]{"string", format.getName(), StringProperty.class});
        }
        return resultList.iterator();
    }

    @DataProvider(name="fromSpec")
    public Object[][] createDataFromSpec() {
        return new Object[][]{{"integer", "int32", IntegerProperty.class}, {"integer", "int64", LongProperty.class}, {"number", "float", FloatProperty.class}, {"number", "double", DoubleProperty.class}, {"string", null, StringProperty.class}, {"string", "byte", ByteArrayProperty.class}, {"string", "binary", BinaryProperty.class}, {"boolean", null, BooleanProperty.class}, {"string", "date", DateProperty.class}, {"string", "date-time", DateTimeProperty.class}, {"string", "password", StringProperty.class}};
    }

    @DataProvider(name="customOrPlain")
    public Object[][] createCustomAndPlainData() {
        return new Object[][]{{"integer", null, BaseIntegerProperty.class}, {"integer", "custom", BaseIntegerProperty.class}, {"number", null, DecimalProperty.class}, {"number", "custom", DecimalProperty.class}, {"string", "custom", StringProperty.class}, {"boolean", "custom", BooleanProperty.class}, {"object", null, ObjectProperty.class}, {"object", "custom", ObjectProperty.class}, {"array", null, ArrayProperty.class}, {"array", "custom", ArrayProperty.class}, {null, null, UntypedProperty.class}, {null, "custom", UntypedProperty.class}};
    }

    @Test(dataProvider="predefined")
    public void testPredefinedProperty(String type, String format, Class<? extends Property> expectedClass) {
        this.buildAndAssertProperty(type, format, expectedClass);
    }

    @Test(dataProvider="fromSpec")
    public void testSpecificationProperty(String type, String format, Class<? extends Property> expectedClass) {
        this.buildAndAssertProperty(type, format, expectedClass);
    }

    @Test(dataProvider="customOrPlain")
    public void testCustomOrPlainProperty(String type, String format, Class<? extends Property> expectedClass) {
        this.buildAndAssertProperty(type, format, expectedClass);
    }

    @Test(dataProvider="stringFormats")
    public void testStringPredefinedFormats(String type, String format, Class<? extends Property> expectedClass) {
        this.buildAndAssertProperty(type, format, expectedClass);
    }

    private void buildAndAssertProperty(String type, String format, Class<? extends Property> expectedClass) {
        Property built = PropertyBuilder.build((String)type, (String)format, null);
        Assert.assertNotNull((Object)built, (String)("Could not build for type: " + type + ", format: " + format + ", expected class: " + expectedClass));
        Assert.assertEquals(built.getClass(), expectedClass);
        Assert.assertEquals((String)built.getType(), (String)type);
        Assert.assertEquals((String)built.getFormat(), (String)format);
    }

    @Test
    public void testUnknownType() {
        Assert.assertNull((Object)PropertyBuilder.build((String)"unknownType", (String)"custom", null));
    }

    @Test(dataProvider="fromSpec")
    public void testBuildWithArgs(String type, String format, Class<? extends Property> expectedClass) {
        EnumMap<PropertyBuilder.PropertyId, Object> args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
        args.put(PropertyBuilder.PropertyId.DESCRIPTION, (Object)"Example description");
        args.put(PropertyBuilder.PropertyId.MIN_LENGTH, (Object)2);
        args.put(PropertyBuilder.PropertyId.MAX_LENGTH, (Object)11);
        args.put(PropertyBuilder.PropertyId.PATTERN, (Object)"pattern");
        Property built = PropertyBuilder.build((String)type, (String)format, args);
        Assert.assertNotNull((Object)built);
        Assert.assertEquals(built.getClass(), expectedClass);
    }

    @BeforeMethod
    public void setup() {
        this.args = new HashMap();
        this.args.put(PropertyBuilder.PropertyId.READ_ONLY, true);
        String title = "title";
        this.args.put(PropertyBuilder.PropertyId.TITLE, title);
        String description = "description";
        this.args.put(PropertyBuilder.PropertyId.DESCRIPTION, description);
        String example = "example";
        this.args.put(PropertyBuilder.PropertyId.EXAMPLE, example);
        HashMap vendorExtensions = new HashMap();
        this.args.put(PropertyBuilder.PropertyId.VENDOR_EXTENSIONS, vendorExtensions);
        this._enum = Arrays.asList("4", "hello");
        this.args.put(PropertyBuilder.PropertyId.ENUM, this._enum);
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, "4");
    }

    @Test
    public void testMergeWithIntegerProperty() {
        IntegerProperty integerProperty = new IntegerProperty();
        PropertyBuilder.merge((Property)integerProperty, this.args);
        Assert.assertTrue((boolean)integerProperty.getEnum().contains(4), (String)"Must contain the enum value passed into args");
        Assert.assertEquals((Integer)integerProperty.getDefault(), (Integer)4, (String)"Must contain the default value passed into args");
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, null);
        PropertyBuilder.merge((Property)integerProperty, this.args);
        Assert.assertNull((Object)integerProperty.getDefault(), (String)"Must contain the default value passed into args");
    }

    @Test
    public void testMergeWithBooleanProperty() {
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, "true");
        BooleanProperty booleanProperty = new BooleanProperty();
        PropertyBuilder.merge((Property)booleanProperty, this.args);
        Assert.assertEquals((Boolean)booleanProperty.getDefault(), (Boolean)Boolean.TRUE, (String)"Must contain the default value passed into args");
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, null);
        PropertyBuilder.merge((Property)booleanProperty, this.args);
        Assert.assertNull((Object)booleanProperty.getDefault(), (String)"Must contain the default value passed into args");
    }

    @Test
    public void testMergeWithLongProperty() {
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, "4");
        LongProperty longProperty = new LongProperty();
        PropertyBuilder.merge((Property)longProperty, this.args);
        Assert.assertTrue((boolean)longProperty.getEnum().contains(4L), (String)"Must contain the enum value passed into args");
        Assert.assertEquals((Object)longProperty.getDefault(), (Object)4L, (String)"Must contain the default value passed into args");
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, null);
        PropertyBuilder.merge((Property)longProperty, this.args);
        Assert.assertNull((Object)longProperty.getDefault(), (String)"Must contain the default value passed into args");
    }

    @Test
    public void testMergeWithFloatProperty() {
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, "4");
        FloatProperty floatProperty = new FloatProperty();
        PropertyBuilder.merge((Property)floatProperty, this.args);
        Assert.assertTrue((boolean)floatProperty.getEnum().contains(Float.valueOf(4.0f)), (String)"Must contain the enum value passed into args");
        Assert.assertEquals((Float)floatProperty.getDefault(), (float)new BigDecimal(4).floatValue(), (String)"Must contain the default value passed into args");
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, null);
        PropertyBuilder.merge((Property)floatProperty, this.args);
        Assert.assertNull((Object)floatProperty.getDefault(), (String)"Must contain the default value passed into args");
    }

    @Test
    public void testMergeWithUUIDProperty() {
        UUIDProperty uuidProperty = new UUIDProperty();
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, "default");
        this.args.put(PropertyBuilder.PropertyId.MIN_LENGTH, 2);
        this.args.put(PropertyBuilder.PropertyId.MAX_LENGTH, 11);
        this.args.put(PropertyBuilder.PropertyId.PATTERN, "pattern");
        PropertyBuilder.merge((Property)uuidProperty, this.args);
        Assert.assertEquals((String)uuidProperty.getDefault(), (String)"default", (String)"Must contain the default value passed into args");
        Assert.assertEquals((Object)uuidProperty.getMinLength(), (Object)2, (String)"Must contain the minLength value passed into args");
        Assert.assertEquals((Object)uuidProperty.getMaxLength(), (Object)11, (String)"Must contain the maxLength value passed into args");
        Assert.assertEquals((String)uuidProperty.getPattern(), (String)"pattern", (String)"Must contain the pattern value passed into args");
        uuidProperty = (UUIDProperty)Mockito.spy((Object)uuidProperty);
        ((UUIDProperty)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)uuidProperty))._enum(ArgumentMatchers.anyString());
        PropertyBuilder.merge((Property)uuidProperty, this.args);
        Assert.assertEquals((Collection)uuidProperty.getEnum(), this._enum, (String)"Must contain the enum value passed into args");
    }

    @Test
    public void testMergeWithArrayProperty() {
        ArrayProperty arrayProperty = new ArrayProperty();
        this.args.put(PropertyBuilder.PropertyId.MIN_ITEMS, 2);
        this.args.put(PropertyBuilder.PropertyId.MAX_ITEMS, 11);
        PropertyBuilder.merge((Property)arrayProperty, this.args);
        Assert.assertEquals((Object)arrayProperty.getMinItems(), (Object)2, (String)"Must contain the minItems value passed into args");
        Assert.assertEquals((Object)arrayProperty.getMaxItems(), (Object)11, (String)"Must contain the maxItems value passed into args");
    }

    @Test
    public void testMergeWithDateProperty() {
        DateProperty dateProperty = new DateProperty();
        PropertyBuilder.merge((Property)dateProperty, this.args);
        Assert.assertEquals((Collection)dateProperty.getEnum(), this._enum, (String)"Must contain the enum value passed into args");
        dateProperty = (DateProperty)Mockito.spy((Object)dateProperty);
        ((DateProperty)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)dateProperty))._enum(ArgumentMatchers.anyString());
        PropertyBuilder.merge((Property)dateProperty, this.args);
        Assert.assertEquals((Collection)dateProperty.getEnum(), this._enum, (String)"Must contain the enum value passed into args");
    }

    @Test
    public void testMergeWithDateTimeProperty() {
        DateTimeProperty dateTimeProperty = new DateTimeProperty();
        PropertyBuilder.merge((Property)dateTimeProperty, this.args);
        Assert.assertEquals((Collection)dateTimeProperty.getEnum(), this._enum, (String)"Must contain the enum value passed into args");
        dateTimeProperty = (DateTimeProperty)Mockito.spy((Object)dateTimeProperty);
        ((DateTimeProperty)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)dateTimeProperty))._enum(ArgumentMatchers.anyString());
        PropertyBuilder.merge((Property)dateTimeProperty, this.args);
        Assert.assertEquals((Collection)dateTimeProperty.getEnum(), this._enum, (String)"Must contain the enum value passed into args");
    }

    @Test
    public void testMergeWithStringProperty() {
        StringProperty stringProperty = new StringProperty();
        PropertyBuilder.merge((Property)stringProperty, this.args);
        Assert.assertEquals((Collection)stringProperty.getEnum(), this._enum, (String)"Must contain the enum value passed into args");
    }

    @Test
    public void testMergeWithDoubleProperty() {
        this.args.put(PropertyBuilder.PropertyId.MINIMUM, new BigDecimal(2.0));
        this.args.put(PropertyBuilder.PropertyId.MAXIMUM, new BigDecimal(112.0));
        this.args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, true);
        this.args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, true);
        this.args.put(PropertyBuilder.PropertyId.MULTIPLE_OF, new BigDecimal(2.0));
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, "4");
        DoubleProperty doubleProperty = new DoubleProperty();
        PropertyBuilder.merge((Property)doubleProperty, this.args);
        Assert.assertTrue((boolean)doubleProperty.getEnum().contains(4.0), (String)"Must contain the enum value passed into args");
        Assert.assertEquals((Double)doubleProperty.getDefault(), (Double)4.0, (String)"Must contain the default value passed into args");
        Assert.assertEquals((Object)doubleProperty.getMinimum(), (Object)new BigDecimal(2.0), (String)"Must contain the minimum value passed into args");
        Assert.assertEquals((Object)doubleProperty.getMaximum(), (Object)new BigDecimal(112.0), (String)"Must contain the maximum value passed into args");
        Assert.assertTrue((boolean)doubleProperty.exclusiveMaximum, (String)"Must contain the exclusive minimum value passed into args");
        Assert.assertTrue((boolean)doubleProperty.exclusiveMinimum, (String)"Must contain the exclusive maximum value passed into args");
        Assert.assertEquals((Object)doubleProperty.getMultipleOf(), (Object)new BigDecimal(2.0), (String)"Must contain the multiple of value passed into args");
        this.args.put(PropertyBuilder.PropertyId.DEFAULT, null);
        PropertyBuilder.merge((Property)doubleProperty, this.args);
        Assert.assertNull((Object)doubleProperty.getDefault(), (String)"Must contain the default value passed into args");
    }

    @Test
    public void testToModelWithBooleanProperty() {
        BooleanProperty booleanProperty = new BooleanProperty();
        booleanProperty.setDescription("description");
        Model model = PropertyBuilder.toModel((Property)booleanProperty);
        Assert.assertEquals((String)model.getDescription(), (String)booleanProperty.getDescription(), (String)"Must contain the description value passed into the property");
    }

    @Test
    public void testToModelWithIntegerProperty() {
        IntegerProperty integerProperty = new IntegerProperty();
        integerProperty.setDefault(Integer.valueOf(4));
        Model model = PropertyBuilder.toModel((Property)integerProperty);
        Assert.assertEquals((Object)((ModelImpl)model).getDefaultValue(), (Object)4, (String)"Must contain the default value passed into the property");
    }

    @Test
    public void testToModelWithLongProperty() {
        LongProperty longProperty = new LongProperty();
        longProperty.setDefault(Long.valueOf(4L));
        Model model = PropertyBuilder.toModel((Property)longProperty);
        Assert.assertEquals((Object)((ModelImpl)model).getDefaultValue(), (Object)4, (String)"Must contain the default value passed into the property");
    }

    @Test
    public void testToModelWithFloatProperty() {
        FloatProperty floatProperty = new FloatProperty();
        floatProperty.setDefault(Float.valueOf(4.0f));
        Model model = PropertyBuilder.toModel((Property)floatProperty);
        Assert.assertEquals((Object)((ModelImpl)model).getDefaultValue(), (Object)new BigDecimal("4.0"), (String)"Must contain the default value passed into the property");
    }

    @Test
    public void testToModelWithDoubleProperty() {
        DoubleProperty doubleProperty = new DoubleProperty();
        doubleProperty.setDefault(Double.valueOf(4.0));
        Model model = PropertyBuilder.toModel((Property)doubleProperty);
        Assert.assertEquals((Object)((ModelImpl)model).getDefaultValue(), (Object)new BigDecimal("4.0"), (String)"Must contain the default value passed into the property");
    }

    @Test
    public void testToModelWithRefProperty() {
        RefProperty refProperty = new RefProperty("ref");
        refProperty.setDescription("ref description");
        Assert.assertEquals((String)PropertyBuilder.toModel((Property)refProperty).getDescription(), (String)refProperty.getDescription(), (String)"Must contain the description value passed into the property");
    }

    @Test
    public void testToModelWithEmailProperty() {
        EmailProperty emailProperty = new EmailProperty();
        emailProperty.setDefault("default");
        Model model = PropertyBuilder.toModel((Property)emailProperty);
        Assert.assertEquals((Object)((ModelImpl)model).getDefaultValue(), (Object)"default", (String)"Must contain the default value passed into the property");
    }

    @Test
    public void testToModelWithArrayProperty() {
        EmailProperty emailProperty = new EmailProperty();
        ArrayProperty arrayProperty = new ArrayProperty();
        arrayProperty.setItems((Property)emailProperty);
        Model model = PropertyBuilder.toModel((Property)arrayProperty);
        Assert.assertEquals((Object)((ArrayModel)model).getItems(), (Object)emailProperty, (String)"Must contain the items value passed into the property");
    }

    @Test
    public void testToModelWithMapProperty() {
        EmailProperty emailProperty = new EmailProperty();
        MapProperty mapProperty = new MapProperty();
        mapProperty.setAdditionalProperties((Property)emailProperty);
        Model model = PropertyBuilder.toModel((Property)mapProperty);
        Assert.assertEquals((Object)((ModelImpl)model).getAdditionalProperties(), (Object)emailProperty, (String)"Must contain the additionalProperties value passed into the property");
    }

    @Test
    public void testToModelWithStringProperty() {
        StringProperty stingProperty = new StringProperty();
        stingProperty.setDefault("default");
        Model model = PropertyBuilder.toModel((Property)stingProperty);
        Assert.assertEquals((Object)((ModelImpl)model).getDefaultValue(), (Object)"default", (String)"Must contain the default value passed into the property");
    }

    @Test
    public void testToModelWithUUIDProperty() {
        UUIDProperty uuidProperty = new UUIDProperty();
        uuidProperty.setDefault("default");
        Model model = PropertyBuilder.toModel((Property)uuidProperty);
        Assert.assertEquals((Object)((ModelImpl)model).getDefaultValue(), (Object)"default", (String)"Must contain the default value passed into the property");
    }

    @Test
    public void testToModelWithUnknownPropertyType() {
        Assert.assertNull((Object)PropertyBuilder.toModel((Property)((Property)Mockito.mock(Property.class))));
    }

    @Test
    public void testGetPropertyName() {
        String name = PropertyBuilder.PropertyId.DEFAULT.getPropertyName();
        Assert.assertEquals((String)name, (String)"default", (String)"Property name for DEFAULT is 'default'");
    }

    @Test
    public void testValueOf() {
        PropertyBuilder.PropertyId value = PropertyBuilder.PropertyId.valueOf((String)"DEFAULT");
        Assert.assertEquals((Object)value, (Object)PropertyBuilder.PropertyId.DEFAULT, (String)"Value of 'DEFAULT' is DEFAULT");
    }
}

