/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.refs;

import io.swagger.models.refs.GenericRef;
import io.swagger.models.refs.RefFormat;
import io.swagger.models.refs.RefType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GenericRefTest {
    @Test
    public void testIdentifyingUrlRefs() throws Exception {
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "http://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "http://my.company.com/models/model.json#/thing"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "http://my.company.com/models/model.json"), RefFormat.URL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "http://my.company.com/models/model.json#/thing"), RefFormat.URL);
    }

    @Test
    public void testIdentifyInternalRefs() throws Exception {
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "#/definitions/foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "#/parameters/foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "Foo"), RefFormat.INTERNAL);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "Foo"), RefFormat.INTERNAL);
    }

    @Test
    public void testIdentifyRelativeRefs() throws Exception {
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "./path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "./path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "../path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.DEFINITION, "../path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "./path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "./path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "../path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "../path/to/model.json#/thing"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "/path/to/model.json"), RefFormat.RELATIVE);
        this.assertRefFormat(new GenericRef(RefType.PARAMETER, "/path/to/model.json#/thing"), RefFormat.RELATIVE);
    }

    @Test
    public void testGetFullRef() throws Exception {
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "./path/to/model.json");
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "./path/to/model.json#/thing");
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "/path/to/model.json");
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "/path/to/model.json#/thing");
        this.assertRefStringIsUnchanged(RefType.PARAMETER, "./path/to/parameters.json#/param");
        this.assertRefStringIsUnchanged(RefType.PARAMETER, "./path/to/parameters.json#/param");
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "#/definitions/foo");
        this.assertRefStringIsUnchanged(RefType.PARAMETER, "#/parameters/foo");
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "http://my.company.com/models/model.json");
        this.assertRefStringIsUnchanged(RefType.DEFINITION, "http://my.company.com/models/model.json#/thing");
        this.assertRefStringIsUnchanged(RefType.PARAMETER, "http://my.company.com/models/model.json");
        this.assertRefStringIsUnchanged(RefType.PARAMETER, "http://my.company.com/models/model.json#/thing");
        this.assertRefString(RefType.DEFINITION, "foo", "#/definitions/foo");
        this.assertRefString(RefType.PARAMETER, "foo", "#/parameters/foo");
    }

    @Test
    public void testGetSimpleRef() throws Exception {
        this.assertSimpleRefMatchesRef(RefType.DEFINITION, "./path/to/model.json");
        this.assertSimpleRefMatchesRef(RefType.DEFINITION, "./path/to/model.json#/thing");
        this.assertSimpleRefMatchesRef(RefType.DEFINITION, "/path/to/model.json");
        this.assertSimpleRefMatchesRef(RefType.DEFINITION, "/path/to/model.json#/thing");
        this.assertSimpleRefMatchesRef(RefType.PARAMETER, "./path/to/parameters.json#/param");
        this.assertSimpleRefMatchesRef(RefType.PARAMETER, "./path/to/parameters.json#/param");
        this.assertSimpleRefMatchesRef(RefType.DEFINITION, "http://my.company.com/models/model.json");
        this.assertSimpleRefMatchesRef(RefType.DEFINITION, "http://my.company.com/models/model.json#/thing");
        this.assertSimpleRefMatchesRef(RefType.PARAMETER, "http://my.company.com/models/model.json");
        this.assertSimpleRefMatchesRef(RefType.PARAMETER, "http://my.company.com/models/model.json#/thing");
        this.assertSimpleRef(RefType.DEFINITION, "#/definitions/foo", "foo");
        this.assertSimpleRef(RefType.PARAMETER, "#/parameters/foo", "foo");
        this.assertSimpleRef(RefType.DEFINITION, "foo", "foo");
        this.assertSimpleRef(RefType.PARAMETER, "foo", "foo");
    }

    @Test
    public void testDontAllowInternalPathRefs() throws Exception {
        this.assertExceptionThrownInConstructor(RefType.PATH);
    }

    @Test
    public void testDontAllowInternalResponseRefs() throws Exception {
        this.assertExceptionThrownInConstructor(RefType.RESPONSE);
    }

    public void assertRefStringIsUnchanged(RefType refType, String refStr) {
        this.assertRefString(refType, refStr, refStr);
    }

    public void assertRefString(RefType refType, String refStr, String expectedRefStr) {
        GenericRef refObj = new GenericRef(refType, refStr);
        Assert.assertEquals((String)refObj.getRef(), (String)expectedRefStr);
    }

    public void assertSimpleRefMatchesRef(RefType refType, String refStr) {
        this.assertSimpleRef(refType, refStr, refStr);
    }

    public void assertSimpleRef(RefType refType, String refStr, String expectedSimpleRef) {
        GenericRef refObj = new GenericRef(refType, refStr);
        Assert.assertEquals((String)refObj.getSimpleRef(), (String)expectedSimpleRef);
    }

    public void assertRefFormat(GenericRef actual, RefFormat expectedFormat) {
        Assert.assertEquals((Object)actual.getFormat(), (Object)expectedFormat);
    }

    public void assertExceptionThrownInConstructor(RefType path) {
        boolean exceptionThrown = false;
        try {
            new GenericRef(path, "#/paths/foo");
        }
        catch (Throwable t) {
            exceptionThrown = true;
        }
    }
}

