/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v2;

import io.swagger.oas.models.Components;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.PathItem;
import io.swagger.oas.models.Paths;
import io.swagger.oas.models.info.Info;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.FileSchema;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.parameters.Parameter;
import io.swagger.oas.models.parameters.RequestBody;
import io.swagger.oas.models.responses.ApiResponse;
import io.swagger.oas.models.responses.ApiResponses;
import io.swagger.parser.extensions.SwaggerParserExtension;
import io.swagger.parser.models.AuthorizationValue;
import io.swagger.parser.models.ParseOptions;
import io.swagger.parser.models.SwaggerParseResult;
import io.swagger.parser.v2.SwaggerInventory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import v2.io.swagger.models.Contact;
import v2.io.swagger.models.License;
import v2.io.swagger.models.Model;
import v2.io.swagger.models.Operation;
import v2.io.swagger.models.Path;
import v2.io.swagger.models.RefModel;
import v2.io.swagger.models.Response;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.parameters.BodyParameter;
import v2.io.swagger.models.parameters.RefParameter;
import v2.io.swagger.models.parameters.SerializableParameter;
import v2.io.swagger.models.properties.Property;
import v2.io.swagger.models.properties.RefProperty;
import v2.io.swagger.parser.SwaggerParser;
import v2.io.swagger.parser.SwaggerResolver;
import v2.io.swagger.parser.util.SwaggerDeserializationResult;
import v2.io.swagger.util.Json;

public class SwaggerConverter
implements SwaggerParserExtension {
    private List<String> globalConsumes = new ArrayList<String>();
    private List<String> globalProduces = new ArrayList<String>();

    public SwaggerParseResult readLocation(String url, List<AuthorizationValue> auths, ParseOptions options) {
        boolean resolve = false;
        if (options != null) {
            resolve = options.isResolve();
        }
        SwaggerDeserializationResult result = new SwaggerParser().readWithInfo(url, this.convert(auths), resolve);
        return this.convert(result);
    }

    public SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerDeserializationResult result = new SwaggerParser().readWithInfo(swaggerAsString);
        if (options != null && options.isResolve()) {
            Swagger resolved = new SwaggerResolver(result.getSwagger(), this.convert(auth)).resolve();
            result.setSwagger(resolved);
        }
        return this.convert(result);
    }

    public List<v2.io.swagger.models.auth.AuthorizationValue> convert(List<AuthorizationValue> auths) {
        ArrayList<v2.io.swagger.models.auth.AuthorizationValue> convertedAuth = new ArrayList<v2.io.swagger.models.auth.AuthorizationValue>();
        if (auths != null) {
            for (AuthorizationValue auth : auths) {
                v2.io.swagger.models.auth.AuthorizationValue v = new v2.io.swagger.models.auth.AuthorizationValue();
                v.setType(auth.getType());
                v.setValue(auth.getValue());
                v.setKeyName(auth.getKeyName());
            }
        }
        return convertedAuth;
    }

    public SwaggerParseResult convert(SwaggerDeserializationResult parse) {
        String updatedRef;
        RefModel ref;
        if (parse == null) {
            return null;
        }
        if (parse.getSwagger() == null) {
            return new SwaggerParseResult().messages(parse.getMessages());
        }
        OpenAPI openAPI = new OpenAPI();
        SwaggerParseResult output = new SwaggerParseResult();
        SwaggerInventory inventory = new SwaggerInventory().process(parse.getSwagger());
        Swagger swagger = parse.getSwagger();
        openAPI.setInfo(this.convert(swagger.getInfo()));
        if (swagger.getConsumes() != null) {
            this.globalConsumes.addAll(swagger.getConsumes());
        }
        if (swagger.getProduces() != null) {
            this.globalProduces.addAll(swagger.getProduces());
        }
        List<Model> models = inventory.getModels();
        for (Model model : models) {
            if (model.getExample() != null) {
                model.setExample(null);
            }
            if (!(model instanceof RefModel) || (ref = (RefModel)model).get$ref().indexOf("#/definitions") != 0) continue;
            updatedRef = "#/components/schemas" + ref.get$ref().substring("#/definitions".length());
            ref.set$ref(updatedRef);
        }
        for (Property property : inventory.getProperties()) {
            if (property.getExample() != null) {
                property.setExample(null);
            }
            if (!(property instanceof RefProperty) || (ref = (RefProperty)property).get$ref().indexOf("#/definitions") != 0) continue;
            updatedRef = "#/components/schemas" + ref.get$ref().substring("#/definitions".length());
            ref.set$ref(updatedRef);
        }
        Paths v3Paths = new Paths();
        for (String pathname : swagger.getPaths().keySet()) {
            Path v2Path = swagger.getPath(pathname);
            PathItem v3Path = this.convert(v2Path);
            v3Paths.put((Object)pathname, (Object)v3Path);
        }
        openAPI.setPaths(v3Paths);
        Components components = new Components();
        if (swagger.getParameters() != null) {
            for (String name : swagger.getParameters().keySet()) {
                v2.io.swagger.models.parameters.Parameter param = (v2.io.swagger.models.parameters.Parameter)swagger.getParameters().get(name);
                components.addParameters(name, this.convert(param));
            }
        }
        for (String key : swagger.getDefinitions().keySet()) {
            Model model = (Model)swagger.getDefinitions().get(key);
            Schema schema = (Schema)Json.mapper().convertValue((Object)model, Schema.class);
            components.addSchemas(key, schema);
        }
        openAPI.setComponents(components);
        output.setOpenAPI(openAPI);
        return output;
    }

    public Info convert(v2.io.swagger.models.Info v2Info) {
        Info info = new Info();
        info.setContact(this.convert(v2Info.getContact()));
        info.setDescription(v2Info.getDescription());
        info.setLicense(this.convert(v2Info.getLicense()));
        info.setTermsOfService(v2Info.getTermsOfService());
        info.setTitle(v2Info.getTitle());
        info.setVersion(v2Info.getVersion());
        if (v2Info.getVendorExtensions() != null && v2Info.getVendorExtensions().size() > 0) {
            info.setExtensions(v2Info.getVendorExtensions());
        }
        return info;
    }

    private io.swagger.oas.models.info.License convert(License v2License) {
        if (v2License == null) {
            return null;
        }
        io.swagger.oas.models.info.License license = new io.swagger.oas.models.info.License();
        if (v2License.getVendorExtensions() != null && v2License.getVendorExtensions().size() > 0) {
            license.setExtensions(v2License.getVendorExtensions());
        }
        license.setName(v2License.getName());
        license.setUrl(v2License.getUrl());
        return license;
    }

    public io.swagger.oas.models.info.Contact convert(Contact v2Contact) {
        if (v2Contact == null) {
            return null;
        }
        io.swagger.oas.models.info.Contact contact = new io.swagger.oas.models.info.Contact();
        contact.setUrl(v2Contact.getUrl());
        contact.setName(v2Contact.getName());
        contact.setEmail(v2Contact.getEmail());
        return contact;
    }

    public PathItem convert(Path v2Path) {
        Operation v2Operation;
        PathItem v3Path = new PathItem();
        if (v2Path.getParameters() != null) {
            for (v2.io.swagger.models.parameters.Parameter param : v2Path.getParameters()) {
                v3Path.addParametersItem(this.convert(param));
            }
        }
        if ((v2Operation = v2Path.getGet()) != null) {
            v3Path.setGet(this.convert(v2Operation));
        }
        if ((v2Operation = v2Path.getPut()) != null) {
            v3Path.setPut(this.convert(v2Operation));
        }
        if ((v2Operation = v2Path.getPost()) != null) {
            v3Path.setPost(this.convert(v2Operation));
        }
        if ((v2Operation = v2Path.getPatch()) != null) {
            v3Path.setPatch(this.convert(v2Operation));
        }
        if ((v2Operation = v2Path.getDelete()) != null) {
            v3Path.setDelete(this.convert(v2Operation));
        }
        if (v2Path.getVendorExtensions() != null && v2Path.getVendorExtensions().size() > 0) {
            v3Path.setExtensions(v2Path.getVendorExtensions());
        }
        return v3Path;
    }

    public io.swagger.oas.models.Operation convert(Operation v2Operation) {
        io.swagger.oas.models.Operation operation = new io.swagger.oas.models.Operation();
        if (StringUtils.isNotBlank((CharSequence)v2Operation.getDescription())) {
            operation.setDescription(v2Operation.getDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)v2Operation.getSummary())) {
            operation.setSummary(v2Operation.getSummary());
        }
        operation.setDeprecated(v2Operation.isDeprecated());
        operation.setOperationId(v2Operation.getOperationId());
        if (v2Operation.getParameters() != null) {
            ArrayList<v2.io.swagger.models.parameters.Parameter> formParams = new ArrayList<v2.io.swagger.models.parameters.Parameter>();
            for (v2.io.swagger.models.parameters.Parameter param : v2Operation.getParameters()) {
                if ("formData".equals(param.getIn())) {
                    formParams.add(param);
                    continue;
                }
                if ("body".equals(param.getIn())) {
                    RequestBody body = new RequestBody();
                    BodyParameter bp = (BodyParameter)param;
                    ArrayList<String> mediaTypes = new ArrayList<String>(this.globalConsumes);
                    if (v2Operation.getConsumes() != null && v2Operation.getConsumes().size() > 0) {
                        mediaTypes.clear();
                        mediaTypes.addAll(v2Operation.getConsumes());
                    }
                    if (mediaTypes.size() == 0) {
                        mediaTypes.add("*/*");
                    }
                    if (StringUtils.isNotBlank((CharSequence)param.getDescription())) {
                        body.description(param.getDescription());
                    }
                    body.required(Boolean.valueOf(param.getRequired()));
                    Content content = new Content();
                    for (String type : mediaTypes) {
                        content.addMediaType(type, new MediaType().schema(this.convert(bp.getSchema())));
                        if (StringUtils.isNotBlank((CharSequence)bp.getDescription())) {
                            body.setDescription(bp.getDescription());
                        }
                        operation.setRequestBody(body);
                    }
                    body.content(content);
                    continue;
                }
                operation.addParametersItem(this.convert(param));
            }
            if (formParams.size() > 0) {
                RequestBody body = new RequestBody();
                Schema formSchema = new Schema();
                for (v2.io.swagger.models.parameters.Parameter param : formParams) {
                    SerializableParameter sp = (SerializableParameter)param;
                    FileSchema schema = null;
                    if ("file".equals(sp.getType())) {
                        schema = new FileSchema();
                    } else if ("array".equals(sp.getType())) {
                        ArraySchema as = new ArraySchema();
                        if (sp.getItems() != null) {
                            as.setItems(this.convert(sp.getItems()));
                        }
                        schema = as;
                    } else {
                        schema = new Schema();
                        schema.setType(sp.getType());
                        schema.setFormat(sp.getFormat());
                    }
                    schema.setDescription(sp.getDescription());
                    schema.setReadOnly(sp.isReadOnly());
                    formSchema.addProperties(param.getName(), (Schema)schema);
                }
                ArrayList<String> mediaTypes = new ArrayList<String>(this.globalConsumes);
                if (v2Operation.getConsumes() != null && v2Operation.getConsumes().size() > 0) {
                    mediaTypes.clear();
                    mediaTypes.addAll(v2Operation.getConsumes());
                }
                Content content = new Content();
                for (String type : mediaTypes) {
                    content.addMediaType(type, new MediaType().schema(formSchema));
                }
                body.content(content);
                operation.requestBody(body);
            }
        }
        if (v2Operation.getResponses() != null) {
            ArrayList<String> mediaTypes = new ArrayList<String>(this.globalProduces);
            if (v2Operation.getProduces() != null) {
                mediaTypes.clear();
                mediaTypes.addAll(v2Operation.getProduces());
            }
            if (mediaTypes.size() == 0) {
                mediaTypes.add("*/*");
            }
            for (String responseCode : v2Operation.getResponses().keySet()) {
                Response v2Response = (Response)v2Operation.getResponses().get(responseCode);
                ApiResponse response = this.convert(v2Response, mediaTypes);
                ApiResponses responses = operation.getResponses();
                if (responses == null) {
                    responses = new ApiResponses();
                }
                operation.responses(responses.addApiResponse(responseCode, response));
            }
        }
        return operation;
    }

    public ApiResponse convert(Response v2Response, List<String> mediaTypes) {
        ApiResponse response = new ApiResponse();
        Content content = new Content();
        response.setDescription(v2Response.getDescription());
        if (v2Response.getSchema() != null) {
            Schema schema = this.convert(v2Response.getSchema());
            for (String type : mediaTypes) {
                content.addMediaType(type, new MediaType().schema(schema));
            }
            response.content(content);
        }
        return response;
    }

    private Schema convert(Property schema) {
        return (Schema)Json.mapper().convertValue((Object)schema, Schema.class);
    }

    public Parameter convert(v2.io.swagger.models.parameters.Parameter v2Parameter) {
        Parameter v3Parameter = new Parameter();
        if (StringUtils.isNotBlank((CharSequence)v2Parameter.getDescription())) {
            v3Parameter.setDescription(v2Parameter.getDescription());
        }
        v3Parameter.setAllowEmptyValue(v2Parameter.getAllowEmptyValue());
        v3Parameter.setIn(v2Parameter.getIn());
        v3Parameter.setName(v2Parameter.getName());
        Schema schema = null;
        if (v2Parameter instanceof RefParameter) {
            schema = new Schema().$ref(((RefParameter)v2Parameter).get$ref());
        } else if (v2Parameter instanceof SerializableParameter) {
            SerializableParameter sp = (SerializableParameter)v2Parameter;
            if (sp.getVendorExtensions() != null && sp.getVendorExtensions().size() > 0) {
                schema.setExtensions(sp.getVendorExtensions());
            }
            if (sp.getEnum() != null) {
                for (String string : sp.getEnum()) {
                }
            }
            if ("array".equals(sp.getType())) {
                ArraySchema a = new ArraySchema();
                sp.getCollectionFormat();
                Property items = sp.getItems();
                Schema itemsSchema = this.convert(items);
                a.setItems(itemsSchema);
                if (sp.getMaxItems() != null) {
                    a.setMaxItems(sp.getMaxItems());
                }
                if (sp.getMinItems() != null) {
                    a.setMinItems(sp.getMinItems());
                }
                schema = a;
            } else {
                schema = new Schema();
                schema.setType(sp.getType());
                schema.setFormat(sp.getFormat());
                if (sp.getVendorExtensions() != null && sp.getVendorExtensions().size() > 0) {
                    schema.setExtensions(sp.getVendorExtensions());
                }
                if (sp.getEnum() != null) {
                    for (String e : sp.getEnum()) {
                        schema.addEnumItemObject((Object)e);
                    }
                }
                schema.setMaximum(sp.getMaximum());
                schema.setMinimum(sp.getMinimum());
                schema.setMinLength(sp.getMinLength());
                schema.setMaxLength(sp.getMaxLength());
                if (sp.getMultipleOf() != null) {
                    schema.setMultipleOf(new BigDecimal(sp.getMultipleOf().toString()));
                }
                schema.setPattern(sp.getPattern());
            }
        }
        if (v2Parameter.getRequired()) {
            v3Parameter.setRequired(Boolean.valueOf(v2Parameter.getRequired()));
        }
        v3Parameter.setSchema(schema);
        if (v2Parameter.getVendorExtensions() != null && v2Parameter.getVendorExtensions().size() > 0) {
            v3Parameter.setExtensions(v2Parameter.getVendorExtensions());
        }
        return v3Parameter;
    }

    public Schema convert(Model v2Model) {
        return (Schema)Json.mapper().convertValue((Object)v2Model, Schema.class);
    }
}

