/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v2;

import java.util.ArrayList;
import java.util.List;
import v2.io.swagger.models.ArrayModel;
import v2.io.swagger.models.ComposedModel;
import v2.io.swagger.models.Model;
import v2.io.swagger.models.ModelImpl;
import v2.io.swagger.models.Operation;
import v2.io.swagger.models.Path;
import v2.io.swagger.models.Response;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.Tag;
import v2.io.swagger.models.parameters.BodyParameter;
import v2.io.swagger.models.parameters.Parameter;
import v2.io.swagger.models.properties.ArrayProperty;
import v2.io.swagger.models.properties.MapProperty;
import v2.io.swagger.models.properties.ObjectProperty;
import v2.io.swagger.models.properties.Property;

public class SwaggerInventory {
    private List<Path> paths = new ArrayList<Path>();
    private List<Property> properties = new ArrayList<Property>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<Operation> operations = new ArrayList<Operation>();
    private List<Response> responses = new ArrayList<Response>();
    private List<Model> models = new ArrayList<Model>();
    private List<Tag> tags = new ArrayList<Tag>();

    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }

    public List<Response> getResponses() {
        return this.responses;
    }

    public void setResponses(List<Response> responses) {
        this.responses = responses;
    }

    public List<Model> getModels() {
        return this.models;
    }

    public void setModels(List<Model> models) {
        this.models = models;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public SwaggerInventory process(Swagger swagger) {
        if (swagger.getTags() != null) {
            for (Tag key : swagger.getTags()) {
                this.process(key);
            }
        }
        if (swagger.getPaths() != null) {
            for (String key1 : swagger.getPaths().keySet()) {
                Path model = swagger.getPath(key1);
                this.process(model);
            }
        }
        if (swagger.getDefinitions() != null) {
            for (String key1 : swagger.getDefinitions().keySet()) {
                Model model1 = (Model)swagger.getDefinitions().get(key1);
                this.process(model1);
            }
        }
        return this;
    }

    public void process(Tag tag) {
        this.tags.add(tag);
    }

    public void process(Path path) {
        this.paths.add(path);
        if (path.getParameters() != null) {
            for (Parameter operation : path.getParameters()) {
                this.process(operation);
            }
        }
        if (path.getOperations() != null) {
            for (Operation operation1 : path.getOperations()) {
                this.process(operation1);
            }
        }
    }

    public void process(Operation operation) {
        this.operations.add(operation);
        if (operation.getParameters() != null) {
            for (Parameter key : operation.getParameters()) {
                this.process(key);
            }
        }
        if (operation.getResponses() != null) {
            for (String key1 : operation.getResponses().keySet()) {
                Response response = (Response)operation.getResponses().get(key1);
                this.process(response);
            }
        }
    }

    public void process(Response response) {
        this.responses.add(response);
        if (response.getSchema() != null) {
            this.process(response.getSchema());
        }
    }

    public void process(Parameter parameter) {
        Model model;
        BodyParameter p;
        this.parameters.add(parameter);
        if (parameter instanceof BodyParameter && (p = (BodyParameter)parameter).getSchema() != null && (model = p.getSchema()) != null) {
            this.process(model);
        }
    }

    public void process(Model model) {
        block5: {
            ArrayModel m2;
            block6: {
                block4: {
                    this.models.add(model);
                    if (!(model instanceof ModelImpl)) break block4;
                    ModelImpl m = (ModelImpl)model;
                    if (m.getProperties() == null) break block5;
                    for (String name : m.getProperties().keySet()) {
                        Property ip = (Property)m.getProperties().get(name);
                        this.process(ip);
                    }
                    break block5;
                }
                if (!(model instanceof ComposedModel)) break block6;
                ComposedModel m1 = (ComposedModel)model;
                if (m1.getAllOf() == null) break block5;
                for (Model name1 : m1.getAllOf()) {
                    this.process(name1);
                }
                break block5;
            }
            if (model instanceof ArrayModel && (m2 = (ArrayModel)model).getProperties() != null) {
                for (String name : m2.getProperties().keySet()) {
                    Property ip = (Property)m2.getProperties().get(name);
                    this.process(ip);
                }
            }
        }
    }

    public void process(Property property) {
        ObjectProperty p2;
        this.properties.add(property);
        if (property instanceof ArrayProperty) {
            ArrayProperty p = (ArrayProperty)property;
            Property ap = p.getItems();
            this.process(ap);
        } else if (property instanceof MapProperty) {
            MapProperty p = (MapProperty)property;
        } else if (property instanceof ObjectProperty && (p2 = (ObjectProperty)property).getProperties() != null) {
            for (String name : p2.getProperties().keySet()) {
                Property ip = (Property)p2.getProperties().get(name);
                this.process(ip);
            }
        }
    }
}

