/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.processors;

import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.headers.Header;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.Schema;
import io.swagger.parser.v3.ResolverCache;
import io.swagger.parser.v3.models.RefFormat;
import io.swagger.parser.v3.processors.ExampleProcessor;
import io.swagger.parser.v3.processors.ExternalRefProcessor;
import io.swagger.parser.v3.processors.SchemaProcessor;
import io.swagger.parser.v3.util.RefUtils;

public class HeaderProcessor {
    private final ResolverCache cache;
    private final SchemaProcessor schemaProcessor;
    private final ExampleProcessor exampleProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final OpenAPI openAPI;

    public HeaderProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.schemaProcessor = new SchemaProcessor(cache, openAPI);
        this.exampleProcessor = new ExampleProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processHeader(Header header) {
        if (header.get$ref() != null) {
            String newRef;
            RefFormat refFormat = RefUtils.computeRefFormat(header.get$ref());
            String $ref = header.get$ref();
            if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalHeader($ref, refFormat)) != null) {
                header.set$ref(newRef);
            }
        }
        if (header.getSchema() != null) {
            this.schemaProcessor.processSchema(header.getSchema());
        }
        if (header.getExamples() != null) {
            this.exampleProcessor.processExample(header.getExamples());
        }
        Schema schema = null;
        if (header.getContent() != null) {
            Content content = header.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                this.schemaProcessor.processSchema(schema);
            }
        }
    }
}

