/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.processors;

import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.media.ArraySchema;
import io.swagger.oas.models.media.ComposedSchema;
import io.swagger.oas.models.media.Schema;
import io.swagger.parser.v3.ResolverCache;
import io.swagger.parser.v3.models.RefFormat;
import io.swagger.parser.v3.processors.ExternalRefProcessor;
import io.swagger.parser.v3.util.RefUtils;
import java.util.List;
import java.util.Map;

public class SchemaProcessor {
    private final ResolverCache cache;
    private final ExternalRefProcessor externalRefProcessor;

    public SchemaProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processSchema(Schema schema) {
        if (schema != null) {
            if (schema.get$ref() != null) {
                this.processReferenceSchema(schema);
            } else {
                this.processSchemaType(schema);
            }
        }
    }

    public void processSchemaType(Schema schema) {
        if (schema instanceof ArraySchema) {
            this.processArraySchema((ArraySchema)schema);
        } else if (schema instanceof ComposedSchema) {
            this.processComposedSchema((ComposedSchema)schema);
        }
        if (schema.getProperties() != null) {
            this.processPropertySchema(schema);
        }
        if (schema.getNot() != null) {
            this.processNotSchema(schema);
        }
        if (schema.getAdditionalProperties() != null) {
            this.processAdditionalProperties(schema);
        }
    }

    private void processAdditionalProperties(Schema schema) {
        if (schema.getAdditionalProperties() != null) {
            if (schema.getAdditionalProperties().get$ref() != null) {
                this.processReferenceSchema(schema.getAdditionalProperties());
            } else {
                this.processSchemaType(schema.getAdditionalProperties());
            }
        }
    }

    private void processNotSchema(Schema schema) {
        if (schema.getNot() != null) {
            if (schema.getNot().get$ref() != null) {
                this.processReferenceSchema(schema.getNot());
            } else {
                this.processSchemaType(schema.getNot());
            }
        }
    }

    public void processPropertySchema(Schema schema) {
        Map properties;
        if (schema.get$ref() != null) {
            this.processReferenceSchema(schema);
        }
        if ((properties = schema.getProperties()) != null) {
            for (Map.Entry propertyEntry : properties.entrySet()) {
                Schema property = (Schema)propertyEntry.getValue();
                if (property instanceof ArraySchema) {
                    this.processArraySchema((ArraySchema)property);
                }
                if (property.get$ref() == null) continue;
                this.processReferenceSchema(property);
            }
        }
    }

    public void processComposedSchema(ComposedSchema composedSchema) {
        List schemas;
        if (composedSchema.getAllOf() != null && (schemas = composedSchema.getAllOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.get$ref() != null) {
                    this.processReferenceSchema(schema);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
        if (composedSchema.getOneOf() != null && (schemas = composedSchema.getOneOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.get$ref() != null) {
                    this.processReferenceSchema(schema);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
        if (composedSchema.getAnyOf() != null && (schemas = composedSchema.getAnyOf()) != null) {
            for (Schema schema : schemas) {
                if (schema.get$ref() != null) {
                    this.processReferenceSchema(schema);
                    continue;
                }
                this.processSchemaType(schema);
            }
        }
    }

    public void processArraySchema(ArraySchema arraySchema) {
        Schema items = arraySchema.getItems();
        if (items.get$ref() != null) {
            this.processReferenceSchema(items);
        } else {
            this.processSchemaType(items);
        }
    }

    private void processReferenceSchema(Schema schema) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(schema.get$ref());
        String $ref = schema.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalSchema($ref, refFormat)) != null) {
            schema.set$ref(newRef);
        }
    }
}

