/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.processors;

import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.headers.Header;
import io.swagger.oas.models.links.Link;
import io.swagger.oas.models.media.Content;
import io.swagger.oas.models.media.MediaType;
import io.swagger.oas.models.media.Schema;
import io.swagger.oas.models.responses.ApiResponse;
import io.swagger.parser.v3.ResolverCache;
import io.swagger.parser.v3.models.RefFormat;
import io.swagger.parser.v3.processors.ExternalRefProcessor;
import io.swagger.parser.v3.processors.HeaderProcessor;
import io.swagger.parser.v3.processors.LinkProcessor;
import io.swagger.parser.v3.processors.SchemaProcessor;
import io.swagger.parser.v3.util.RefUtils;
import java.util.Map;

public class ResponseProcessor {
    private final SchemaProcessor schemaProcessor;
    private final HeaderProcessor headerProcessor;
    private final LinkProcessor linkProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ResolverCache cache;
    private final OpenAPI openAPI;

    public ResponseProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.schemaProcessor = new SchemaProcessor(cache, openAPI);
        this.headerProcessor = new HeaderProcessor(cache, openAPI);
        this.linkProcessor = new LinkProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.cache = cache;
        this.openAPI = openAPI;
    }

    public void processResponse(ApiResponse response) {
        if (response.get$ref() != null) {
            this.processReferenceResponse(response);
        }
        Schema schema = null;
        if (response.getContent() != null) {
            Content content = response.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() == null || (schema = mediaType.getSchema()) == null) continue;
                this.schemaProcessor.processSchema(schema);
            }
        }
        if (response.getHeaders() != null) {
            Map headers = response.getHeaders();
            for (String headerName : headers.keySet()) {
                Header header = (Header)headers.get(headerName);
                this.headerProcessor.processHeader(header);
            }
        }
        if (response.getLinks() != null) {
            Map links = response.getLinks();
            for (String linkName : links.keySet()) {
                Link link = (Link)links.get(linkName);
                this.linkProcessor.processLink(link);
            }
        }
    }

    public void processReferenceResponse(ApiResponse response) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(response.get$ref());
        String $ref = response.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalResponse($ref, refFormat)) != null) {
            response.set$ref(newRef);
        }
    }
}

