/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.IOException;

public class DeserializationUtils {
    public static JsonNode deserializeIntoTree(String contents, String fileOrHost) {
        JsonNode result;
        try {
            result = fileOrHost.endsWith(".yaml") ? DeserializationUtils.readYamlTree(contents) : Json.mapper().readTree(contents);
        }
        catch (IOException e) {
            throw new RuntimeException("An exception was thrown while trying to deserialize the contents of " + fileOrHost + " into a JsonNode tree", e);
        }
        return result;
    }

    public static <T> T deserialize(Object contents, String fileOrHost, Class<T> expectedType) {
        Object result;
        ObjectMapper mapper;
        boolean isYaml = false;
        if (fileOrHost.endsWith(".yaml")) {
            mapper = Yaml.mapper();
            isYaml = true;
        } else {
            mapper = Json.mapper();
        }
        try {
            result = contents instanceof String ? (isYaml ? DeserializationUtils.readYamlValue((String)contents, expectedType) : mapper.readValue((String)contents, expectedType)) : mapper.convertValue(contents, expectedType);
        }
        catch (IOException e) {
            throw new RuntimeException("An exception was thrown while trying to deserialize the contents of " + fileOrHost + " into type " + expectedType, e);
        }
        return (T)result;
    }

    public static JsonNode readYamlTree(String contents) {
        org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml();
        return (JsonNode)Json.mapper().convertValue(yaml.load(contents), JsonNode.class);
    }

    public static <T> T readYamlValue(String contents, Class<T> expectedType) {
        org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml();
        return (T)Json.mapper().convertValue(yaml.load(contents), expectedType);
    }
}

