/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import com.wordnik.swagger.models.auth.AuthorizationValue;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class RemoteUrl {
    private static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public static String urlToString(String url, List<AuthorizationValue> auths) throws Exception {
        InputStream is = null;
        URLConnection conn = null;
        BufferedReader br = null;
        try {
            String line;
            if (auths != null) {
                StringBuilder queryString = new StringBuilder();
                for (AuthorizationValue auth : auths) {
                    if (!"query".equals(auth.getType())) continue;
                    if (queryString.toString().length() == 0) {
                        queryString.append("?");
                    } else {
                        queryString.append("&");
                    }
                    queryString.append(URLEncoder.encode(auth.getKeyName(), "UTF-8")).append("=").append(URLEncoder.encode(auth.getValue(), "UTF-8"));
                }
                if (queryString.toString().length() != 0) {
                    url = url + queryString.toString();
                }
                conn = new URL(url).openConnection();
                for (AuthorizationValue auth : auths) {
                    if (!"header".equals(auth.getType())) continue;
                    conn.setRequestProperty(auth.getKeyName(), auth.getValue());
                }
            } else {
                URL urltouse = new URL(url);
                URI uri = new URI(urltouse.getProtocol(), urltouse.getAuthority(), urltouse.getHost(), urltouse.getPort(), urltouse.getPath(), urltouse.getQuery(), null);
                conn = uri.toURL().openConnection();
            }
            StringBuilder sb = new StringBuilder();
            is = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (SSLProtocolException e) {
            System.out.println("there is a problem with the target SSL certificate");
            System.out.println("**** you may want to run with -Djsse.enableSNIExtension=false\n\n");
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    static {
        RemoteUrl.disableSslVerification();
    }
}

