/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.parser.ResolverOptions;
import io.swagger.parser.util.RemoteUrl;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerResolver {
    protected Swagger swagger;
    protected Map<String, List<ResolutionContext>> resolutionMap = new HashMap<String, List<ResolutionContext>>();
    protected ResolverOptions opts;
    Logger LOGGER = LoggerFactory.getLogger(SwaggerResolver.class);

    public SwaggerResolver() {
    }

    public SwaggerResolver(ResolverOptions opts) {
        this.opts = opts;
    }

    public Swagger resolve(Swagger swagger, List<AuthorizationValue> auths) {
        if (swagger == null) {
            return null;
        }
        this.swagger = swagger;
        this.detectModelRefs();
        this.detectOperationRefs();
        this.applyResolutions(auths);
        return this.swagger;
    }

    public void applyResolutions(List<AuthorizationValue> auths) {
        HashMap hostToObjectMap = new HashMap();
        for (String path : this.resolutionMap.keySet()) {
            String[] parts = path.split("#");
            if (parts.length != 2) continue;
            String host = parts[0];
            String definitionPath = parts[1];
            ArrayList objectList = (ArrayList)hostToObjectMap.get(host);
            if (objectList == null) {
                objectList = new ArrayList();
                hostToObjectMap.put(host, objectList);
            }
            List<ResolutionContext> contexts = this.resolutionMap.get(path);
            for (ResolutionContext ctx : contexts) {
                Object mapping = ctx.object;
                Object target = ctx.parent;
                try {
                    RefProperty ref;
                    Model model;
                    String contents = null;
                    if (host.startsWith("http")) {
                        new RemoteUrl();
                        contents = RemoteUrl.urlToString(host, auths);
                    } else {
                        contents = Json.mapper().writeValueAsString((Object)this.swagger);
                    }
                    JsonNode location = null;
                    String locationName = null;
                    if (contents != null) {
                        String[] objectPath;
                        ObjectMapper mapper = contents.trim().startsWith("{") ? Json.mapper() : Yaml.mapper();
                        location = mapper.readTree(contents);
                        for (String objectPathPart : objectPath = definitionPath.split("/")) {
                            this.LOGGER.debug("getting part " + objectPathPart);
                            if (objectPathPart.length() <= 0 || location == null) continue;
                            location = location.get(objectPathPart);
                            locationName = objectPathPart;
                        }
                    }
                    if (location == null) continue;
                    if (mapping instanceof Property) {
                        model = (Model)Json.mapper().convertValue(location, Model.class);
                        if (!(mapping instanceof RefProperty)) continue;
                        ref = (RefProperty)mapping;
                        ref.set$ref(locationName);
                        this.swagger.addDefinition(locationName, model);
                        continue;
                    }
                    if (target instanceof Parameter) {
                        if (!(mapping instanceof RefModel)) continue;
                        model = (Model)Json.mapper().convertValue((Object)location, Model.class);
                        ref = (RefModel)mapping;
                        ref.set$ref(locationName);
                        this.swagger.addDefinition(locationName, model);
                        continue;
                    }
                    if (!(target instanceof Operation)) continue;
                    Operation operation = (Operation)target;
                    int position = 0;
                    for (Parameter param : operation.getParameters()) {
                        RefParameter ref2;
                        if (param instanceof RefParameter && (ref2 = (RefParameter)param).getSimpleRef().equals(locationName)) {
                            Parameter remoteParam = (Parameter)Json.mapper().convertValue((Object)location, Parameter.class);
                            operation.getParameters().set(position, remoteParam);
                        }
                        ++position;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void detectOperationRefs() {
        Map paths = this.swagger.getPaths();
        if (paths == null) {
            return;
        }
        for (String pathName : paths.keySet()) {
            Path path = (Path)paths.get(pathName);
            List operations = path.getOperations();
            for (Operation operation : operations) {
                if (operation.getParameters() != null) {
                    for (Parameter parameter : operation.getParameters()) {
                        if (parameter instanceof BodyParameter) {
                            RefModel ref;
                            String key;
                            BodyParameter bp = (BodyParameter)parameter;
                            if (bp.getSchema() == null || !(bp.getSchema() instanceof RefModel) || !(key = (ref = (RefModel)bp.getSchema()).get$ref()).startsWith("http")) continue;
                            this.LOGGER.debug("added reference to " + key);
                            List<ResolutionContext> m = this.resolutionMap.get(key);
                            if (m == null) {
                                m = new ArrayList<ResolutionContext>();
                            }
                            m.add(new ResolutionContext(ref, bp, "ref"));
                            this.resolutionMap.put(key, m);
                            continue;
                        }
                        if (!(parameter instanceof RefParameter)) continue;
                        RefParameter ref = (RefParameter)parameter;
                        String key = ref.get$ref();
                        this.LOGGER.debug("added reference to " + ref);
                        List<ResolutionContext> m = this.resolutionMap.get(key);
                        if (m == null) {
                            m = new ArrayList<ResolutionContext>();
                        }
                        m.add(new ResolutionContext(ref, operation, "inline"));
                        this.resolutionMap.put(key, m);
                    }
                }
                if (operation.getResponses() == null) continue;
                for (String responseCode : operation.getResponses().keySet()) {
                    RefProperty ref;
                    String key;
                    Property item;
                    Response response = (Response)operation.getResponses().get(responseCode);
                    if (response.getSchema() == null) continue;
                    Property schema = response.getSchema();
                    if (schema instanceof RefProperty) {
                        RefProperty ref2 = (RefProperty)schema;
                        String key2 = ref2.get$ref();
                        if (key2 == null || !key2.startsWith("http")) continue;
                        List<ResolutionContext> m = this.resolutionMap.get(key2);
                        if (m == null) {
                            m = new ArrayList<ResolutionContext>();
                        }
                        m.add(new ResolutionContext(ref2, response, "ref"));
                        this.resolutionMap.put(key2, m);
                        continue;
                    }
                    if (!(schema instanceof ArrayProperty) || !((item = ((ArrayProperty)schema).getItems()) instanceof RefProperty) || (key = (ref = (RefProperty)item).get$ref()) == null || !key.startsWith("http")) continue;
                    List<ResolutionContext> m = this.resolutionMap.get(key);
                    if (m == null) {
                        m = new ArrayList<ResolutionContext>();
                    }
                    m.add(new ResolutionContext(ref, schema, "ref"));
                    this.resolutionMap.put(key, m);
                }
            }
        }
    }

    public void detectModelRefs() {
        Map models = this.swagger.getDefinitions();
        if (models != null) {
            for (String modelName : models.keySet()) {
                ModelImpl impl;
                Map properties;
                this.LOGGER.debug("looking at " + modelName);
                Model model = (Model)models.get(modelName);
                if (model instanceof RefModel) {
                    RefModel ref = (RefModel)model;
                    String key = ref.get$ref();
                    if (key == null || !key.startsWith("http")) continue;
                    this.LOGGER.debug("added reference to " + key);
                    List<ResolutionContext> m = this.resolutionMap.get(key);
                    if (m == null) {
                        m = new ArrayList<ResolutionContext>();
                    }
                    m.add(new ResolutionContext(ref, this.swagger.getDefinitions(), "ref"));
                    this.resolutionMap.put(key, m);
                    continue;
                }
                if (model instanceof ArrayModel) {
                    RefProperty ref;
                    String key;
                    ArrayModel arrayModel = (ArrayModel)model;
                    if (arrayModel.getItems() == null || !(arrayModel.getItems() instanceof RefProperty) || (key = (ref = (RefProperty)arrayModel.getItems()).get$ref()) == null || !key.startsWith("http")) continue;
                    this.LOGGER.debug("added reference to " + key);
                    List<ResolutionContext> m = this.resolutionMap.get(key);
                    if (m == null) {
                        m = new ArrayList<ResolutionContext>();
                    }
                    m.add(new ResolutionContext(ref, this.swagger.getDefinitions(), "ref"));
                    this.resolutionMap.put(key, m);
                    continue;
                }
                if (!(model instanceof ModelImpl) || (properties = (impl = (ModelImpl)model).getProperties()) == null) continue;
                for (String propertyName : properties.keySet()) {
                    MapProperty mp;
                    List<ResolutionContext> m;
                    RefProperty ref;
                    String key;
                    Property property = (Property)properties.get(propertyName);
                    if (property instanceof RefProperty) {
                        RefProperty ref2 = (RefProperty)property;
                        String key2 = ref2.get$ref();
                        if (key2 == null || !key2.startsWith("http")) continue;
                        this.LOGGER.debug("added reference to " + key2);
                        List<ResolutionContext> m2 = this.resolutionMap.get(key2);
                        if (m2 == null) {
                            m2 = new ArrayList<ResolutionContext>();
                        }
                        m2.add(new ResolutionContext(ref2, impl, "ref"));
                        this.resolutionMap.put(key2, m2);
                        continue;
                    }
                    if (property instanceof ArrayProperty) {
                        ArrayProperty arrayProperty = (ArrayProperty)property;
                        if (arrayProperty.getItems() == null || !(arrayProperty.getItems() instanceof RefProperty) || (key = (ref = (RefProperty)arrayProperty.getItems()).get$ref()) == null || !key.startsWith("http")) continue;
                        this.LOGGER.debug("added reference to " + key);
                        m = this.resolutionMap.get(key);
                        if (m == null) {
                            m = new ArrayList<ResolutionContext>();
                        }
                        m.add(new ResolutionContext(ref, arrayProperty, "ref"));
                        this.resolutionMap.put(key, m);
                        continue;
                    }
                    if (!(property instanceof MapProperty) || (mp = (MapProperty)property).getAdditionalProperties() == null || !(mp.getAdditionalProperties() instanceof RefProperty) || (key = (ref = (RefProperty)mp.getAdditionalProperties()).get$ref()) == null || !key.startsWith("http")) continue;
                    this.LOGGER.debug("added reference to " + key);
                    m = this.resolutionMap.get(key);
                    if (m == null) {
                        m = new ArrayList<ResolutionContext>();
                    }
                    m.add(new ResolutionContext(ref, mp, "ref"));
                    this.resolutionMap.put(key, m);
                }
            }
        }
    }

    static class ResolutionContext {
        private Object object;
        private Object parent;
        private String scope;

        public ResolutionContext(Object object, Object parent, String scope) {
            this.object = object;
            this.parent = parent;
            this.scope = scope;
        }
    }
}

