/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.validator.resources;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponses;
import io.swagger.validator.models.SchemaValidationError;
import io.swagger.validator.services.ValidatorService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/")
@Api(value="/validator", description="Validator for Swagger Specs")
public class ValidatorResource {
    ValidatorService service = new ValidatorService();

    @GET
    @ApiOperation(value="Validates a spec based on a URL")
    @ApiResponses(value={})
    @Produces(value={"image/png"})
    public Response validateByUrl(@Context HttpServletRequest request, @Context HttpServletResponse response, @ApiParam(value="url of spec to validate") @QueryParam(value="url") String url) throws WebApplicationException {
        try {
            this.service.validateByUrl(request, response, url);
            response.addHeader("Cache-Control", "no-cache");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/debug")
    @Produces(value={"application/json"})
    @ApiOperation(value="Validates a spec based on a URL", response=SchemaValidationError.class, responseContainer="List")
    @ApiResponses(value={})
    public Response debugByUrl(@Context HttpServletRequest request, @Context HttpServletResponse response, @ApiParam(value="url of spec to validate") @QueryParam(value="url") String url) throws WebApplicationException {
        try {
            return Response.ok().entity((Object)this.service.debugByUrl(request, response, url)).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="/debug")
    @Produces(value={"application/json"})
    @ApiOperation(value="Validates a spec based on a URL", response=SchemaValidationError.class, responseContainer="List")
    @ApiResponses(value={})
    public Response debugByContent(@Context HttpServletRequest request, @Context HttpServletResponse response, @ApiParam(value="spec contents") String spec) throws WebApplicationException {
        try {
            return Response.ok().entity((Object)this.service.debugByContent(request, response, spec)).build();
        }
        catch (Exception e) {
            return Response.status((int)500).build();
        }
    }
}

