/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.validator.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import io.swagger.validator.models.SchemaValidationError;
import io.swagger.validator.services.ValidatorService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ValidatorService {
    static long LAST_FETCH = 0L;
    static String CACHED_SCHEMA = null;
    static String SCHEMA_FILE = "schema.json";
    static String SCHEMA_URL = "http://swagger.io/v2/schema.json";
    static ObjectMapper JsonMapper = Json.mapper();
    static ObjectMapper YamlMapper = Yaml.mapper();
    Logger LOGGER = LoggerFactory.getLogger(ValidatorService.class);
    private JsonSchema schema;

    private static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            2 allHostsValid = new /* Unavailable Anonymous Inner Class!! */;
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public void validateByUrl(HttpServletRequest request, HttpServletResponse response, String url) {
        if (url == null) {
            this.fail(response);
        } else {
            try {
                JsonNode spec;
                String version;
                String inputDoc = this.getUrlContents(url);
                if (this.schema == null) {
                    JsonNode schemaObject = JsonMapper.readTree(this.getSchema());
                    JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
                    this.schema = factory.getJsonSchema(schemaObject);
                }
                if ((version = this.getVersion(spec = this.readNode(inputDoc))) != null && version.startsWith("\"1.")) {
                    this.upgrade(response);
                    return;
                }
                ProcessingReport report = this.schema.validate(spec);
                if (report.isSuccess()) {
                    Swagger swagger = this.readSwagger(inputDoc);
                    if (swagger != null) {
                        this.success(response);
                    } else {
                        this.fail(response);
                    }
                } else {
                    this.fail(response);
                }
            }
            catch (Exception e) {
                this.error(response);
            }
        }
    }

    private String getVersion(JsonNode node) {
        if (node == null) {
            return null;
        }
        JsonNode version = node.get("swagger");
        if (version != null) {
            return version.toString();
        }
        version = node.get("swaggerVersion");
        if (version != null) {
            return version.toString();
        }
        return null;
    }

    public List<SchemaValidationError> debugByUrl(HttpServletRequest request, HttpServletResponse response, String url) throws Exception {
        String content;
        ArrayList<SchemaValidationError> output = new ArrayList<SchemaValidationError>();
        try {
            content = this.getUrlContents(url);
        }
        catch (IOException e) {
            ProcessingMessage pm = new ProcessingMessage();
            pm.setLogLevel(LogLevel.ERROR);
            pm.setMessage("Can't read from file " + url);
            output.add(new SchemaValidationError(pm.asJson()));
            return output;
        }
        JsonNode schemaObject = JsonMapper.readTree(this.getSchema());
        JsonNode spec = this.readNode(content);
        if (spec == null) {
            ProcessingMessage pm = new ProcessingMessage();
            pm.setLogLevel(LogLevel.ERROR);
            pm.setMessage("Unable to read content.  It may be invalid JSON or YAML");
            output.add(new SchemaValidationError(pm.asJson()));
            return output;
        }
        String version = this.getVersion(spec);
        if (version != null && version.startsWith("\"1.")) {
            ProcessingMessage pm = new ProcessingMessage();
            pm.setLogLevel(LogLevel.ERROR);
            pm.setMessage("Deprecated Swagger version.  Please visit http://swagger.io for information on upgrading to Swagger 2.0");
            output.add(new SchemaValidationError(pm.asJson()));
            return output;
        }
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        JsonSchema schema = factory.getJsonSchema(schemaObject);
        ProcessingReport report = schema.validate(spec);
        ListProcessingReport lp = new ListProcessingReport();
        lp.mergeWith(report);
        if (report.isSuccess()) {
            try {
                this.readSwagger(content);
            }
            catch (IllegalArgumentException e) {
                ProcessingMessage pm = new ProcessingMessage();
                pm.setLogLevel(LogLevel.ERROR);
                pm.setMessage("unable to parse swagger from " + url);
                output.add(new SchemaValidationError(pm.asJson()));
                return output;
            }
        }
        for (ProcessingMessage pm : lp) {
            output.add(new SchemaValidationError(pm.asJson()));
        }
        return output;
    }

    public List<SchemaValidationError> debugByContent(HttpServletRequest request, HttpServletResponse response, String content) throws Exception {
        Swagger swagger;
        JsonNode schemaObject = JsonMapper.readTree(this.getSchema());
        JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
        JsonSchema schema = factory.getJsonSchema(schemaObject);
        ArrayList<SchemaValidationError> output = new ArrayList<SchemaValidationError>();
        JsonNode spec = this.readNode(content);
        if (spec == null) {
            ProcessingMessage pm = new ProcessingMessage();
            pm.setLogLevel(LogLevel.ERROR);
            pm.setMessage("Unable to read content.  It may be invalid JSON or YAML");
            output.add(new SchemaValidationError(pm.asJson()));
            return output;
        }
        ProcessingReport report = schema.validate(spec);
        ListProcessingReport lp = new ListProcessingReport();
        lp.mergeWith(report);
        if (!report.isSuccess() || (swagger = this.readSwagger(content)) != null) {
            // empty if block
        }
        for (ProcessingMessage pm : lp) {
            output.add(new SchemaValidationError(pm.asJson()));
        }
        return output;
    }

    private void success(HttpServletResponse response) {
        try {
            String name = "valid.png";
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
            if (is != null) {
                IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void error(HttpServletResponse response) {
        try {
            String name = "error.png";
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
            if (is != null) {
                IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fail(HttpServletResponse response) {
        try {
            String name = "invalid.png";
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
            if (is != null) {
                IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void upgrade(HttpServletResponse response) {
        try {
            String name = "upgrade.png";
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
            if (is != null) {
                IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getSchema() throws Exception {
        if (CACHED_SCHEMA != null && System.currentTimeMillis() - LAST_FETCH < 600000L) {
            return CACHED_SCHEMA;
        }
        try {
            LAST_FETCH = System.currentTimeMillis();
            CACHED_SCHEMA = this.getUrlContents(SCHEMA_URL);
            return CACHED_SCHEMA;
        }
        catch (Exception e) {
            String inputLine;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(SCHEMA_FILE);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            StringBuilder contents = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                contents.append(inputLine);
            }
            in.close();
            LAST_FETCH = System.currentTimeMillis();
            CACHED_SCHEMA = contents.toString();
            return CACHED_SCHEMA;
        }
    }

    private String getUrlContents(String urlString) throws IOException {
        System.setProperty("jsse.enableSNIExtension", "false");
        URL url = new URL(urlString);
        URLConnection urlc = url.openConnection();
        urlc.setRequestProperty("Accept", "application/json, */*");
        urlc.connect();
        StringBuilder contents = new StringBuilder();
        InputStream in = urlc.getInputStream();
        int i = 0;
        while (i != -1) {
            char c = (char)i;
            if (!Character.isISOControl(c)) {
                contents.append((char)i);
            }
            if (c == '\n') {
                contents.append('\n');
            }
            i = in.read();
        }
        in.close();
        return contents.toString();
    }

    protected String getRemoteAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-FORWARDED-FOR");
        if (ipAddress == null) {
            ipAddress = request.getRemoteAddr();
        }
        return ipAddress;
    }

    private Swagger readSwagger(String text) throws IllegalArgumentException {
        if (text.trim().startsWith("{")) {
            return (Swagger)JsonMapper.convertValue((Object)this.readNode(text), Swagger.class);
        }
        return (Swagger)YamlMapper.convertValue((Object)this.readNode(text), Swagger.class);
    }

    private JsonNode readNode(String text) {
        try {
            if (text.trim().startsWith("{")) {
                return JsonMapper.readTree(text);
            }
            return YamlMapper.readTree(text);
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        ValidatorService.disableSslVerification();
    }
}

