/*
 * Decompiled with CFR 0.152.
 */
package swaydb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ForkJoinPool;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Deadline;
import scala.runtime.BoxedUnit;
import swaydb.Apply;
import swaydb.Apply$Nothing$;
import swaydb.Apply$Remove$;
import swaydb.Error;
import swaydb.IO;
import swaydb.Map;
import swaydb.Map$;
import swaydb.Set;
import swaydb.Set$;
import swaydb.Tag$;
import swaydb.core.Core;
import swaydb.core.Core$;
import swaydb.core.actor.FileSweeper;
import swaydb.core.data.SwayFunction;
import swaydb.core.data.SwayFunctionOutput;
import swaydb.core.function.FunctionStore;
import swaydb.core.function.FunctionStore$;
import swaydb.core.level.tool.AppendixRepairer$;
import swaydb.data.MaxKey;
import swaydb.data.config.FileCache;
import swaydb.data.config.LevelZeroMemoryConfig;
import swaydb.data.config.LevelZeroPersistentConfig;
import swaydb.data.config.MemoryCache;
import swaydb.data.config.SwayDBMemoryConfig;
import swaydb.data.config.SwayDBPersistentConfig;
import swaydb.data.order.KeyOrder;
import swaydb.data.order.KeyOrder$;
import swaydb.data.order.TimeOrder;
import swaydb.data.order.TimeOrder$;
import swaydb.data.repairAppendix.AppendixRepairStrategy;
import swaydb.data.repairAppendix.OverlappingSegmentsException;
import swaydb.data.repairAppendix.RepairResult;
import swaydb.data.repairAppendix.SegmentInfo;
import swaydb.data.repairAppendix.SegmentInfoUnTyped;
import swaydb.data.slice.Slice;
import swaydb.serializers.Serializer;
import swaydb.serializers.package$;

public final class SwayDB$
implements LazyLogging {
    public static SwayDB$ MODULE$;
    private ExecutionContext defaultExecutionContext;
    private final FunctionStore memoryFunctionStore;
    private final TimeOrder<Slice<Object>> timeOrder;
    private Logger logger;
    private volatile byte bitmap$0;

    static {
        new SwayDB$();
    }

    private Logger logger$lzycompute() {
        SwayDB$ swayDB$ = this;
        synchronized (swayDB$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    private FunctionStore memoryFunctionStore() {
        return this.memoryFunctionStore;
    }

    private TimeOrder<Slice<Object>> timeOrder() {
        return this.timeOrder;
    }

    private ExecutionContext defaultExecutionContext$lzycompute() {
        SwayDB$ swayDB$ = this;
        synchronized (swayDB$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.defaultExecutionContext = new ExecutionContext(){
                    private final ForkJoinPool threadPool;

                    public ExecutionContext prepare() {
                        return ExecutionContext.prepare$((ExecutionContext)this);
                    }

                    public ForkJoinPool threadPool() {
                        return this.threadPool;
                    }

                    public void execute(Runnable runnable) {
                        this.threadPool().execute(runnable);
                    }

                    public void reportFailure(Throwable exception) {
                        BoxedUnit boxedUnit;
                        if (SwayDB$.MODULE$.logger().underlying().isErrorEnabled()) {
                            SwayDB$.MODULE$.logger().underlying().error("Execution context failure", exception);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    {
                        ExecutionContext.$init$((ExecutionContext)this);
                        this.threadPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
                    }
                };
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.defaultExecutionContext;
    }

    public ExecutionContext defaultExecutionContext() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.defaultExecutionContext$lzycompute() : this.defaultExecutionContext;
    }

    public <K, V> IO<Error.Boot, Map<K, V, IO>> apply(SwayDBPersistentConfig config, FileCache.Enable fileCache, MemoryCache memoryCache, Serializer<K> keySerializer, Serializer<V> valueSerializer, KeyOrder<Slice<Object>> keyOrder) {
        return Core$.MODULE$.apply(config, fileCache, memoryCache, keyOrder, this.timeOrder(), this.memoryFunctionStore()).map((Function1 & Serializable & scala.Serializable)db -> new Map(db, Map$.MODULE$.apply$default$2(), Map$.MODULE$.apply$default$3(), keySerializer, valueSerializer, Tag$.MODULE$.apiIO()));
    }

    public <T> IO<Error.Boot, Set<T, IO>> apply(SwayDBPersistentConfig config, FileCache.Enable fileCache, MemoryCache memoryCache, Serializer<T> serializer, KeyOrder<Slice<Object>> keyOrder) {
        return Core$.MODULE$.apply(config, fileCache, memoryCache, keyOrder, this.timeOrder(), this.memoryFunctionStore()).map((Function1 & Serializable & scala.Serializable)db -> Set$.MODULE$.apply((Core<IO>)db, serializer));
    }

    public <K, V> IO<Error.Boot, Map<K, V, IO>> apply(SwayDBMemoryConfig config, FileCache.Enable fileCache, MemoryCache memoryCache, Serializer<K> keySerializer, Serializer<V> valueSerializer, KeyOrder<Slice<Object>> keyOrder, ExecutionContext fileSweeperEC, ExecutionContext memorySweeperEC) {
        return Core$.MODULE$.apply(config, fileCache, memoryCache, keyOrder, this.timeOrder(), this.memoryFunctionStore()).map((Function1 & Serializable & scala.Serializable)db -> new Map(db, Map$.MODULE$.apply$default$2(), Map$.MODULE$.apply$default$3(), keySerializer, valueSerializer, Tag$.MODULE$.apiIO()));
    }

    public <T> IO<Error.Boot, Set<T, IO>> apply(SwayDBMemoryConfig config, FileCache.Enable fileCache, MemoryCache memoryCache, Serializer<T> serializer, KeyOrder<Slice<Object>> keyOrder, ExecutionContext fileSweeperEC, ExecutionContext memorySweeperEC) {
        return Core$.MODULE$.apply(config, fileCache, memoryCache, keyOrder, this.timeOrder(), this.memoryFunctionStore()).map((Function1 & Serializable & scala.Serializable)db -> Set$.MODULE$.apply((Core<IO>)db, serializer));
    }

    public <T> IO<Error.Boot, Set<T, IO>> apply(LevelZeroPersistentConfig config, Serializer<T> serializer, KeyOrder<Slice<Object>> keyOrder, Option<ExecutionContext> mmapCleanerEC) {
        return Core$.MODULE$.apply(config, mmapCleanerEC, keyOrder, this.timeOrder(), this.memoryFunctionStore()).map((Function1 & Serializable & scala.Serializable)db -> Set$.MODULE$.apply((Core<IO>)db, serializer));
    }

    public <T> IO<Error.Boot, Set<T, IO>> apply(LevelZeroMemoryConfig config, Serializer<T> serializer, KeyOrder<Slice<Object>> keyOrder) {
        return Core$.MODULE$.apply(config, keyOrder, this.timeOrder(), this.memoryFunctionStore()).map((Function1 & Serializable & scala.Serializable)db -> Set$.MODULE$.apply((Core<IO>)db, serializer));
    }

    private <V> SwayFunctionOutput toCoreFunctionOutput(Apply<V> output, Serializer<V> valueSerializer) {
        SwayFunctionOutput.Nothing$ nothing$;
        Apply<V> apply = output;
        if (Apply$Nothing$.MODULE$.equals(apply)) {
            nothing$ = SwayFunctionOutput.Nothing$.MODULE$;
        } else if (Apply$Remove$.MODULE$.equals(apply)) {
            nothing$ = SwayFunctionOutput.Remove$.MODULE$;
        } else if (apply instanceof Apply.Expire) {
            Apply.Expire expire = (Apply.Expire)apply;
            Deadline deadline = expire.deadline();
            nothing$ = new SwayFunctionOutput.Expire(deadline);
        } else if (apply instanceof Apply.Update) {
            Apply.Update update = (Apply.Update)apply;
            Slice untypedValue = valueSerializer.write(update.value());
            nothing$ = new SwayFunctionOutput.Update((Option)new Some((Object)untypedValue), update.deadline());
        } else {
            throw new MatchError(apply);
        }
        return nothing$;
    }

    public <K, V> SwayFunction toCoreFunction(Function2<K, Option<Deadline>, Apply<V>> f, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new SwayFunction.KeyDeadline((Function2 & Serializable & scala.Serializable)(key, deadline) -> this.function$1((Slice)key, (Option)deadline, f, keySerializer, valueSerializer));
    }

    public <K, V> SwayFunction toCoreFunction(Function3<K, V, Option<Deadline>, Apply<V>> f, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        return new SwayFunction.KeyValueDeadline((Function3 & Serializable & scala.Serializable)(key, value, deadline) -> this.function$2((Slice)key, (Option)value, (Option)deadline, f, keySerializer, valueSerializer));
    }

    public <K, V> SwayFunction toCoreFunction(Function1<V, Apply<V>> f, Serializer<V> valueSerializer) {
        return new SwayFunction.Value((Function1 & Serializable & scala.Serializable)value -> this.function$3((Option)value, f, valueSerializer));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K> IO<Error.Level, RepairResult<K>> repairAppendix(Path levelPath, AppendixRepairStrategy repairStrategy, Serializer<K> serializer, FileSweeper.Enabled fileSweeper, KeyOrder<Slice<Object>> keyOrder, ExecutionContext ec) {
        boolean bl = false;
        IO.Left left = null;
        IO iO = AppendixRepairer$.MODULE$.apply(levelPath, repairStrategy, keyOrder, fileSweeper, this.timeOrder(), this.memoryFunctionStore());
        if (iO instanceof IO.Left) {
            Error.Fatal fatal;
            Throwable throwable;
            bl = true;
            left = (IO.Left)iO;
            Error.Level level = (Error.Level)left.value();
            if (level instanceof Error.Fatal && (throwable = (fatal = (Error.Fatal)level).exception()) instanceof OverlappingSegmentsException) {
                MaxKey.Fixed fixed;
                MaxKey.Fixed fixed2;
                OverlappingSegmentsException overlappingSegmentsException = (OverlappingSegmentsException)throwable;
                SegmentInfoUnTyped segmentInfo = overlappingSegmentsException.segmentInfo();
                SegmentInfoUnTyped overlappingSegmentInfo = overlappingSegmentsException.overlappingSegmentInfo();
                Path path = segmentInfo.path();
                Object object = serializer.read(segmentInfo.minKey());
                MaxKey maxKey = segmentInfo.maxKey();
                if (maxKey instanceof MaxKey.Fixed) {
                    MaxKey.Fixed fixed3 = (MaxKey.Fixed)maxKey;
                    Slice maxKey2 = (Slice)fixed3.maxKey();
                    fixed2 = new MaxKey.Fixed(serializer.read(maxKey2));
                } else {
                    if (!(maxKey instanceof MaxKey.Range)) throw new MatchError((Object)maxKey);
                    MaxKey.Range range = (MaxKey.Range)maxKey;
                    Slice fromKey = (Slice)range.fromKey();
                    Slice maxKey3 = (Slice)range.maxKey();
                    fixed2 = new MaxKey.Range(serializer.read(fromKey), serializer.read(maxKey3));
                }
                SegmentInfo segmentInfo2 = new SegmentInfo(path, object, (MaxKey)fixed2, segmentInfo.segmentSize(), segmentInfo.keyValueCount());
                Path path2 = overlappingSegmentInfo.path();
                Object object2 = serializer.read(overlappingSegmentInfo.minKey());
                MaxKey maxKey4 = overlappingSegmentInfo.maxKey();
                if (maxKey4 instanceof MaxKey.Fixed) {
                    MaxKey.Fixed fixed4 = (MaxKey.Fixed)maxKey4;
                    Slice maxKey5 = (Slice)fixed4.maxKey();
                    fixed = new MaxKey.Fixed(serializer.read(maxKey5));
                    return new IO.Right((Object)new RepairResult.OverlappingSegments(segmentInfo2, new SegmentInfo(path2, object2, (MaxKey)fixed, overlappingSegmentInfo.segmentSize(), overlappingSegmentInfo.keyValueCount())), (IO.ExceptionHandler)Error.Segment$.ExceptionHandler$.MODULE$);
                } else {
                    if (!(maxKey4 instanceof MaxKey.Range)) throw new MatchError((Object)maxKey4);
                    MaxKey.Range range = (MaxKey.Range)maxKey4;
                    Slice fromKey = (Slice)range.fromKey();
                    Slice maxKey6 = (Slice)range.maxKey();
                    fixed = new MaxKey.Range(serializer.read(fromKey), serializer.read(maxKey6));
                }
                return new IO.Right((Object)new RepairResult.OverlappingSegments(segmentInfo2, new SegmentInfo(path2, object2, (MaxKey)fixed, overlappingSegmentInfo.segmentSize(), overlappingSegmentInfo.keyValueCount())), (IO.ExceptionHandler)Error.Segment$.ExceptionHandler$.MODULE$);
            }
        }
        if (bl) {
            Error.Level error = (Error.Level)left.value();
            return new IO.Left((Object)error, (IO.ExceptionHandler)Error.Level$.ExceptionHandler$.MODULE$);
        }
        if (iO instanceof IO.Right) return new IO.Right((Object)RepairResult.Repaired$.MODULE$, (IO.ExceptionHandler)Error.Segment$.ExceptionHandler$.MODULE$);
        throw new MatchError((Object)iO);
    }

    public <K> KeyOrder<Slice<Object>> repairAppendix$default$5(Path levelPath, AppendixRepairStrategy repairStrategy) {
        return KeyOrder$.MODULE$.default();
    }

    public <K> ExecutionContext repairAppendix$default$6(Path levelPath, AppendixRepairStrategy repairStrategy) {
        return this.defaultExecutionContext();
    }

    private final SwayFunctionOutput function$1(Slice key, Option deadline, Function2 f$1, Serializer keySerializer$3, Serializer valueSerializer$3) {
        return this.toCoreFunctionOutput((Apply)f$1.apply(package$.MODULE$.Decode(key).read(keySerializer$3), (Object)deadline), valueSerializer$3);
    }

    private final SwayFunctionOutput function$2(Slice key, Option value, Option deadline, Function3 f$2, Serializer keySerializer$4, Serializer valueSerializer$4) {
        return this.toCoreFunctionOutput((Apply)f$2.apply(package$.MODULE$.Decode(key).read(keySerializer$4), package$.MODULE$.DecodeOption(value).read(valueSerializer$4), (Object)deadline), valueSerializer$4);
    }

    private final SwayFunctionOutput function$3(Option value, Function1 f$3, Serializer valueSerializer$5) {
        return this.toCoreFunctionOutput((Apply)f$3.apply(package$.MODULE$.DecodeOption(value).read(valueSerializer$5)), valueSerializer$5);
    }

    private SwayDB$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.memoryFunctionStore = FunctionStore$.MODULE$.memory();
        this.timeOrder = TimeOrder$.MODULE$.long();
    }
}

