/*
 * Decompiled with CFR 0.152.
 */
package swaydb.compression;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import scala.Double$;
import scala.MatchError;
import scala.Product;
import scala.util.Random$;
import swaydb.Compression;
import swaydb.compression.CompressionInternal;
import swaydb.compression.CompressionInternal$UnCompressed$;
import swaydb.compression.CompressorInternal$;
import swaydb.compression.DecompressorInternal$;
import swaydb.data.compression.LZ4Compressor;
import swaydb.data.compression.LZ4Decompressor;
import swaydb.data.compression.LZ4Instance;

public final class CompressionInternal$
implements LazyLogging {
    public static CompressionInternal$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new CompressionInternal$();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public CompressionInternal apply(Compression compression) {
        CompressionInternal compressionInternal;
        if (compression instanceof Compression.LZ4) {
            Compression.LZ4 lZ4 = (Compression.LZ4)compression;
            compressionInternal = this.apply(lZ4);
        } else if (compression instanceof Compression.Snappy) {
            double minCompressionPercentage = ((Compression.Snappy)compression).minCompressionPercentage();
            compressionInternal = new CompressionInternal.Snappy(minCompressionPercentage);
        } else if (Compression.None$.MODULE$.equals(compression)) {
            compressionInternal = CompressionInternal$UnCompressed$.MODULE$;
        } else {
            throw new MatchError((Object)compression);
        }
        return compressionInternal;
    }

    public CompressionInternal.LZ4 apply(Compression.LZ4 compression) {
        return new CompressionInternal.LZ4(CompressorInternal$.MODULE$.apply((LZ4Instance)compression.compressor()._1(), (LZ4Compressor)compression.compressor()._2()), DecompressorInternal$.MODULE$.apply((LZ4Instance)compression.decompressor()._1(), (LZ4Decompressor)compression.decompressor()._2()));
    }

    public Product random(double minCompressionPercentage) {
        if (Random$.MODULE$.nextBoolean()) {
            return new CompressionInternal.LZ4(CompressorInternal$.MODULE$.randomLZ4(minCompressionPercentage), DecompressorInternal$.MODULE$.randomLZ4());
        }
        if (Random$.MODULE$.nextBoolean()) {
            return new CompressionInternal.Snappy(minCompressionPercentage);
        }
        return CompressionInternal$UnCompressed$.MODULE$;
    }

    public double random$default$1() {
        return Double$.MODULE$.MinValue();
    }

    public Product randomLZ4OrSnappy(double minCompressionPercentage) {
        if (Random$.MODULE$.nextBoolean()) {
            return this.randomLZ4(minCompressionPercentage);
        }
        return this.randomSnappy(minCompressionPercentage);
    }

    public CompressionInternal.Snappy randomSnappy(double minCompressionPercentage) {
        return new CompressionInternal.Snappy(minCompressionPercentage);
    }

    public double randomSnappy$default$1() {
        return Double$.MODULE$.MinValue();
    }

    public CompressionInternal.LZ4 randomLZ4(double minCompressionPercentage) {
        return new CompressionInternal.LZ4(CompressorInternal$.MODULE$.randomLZ4(minCompressionPercentage), DecompressorInternal$.MODULE$.randomLZ4());
    }

    public double randomLZ4OrSnappy$default$1() {
        return Double$.MODULE$.MinValue();
    }

    public double randomLZ4$default$1() {
        return Double$.MODULE$.MinValue();
    }

    private CompressionInternal$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

