/*
 * Decompiled with CFR 0.152.
 */
package swaydb.compression;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import net.jpountz.lz4.LZ4Factory;
import scala.Double$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxesRunTime;
import swaydb.compression.CompressorInternal;
import swaydb.data.compression.LZ4Compressor;
import swaydb.data.compression.LZ4Compressor$;
import swaydb.data.compression.LZ4Instance;
import swaydb.data.compression.LZ4Instance$;

public final class CompressorInternal$
implements LazyLogging {
    public static CompressorInternal$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new CompressorInternal$();
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public CompressorInternal.LZ4 apply(LZ4Instance instance, LZ4Compressor compressor) {
        return this.lz4Compressor(compressor, this.lz4Factory(instance));
    }

    private LZ4Factory lz4Factory(LZ4Instance instance) {
        LZ4Factory lZ4Factory;
        if (LZ4Instance.Fastest$.MODULE$.equals(instance)) {
            lZ4Factory = LZ4Factory.fastestInstance();
        } else if (LZ4Instance.FastestJava$.MODULE$.equals(instance)) {
            lZ4Factory = LZ4Factory.fastestJavaInstance();
        } else if (LZ4Instance.Native$.MODULE$.equals(instance)) {
            lZ4Factory = LZ4Factory.nativeInstance();
        } else if (LZ4Instance.Safe$.MODULE$.equals(instance)) {
            lZ4Factory = LZ4Factory.safeInstance();
        } else if (LZ4Instance.Unsafe$.MODULE$.equals(instance)) {
            lZ4Factory = LZ4Factory.unsafeInstance();
        } else {
            throw new MatchError((Object)instance);
        }
        return lZ4Factory;
    }

    private CompressorInternal.LZ4 lz4Compressor(LZ4Compressor compressor, LZ4Factory factory) {
        CompressorInternal.LZ4 lZ4;
        if (compressor instanceof LZ4Compressor.Fast) {
            double minCompressionPercentage = ((LZ4Compressor.Fast)compressor).minCompressionSavingsPercent();
            lZ4 = new CompressorInternal.LZ4(minCompressionPercentage, factory.fastCompressor());
        } else if (compressor instanceof LZ4Compressor.High) {
            CompressorInternal.LZ4 lZ42;
            LZ4Compressor.High high = (LZ4Compressor.High)compressor;
            double minCompressionPercentage = high.minCompressionSavingsPercent();
            Option compressionLevel = high.compressionLevel();
            if (compressionLevel instanceof Some) {
                int compressionLevel2 = BoxesRunTime.unboxToInt((Object)((Some)compressionLevel).value());
                lZ42 = new CompressorInternal.LZ4(minCompressionPercentage, factory.highCompressor(compressionLevel2));
            } else if (None$.MODULE$.equals(compressionLevel)) {
                lZ42 = new CompressorInternal.LZ4(minCompressionPercentage, factory.highCompressor());
            } else {
                throw new MatchError((Object)compressionLevel);
            }
            lZ4 = lZ42;
        } else {
            throw new MatchError((Object)compressor);
        }
        return lZ4;
    }

    public boolean isCompressionSatisfied(double minCompressionPercentage, int compressedLength, int originalLength, String compressionName) {
        double compressionSavedPercentage = (1.0 - (double)compressedLength / (double)originalLength) * (double)100;
        if (compressionSavedPercentage < minCompressionPercentage) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Uncompressed! {} - {}.bytes compressed to {}.bytes. Compression savings = {}%. Required minimum {}%.", new Object[]{compressionName, BoxesRunTime.boxToInteger((int)originalLength), BoxesRunTime.boxToInteger((int)compressedLength), BoxesRunTime.boxToDouble((double)compressionSavedPercentage), BoxesRunTime.boxToDouble((double)minCompressionPercentage)});
            }
            return false;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Compressed! {} - {}.bytes compressed to {}.bytes. Compression savings = {}%. Required minimum {}%.", new Object[]{compressionName, BoxesRunTime.boxToInteger((int)originalLength), BoxesRunTime.boxToInteger((int)compressedLength), BoxesRunTime.boxToDouble((double)compressionSavedPercentage), BoxesRunTime.boxToDouble((double)minCompressionPercentage)});
        }
        return true;
    }

    public CompressorInternal.LZ4 randomLZ4(double minCompressionSavingsPercent) {
        return this.apply(LZ4Instance$.MODULE$.random(), (LZ4Compressor)LZ4Compressor$.MODULE$.random(minCompressionSavingsPercent));
    }

    public double randomLZ4$default$1() {
        return Double$.MODULE$.MinValue();
    }

    private CompressorInternal$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

