/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.syndesis.integration.model.DtoSupport;
import io.syndesis.integration.model.steps.Choice;
import io.syndesis.integration.model.steps.Endpoint;
import io.syndesis.integration.model.steps.Filter;
import io.syndesis.integration.model.steps.Function;
import io.syndesis.integration.model.steps.Log;
import io.syndesis.integration.model.steps.SetBody;
import io.syndesis.integration.model.steps.SetHeaders;
import io.syndesis.integration.model.steps.Split;
import io.syndesis.integration.model.steps.Step;
import io.syndesis.integration.model.steps.Throttle;
import io.syndesis.integration.support.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Flow
extends DtoSupport {
    private String name;
    private Boolean trace;
    private Boolean logResult;
    private Boolean singleMessageMode;
    private List<Step> steps = new ArrayList<Step>();

    public Flow addStep(Step step) {
        this.steps.add(step);
        return this;
    }

    public Flow name(String value) {
        this.setName(value);
        return this;
    }

    public Flow logResult(boolean value) {
        this.setLogResult(value);
        return this;
    }

    public Flow trace(boolean value) {
        this.setTrace(value);
        return this;
    }

    public Flow singleMessageMode(boolean value) {
        this.setSingleMessageMode(value);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Flow ");
        if (!Strings.isEmpty(this.name)) {
            builder.append(this.name);
            builder.append(": ");
        }
        if (this.steps != null) {
            boolean first = true;
            for (Step step : this.steps) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" => ");
                }
                builder.append(step);
            }
        }
        if (this.isTraceEnabled()) {
            builder.append(" (tracing) ");
        }
        return builder.toString();
    }

    public Flow endpoint(String uri) {
        return this.addStep(new Endpoint(uri));
    }

    public Flow function(String name) {
        return this.addStep(new Function(name));
    }

    public Flow setBody(String body) {
        return this.addStep(new SetBody(body));
    }

    public Flow setHeaders(Map<String, Object> headers) {
        return this.addStep(new SetHeaders(headers));
    }

    public Split split(String expression) {
        Split step = new Split(expression);
        this.addStep(step);
        return step;
    }

    public Filter filter(String expression) {
        Filter step = new Filter(expression);
        this.addStep(step);
        return step;
    }

    public Choice choice() {
        Choice step = new Choice();
        this.addStep(step);
        return step;
    }

    public Throttle throttle(long maximumRequests) {
        Throttle step = new Throttle(maximumRequests);
        this.addStep(step);
        return step;
    }

    public Throttle throttle(long maximumRequests, long periodMillis) {
        Throttle step = new Throttle(maximumRequests, periodMillis);
        this.addStep(step);
        return step;
    }

    public Log log(String message, String loggingLevel, String logger, String marker) {
        Log step = new Log(message, loggingLevel, logger, marker);
        this.addStep(step);
        return step;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getTrace() {
        return this.trace;
    }

    public void setTrace(Boolean trace) {
        this.trace = trace;
    }

    public Boolean getLogResult() {
        return this.logResult;
    }

    public void setLogResult(Boolean logResult) {
        this.logResult = logResult;
    }

    public Boolean getSingleMessageMode() {
        return this.singleMessageMode;
    }

    public void setSingleMessageMode(Boolean singleMessageMode) {
        this.singleMessageMode = singleMessageMode;
    }

    @JsonIgnore
    public boolean isTraceEnabled() {
        return this.trace != null && this.trace != false;
    }

    @JsonIgnore
    public boolean isLogResultEnabled() {
        return this.logResult != null && this.logResult != false;
    }

    @JsonIgnore
    public boolean isSingleMessageModeEnabled() {
        return this.singleMessageMode != null && this.singleMessageMode != false;
    }
}

