/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.syndesis.integration.model.SyndesisModel;
import io.syndesis.integration.model.steps.Step;
import java.io.IOException;
import java.io.InputStream;
import java.util.ServiceLoader;

public final class YamlHelpers {
    private YamlHelpers() {
    }

    public static ObjectMapper createObjectMapper() {
        YAMLFactory yamlFactory = new YAMLFactory().configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false).configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, true).configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yamlFactory).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        for (Step step : ServiceLoader.load(Step.class, YamlHelpers.class.getClassLoader())) {
            mapper.registerSubtypes(new NamedType[]{new NamedType(step.getClass(), step.getKind())});
        }
        return mapper;
    }

    public static SyndesisModel load(InputStream source) throws IOException {
        return (SyndesisModel)YamlHelpers.createObjectMapper().readValue(source, SyndesisModel.class);
    }
}

