/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.model.steps;

import io.syndesis.integration.model.steps.Choice;
import io.syndesis.integration.model.steps.Endpoint;
import io.syndesis.integration.model.steps.Filter;
import io.syndesis.integration.model.steps.Function;
import io.syndesis.integration.model.steps.Log;
import io.syndesis.integration.model.steps.SetBody;
import io.syndesis.integration.model.steps.SetHeaders;
import io.syndesis.integration.model.steps.Split;
import io.syndesis.integration.model.steps.Step;
import io.syndesis.integration.model.steps.Throttle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ChildSteps<T extends ChildSteps>
extends Step {
    protected List<Step> steps = new ArrayList<Step>();

    public ChildSteps(String kind) {
        super(kind);
    }

    public ChildSteps(String kind, List<Step> steps) {
        super(kind);
        this.steps = steps;
    }

    public T addStep(Step step) {
        this.steps.add(step);
        return (T)this;
    }

    public T endpoint(String uri) {
        return this.addStep(new Endpoint(uri));
    }

    public T function(String name) {
        return this.addStep(new Function(name));
    }

    public T setBody(String body) {
        return this.addStep(new SetBody(body));
    }

    public T setHeaders(Map<String, Object> headers) {
        return this.addStep(new SetHeaders(headers));
    }

    public Split split(String expression) {
        Split step = new Split(expression);
        this.addStep(step);
        return step;
    }

    public Filter filter(String expression) {
        Filter step = new Filter(expression);
        this.addStep(step);
        return step;
    }

    public Choice choice() {
        Choice step = new Choice();
        this.addStep(step);
        return step;
    }

    public Throttle throttle(long maximumRequests) {
        Throttle step = new Throttle(maximumRequests);
        this.addStep(step);
        return step;
    }

    public Throttle throttle(long maximumRequests, long periodMillis) {
        Throttle step = new Throttle(maximumRequests, periodMillis);
        this.addStep(step);
        return step;
    }

    public Log log(String message, String loggingLevel, String logger, String marker) {
        Log step = new Log(message, loggingLevel, logger, marker);
        this.addStep(step);
        return step;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }
}

