/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.builder.image.generator;

import io.syndesis.common.model.Dependency;
import io.syndesis.common.model.Kind;
import io.syndesis.common.model.ModelData;
import io.syndesis.common.model.action.Action;
import io.syndesis.common.model.action.ConnectorAction;
import io.syndesis.common.model.action.ConnectorDescriptor;
import io.syndesis.common.model.connection.Connection;
import io.syndesis.common.model.connection.Connector;
import io.syndesis.common.model.connection.ConnectorTemplate;
import io.syndesis.common.model.integration.Flow;
import io.syndesis.common.model.integration.Integration;
import io.syndesis.common.model.integration.Step;
import io.syndesis.common.model.integration.StepKind;
import io.syndesis.common.model.integration.step.template.TemplateStepLanguage;
import io.syndesis.common.util.MavenProperties;
import io.syndesis.common.util.SuppressFBWarnings;
import io.syndesis.common.util.json.JsonUtils;
import io.syndesis.integration.api.IntegrationResourceManager;
import io.syndesis.integration.project.generator.ProjectGenerator;
import io.syndesis.integration.project.generator.ProjectGeneratorAutoConfiguration;
import io.syndesis.integration.project.generator.ProjectGeneratorConfiguration;
import io.syndesis.server.builder.image.generator.Application;
import io.syndesis.server.builder.image.generator.SpringMavenProperties;
import io.syndesis.server.dao.init.ReadApiClientData;
import io.syndesis.server.dao.manager.DaoConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;

@EnableConfigurationProperties(value={SpringMavenProperties.class})
@SpringBootApplication(exclude={DaoConfiguration.class, ProjectGeneratorAutoConfiguration.class})
public class Application
implements ApplicationRunner {
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private MavenProperties mavenProperties;
    @Value(value="${to:image}")
    private String to;

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    public void run(ApplicationArguments args) {
        try {
            System.out.println("To: " + this.to);
            this.generateIntegrationProject(new File(this.to));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private GatheredDependencies collectAllSteps() throws IOException {
        String deploymentText;
        ReadApiClientData reader = new ReadApiClientData();
        GatheredDependencies deps = new GatheredDependencies(null);
        try (InputStream is = this.resourceLoader.getResource("io/syndesis/server/dao/deployment.json").getInputStream();){
            deploymentText = reader.from(is);
        }
        List modelList = reader.readDataFromString(deploymentText);
        HashMap<String, String> schemeIdMap = new HashMap<String, String>();
        for (ModelData model : modelList) {
            if (model.getKind() == Kind.Connector) {
                Connector connector = (Connector)model.getData();
                for (Action action : connector.getActions()) {
                    deps.steps.add(new Step.Builder().stepKind(StepKind.endpoint).connection(new Connection.Builder().connector(connector).connectorId((String)connector.getId().get()).build()).action(action).build());
                }
            }
            if (model.getKind() != Kind.ConnectorTemplate) continue;
            ConnectorTemplate template = (ConnectorTemplate)model.getData();
            schemeIdMap.put(template.getComponentScheme(), (String)template.getId().get());
            deps.steps.add(new Step.Builder().stepKind(StepKind.endpoint).connection(new Connection.Builder().connectorId((String)template.getId().get()).build()).action((Action)new ConnectorAction.Builder().descriptor(new ConnectorDescriptor.Builder().componentScheme(template.getComponentScheme()).build()).build()).build());
        }
        try {
            ResourcePatternResolver resolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader);
            Resource[] resources = resolver.getResources("classpath:/META-INF/syndesis/connector/*.json");
            if (resources != null) {
                for (Resource resource : resources) {
                    Connector connector = (Connector)JsonUtils.reader().forType(Connector.class).readValue(resource.getInputStream());
                    if (connector == null) continue;
                    String templateId = (String)schemeIdMap.get(connector.getComponentScheme().orElse(null));
                    if (templateId != null) {
                        deps.connectorMap.put(templateId, connector);
                    }
                    deps.steps.add(new Step.Builder().stepKind(StepKind.endpoint).connection(new Connection.Builder().connector(connector).connectorId((String)connector.getId().get()).build()).build());
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Stream.of(TemplateStepLanguage.FREEMARKER, TemplateStepLanguage.MUSTACHE, TemplateStepLanguage.VELOCITY).forEach(t -> deps.steps.add(new Step.Builder().stepKind(StepKind.template).addDependency(Dependency.maven((String)t.mavenDependency())).build()));
        return deps;
    }

    private void generateIntegrationProject(File project) throws IOException {
        GatheredDependencies deps = this.collectAllSteps();
        StringBuilder parentPom = new StringBuilder(5000);
        parentPom.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://maven.apache.org/POM/4.0.0\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"><modelVersion>4.0.0</modelVersion> <groupId>io.syndesis.integrations</groupId><artifactId>project</artifactId><version>0.1-SNAPSHOT</version><packaging>pom</packaging>\n");
        Map repositories = this.mavenProperties.getRepositories();
        repositories.put("central", "https://repo.maven.apache.org/maven2/");
        repositories.put("redhat-ga", "https://maven.repository.redhat.com/ga/");
        repositories.put("atlassian-public", "https://packages.atlassian.com/maven-external");
        if (!repositories.isEmpty()) {
            parentPom.append("<repositories>\n");
            for (Map.Entry repository : repositories.entrySet()) {
                parentPom.append("<repository>\n<id>").append((String)repository.getKey()).append("</id>\n").append("<url>").append((String)repository.getValue()).append("</url>\n").append("<releases>\n<enabled>true</enabled>\n<updatePolicy>never</updatePolicy>\n</releases>\n<snapshots>\n<enabled>true</enabled>\n<updatePolicy>never</updatePolicy>\n</snapshots>\n</repository>");
            }
            parentPom.append("</repositories>\n");
        }
        parentPom.append("<modules>");
        int i = 0;
        for (Step step : deps.steps) {
            Integration integration = new Integration.Builder().id("Integration").name("Integration").description("This integration is used to prime the .m2 repo").addFlow(new Flow.Builder().addStep(step).build()).build();
            String artifactId = "p" + i++;
            File module = new File(project, artifactId);
            this.generate(integration, module, deps.connectorMap, artifactId);
            parentPom.append("<module>").append(artifactId).append("</module>\n");
        }
        parentPom.append("</modules></project>");
        Files.write(project.toPath().resolve("pom.xml"), parentPom.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void generate(Integration integration, File targetDir, Map<String, Connector> connectorMap, String artifactId) throws IOException {
        ProjectGeneratorConfiguration configuration = new ProjectGeneratorConfiguration();
        configuration.setArtifactId(artifactId);
        ProjectGenerator generator = new ProjectGenerator(configuration, (IntegrationResourceManager)new EmptyIntegrationResourceManager(connectorMap), this.mavenProperties);
        Path dir = targetDir.toPath();
        Files.createDirectories(dir, new FileAttribute[0]);
        Files.write(dir.resolve("pom.xml"), generator.generatePom(integration), new OpenOption[0]);
        dir = dir.resolve("src/main/java/io/syndesis/example");
        Files.createDirectories(dir, new FileAttribute[0]);
        ClassPathResource resource = new ClassPathResource("io/syndesis/integration/project/generator/templates/Application.java.mustache");
        try (InputStream is = resource.getInputStream();){
            Files.write(dir.resolve("Application.java"), IOUtils.toByteArray((InputStream)is), new OpenOption[0]);
        }
    }
}

