/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier.impl;

import io.syndesis.verifier.Verifier;
import io.syndesis.verifier.VerifierResponse;
import io.syndesis.verifier.impl.BaseVerifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.impl.DefaultCamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseVerifier
implements Verifier {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private CamelContext camel;
    private ComponentVerifierExtension verifier;
    private Class<? extends ComponentVerifierExtension> verifierExtensionClass;

    protected BaseVerifier() {
        this(ComponentVerifierExtension.class);
    }

    protected BaseVerifier(Class<? extends ComponentVerifierExtension> verifierExtensionClass) {
        this.verifierExtensionClass = verifierExtensionClass;
    }

    @PostConstruct
    public void start() throws Exception {
        this.camel = new DefaultCamelContext();
        this.camel.start();
        Component component = this.camel.getComponent(this.getConnectorAction(), true, false);
        if (component == null) {
            this.log.error("Component {} does not exist", (Object)this.getConnectorAction());
        } else {
            this.verifier = component.getExtension(this.verifierExtensionClass).orElse(null);
            if (this.verifier == null) {
                this.log.warn("Component {} does not support verifier extension", (Object)this.getConnectorAction());
            }
        }
    }

    @PreDestroy
    public void stop() throws Exception {
        this.camel.stop();
    }

    protected abstract String getConnectorAction();

    public List<VerifierResponse> verify(Map<String, Object> params) {
        if (this.verifier == null) {
            return Collections.singletonList(this.createUnsupportedResponse());
        }
        this.customize(params);
        ArrayList<VerifierResponse> resp = new ArrayList<VerifierResponse>();
        for (Verifier.Scope scope : Verifier.Scope.values()) {
            try {
                ComponentVerifierExtension.Result result = this.verifier.verify(this.toComponentScope(scope), params);
                resp.add(this.toVerifierResponse(result));
                this.log.info("PING: {} === {}", (Object)this.getConnectorAction(), (Object)result.getStatus());
                if (result.getStatus() == ComponentVerifierExtension.Result.Status.ERROR) {
                    this.log.error("{} --> ", (Object)this.getConnectorAction());
                    for (ComponentVerifierExtension.VerificationError error : result.getErrors()) {
                        this.log.error("   {} : {}", (Object)error.getCode(), (Object)error.getDescription());
                    }
                }
                if (result.getStatus() != ComponentVerifierExtension.Result.Status.ERROR && result.getStatus() != ComponentVerifierExtension.Result.Status.UNSUPPORTED) continue;
                break;
            }
            catch (Exception exp) {
                resp.add(this.toExceptionResponse(exp, scope, params.keySet()));
                this.log.error("Exception during verify with params {} and scope {} : {}", new Object[]{params, scope, exp.getMessage(), exp});
            }
        }
        return resp;
    }

    protected void customize(Map<String, Object> params) {
    }

    private ComponentVerifierExtension.Scope toComponentScope(Verifier.Scope scope) {
        switch (1.$SwitchMap$io$syndesis$verifier$Verifier$Scope[scope.ordinal()]) {
            case 1: {
                return ComponentVerifierExtension.Scope.CONNECTIVITY;
            }
            case 2: {
                return ComponentVerifierExtension.Scope.PARAMETERS;
            }
        }
        throw new IllegalArgumentException("Unknown scope value " + scope);
    }

    private VerifierResponse createUnsupportedResponse() {
        return new VerifierResponse.Builder(Verifier.Status.UNSUPPORTED, Verifier.Scope.PARAMETERS).error("internal-error", String.format("No action %s used for the verification known", this.getConnectorAction())).build();
    }

    private VerifierResponse toVerifierResponse(ComponentVerifierExtension.Result result) {
        VerifierResponse.Builder builder = new VerifierResponse.Builder(result.getStatus().name(), result.getScope().name());
        if (result.getErrors() != null) {
            for (ComponentVerifierExtension.VerificationError error : result.getErrors()) {
                builder.withError(error.getCode().getName()).description(error.getDescription()).parameters(error.getParameterKeys()).attributes(error.getDetails().entrySet().stream().collect(Collectors.toMap(e -> ((ComponentVerifierExtension.VerificationError.Attribute)e.getKey()).name(), e -> e.getValue()))).endError();
            }
        }
        return builder.build();
    }

    private VerifierResponse toExceptionResponse(Exception exp, Verifier.Scope scope, Set<String> params) {
        VerifierResponse.Builder builder = new VerifierResponse.Builder(Verifier.Status.ERROR, scope);
        return builder.withError(ComponentVerifierExtension.VerificationError.StandardCode.EXCEPTION.name()).description(exp.getMessage()).parameters(params).attributes(this.extractExceptionDetails(exp)).endError().build();
    }

    private Map<String, Object> extractExceptionDetails(Exception exp) {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put(ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_CLASS.name(), exp.getClass().getName());
        details.put(ComponentVerifierExtension.VerificationError.ExceptionAttribute.EXCEPTION_INSTANCE.name(), exp);
        return details;
    }
}

