/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier.v1;

import io.syndesis.verifier.v1.metadata.MetadataAdapter;
import io.syndesis.verifier.v1.metadata.SyndesisMetadata;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.component.extension.MetaDataExtension;
import org.apache.camel.impl.DefaultCamelContext;

class MetadataEndpoint {
    private final MetadataAdapter<?> adapter;
    private final String connectorId;

    public MetadataEndpoint(String connectorId, MetadataAdapter<?> adapter) {
        this.connectorId = connectorId;
        this.adapter = adapter;
    }

    CamelContext camelContext() {
        return new DefaultCamelContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SyndesisMetadata<?> fetchMetadata(Map<String, Object> properties) {
        SyndesisMetadata syndesisMetadata;
        CamelContext camel = this.camelContext();
        camel.start();
        try {
            MetaDataExtension metadataExtension = (MetaDataExtension)camel.getComponent(this.connectorId, true, false).getExtension(MetaDataExtension.class).orElseThrow(() -> new IllegalArgumentException("No Metadata extension present for connector: " + this.connectorId));
            Map<String, Object> propertiesForMetadataExtension = properties.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            MetaDataExtension.MetaData metaData = (MetaDataExtension.MetaData)metadataExtension.meta(propertiesForMetadataExtension).orElseThrow(() -> new IllegalArgumentException("No Metadata returned by the metadata extension"));
            syndesisMetadata = this.adapter.adapt(properties, metaData);
        }
        catch (Throwable throwable) {
            try {
                camel.stop();
                throw throwable;
            }
            catch (Exception e2) {
                throw new IllegalStateException("Unable to fetch and process metadata", e2);
            }
        }
        camel.stop();
        return syndesisMetadata;
    }

    static MetadataAdapter<?> adapterFor(Map<String, MetadataAdapter<?>> adapters, String connectorId) {
        return Optional.ofNullable(adapters.get(connectorId + "-adapter")).orElseThrow(() -> new IllegalStateException("Unable to find adapter for:" + connectorId));
    }
}

