/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier.v1;

import io.syndesis.verifier.Verifier;
import io.syndesis.verifier.VerifierRegistry;
import io.syndesis.verifier.VerifierResponse;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.stereotype.Component;

@Component
@Path(value="/verifier")
public class VerifierEndpoint {
    private VerifierRegistry verifierRegistry;

    public VerifierEndpoint(VerifierRegistry verifierRegistry) {
        this.verifierRegistry = verifierRegistry;
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{id}")
    public List<VerifierResponse> verify(@PathParam(value="id") String connectorId, Map<String, Object> parameters) {
        Verifier verifier = this.verifierRegistry.getVerifier(connectorId);
        if (verifier == null) {
            return Collections.singletonList(this.createUnsupportedResponse(connectorId));
        }
        return this.filterExceptions(verifier.verify(parameters));
    }

    private List<VerifierResponse> filterExceptions(List<VerifierResponse> responses) {
        for (VerifierResponse response : responses) {
            List errors = response.getErrors();
            if (errors == null) continue;
            for (VerifierResponse.Error error : errors) {
                Map attributes = error.getAttributes();
                if (attributes == null) continue;
                HashSet toRemove = new HashSet();
                for (Map.Entry entry : attributes.entrySet()) {
                    if (!(entry.getValue() instanceof Exception)) continue;
                    toRemove.add(entry.getKey());
                }
                for (String key : toRemove) {
                    attributes.remove(key);
                }
            }
        }
        return responses;
    }

    private VerifierResponse createUnsupportedResponse(String connectorId) {
        return new VerifierResponse.Builder(Verifier.Status.UNSUPPORTED, Verifier.Scope.PARAMETERS).error("unknown-connector", String.format("No connector for ID %s registered", connectorId)).build();
    }
}

