/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier.v1.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;
import io.syndesis.verifier.v1.metadata.MetadataAdapter;
import io.syndesis.verifier.v1.metadata.PropertyPair;
import io.syndesis.verifier.v1.metadata.SyndesisMetadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.component.extension.MetaDataExtension;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="salesforce-adapter")
public final class SalesforceMetadataAdapter
implements MetadataAdapter<ObjectSchema> {
    public SyndesisMetadata<ObjectSchema> adapt(Map<String, Object> properties, MetaDataExtension.MetaData metadata) {
        ObjectSchema schema = SalesforceMetadataAdapter.schemaPayload((MetaDataExtension.MetaData)metadata);
        Set<Object> schemasToConsider = SalesforceMetadataAdapter.isPresentAndNonNull(properties, (String)"sObjectName") ? Collections.singleton(SalesforceMetadataAdapter.objectSchemaFrom((ObjectSchema)schema)) : schema.getOneOf().stream().filter(SalesforceMetadataAdapter::isObjectSchema).map(ObjectSchema.class::cast).collect(Collectors.toSet());
        HashMap enrichedProperties = new HashMap();
        enrichedProperties.put("sObjectName", schemasToConsider.stream().map(SalesforceMetadataAdapter::nameAndTitlePropertyPairOf).collect(Collectors.toList()));
        if (SalesforceMetadataAdapter.isPresent(properties, (String)"sObjectIdName")) {
            enrichedProperties.put("sObjectIdName", schemasToConsider.stream().flatMap(s -> s.getProperties().entrySet().stream()).filter(e -> SalesforceMetadataAdapter.isIdLookup((JsonSchema)((JsonSchema)e.getValue()))).map(SalesforceMetadataAdapter::createFieldPairPropertyFromSchemaEntry).collect(Collectors.toList()));
        }
        if (SalesforceMetadataAdapter.isPresentAndNonNull(properties, (String)"sObjectName")) {
            String objectName = (String)properties.get("sObjectName");
            ObjectSchema inputOutputSchema = SalesforceMetadataAdapter.inputOutputSchemaFor(schemasToConsider, (String)objectName);
            return new SyndesisMetadata(enrichedProperties, (Object)inputOutputSchema, (Object)inputOutputSchema);
        }
        return new SyndesisMetadata(enrichedProperties, null, null);
    }

    static ObjectSchema adaptSchema(ObjectSchema schema) {
        schema.set$schema("http://json-schema.org/draft-04/schema#");
        return schema;
    }

    static ObjectSchema convertSalesforceGlobalObjectJsonToSchema(JsonNode payload) {
        HashSet<ObjectSchema> allSchemas = new HashSet<ObjectSchema>();
        for (JsonNode sobject : payload) {
            ObjectSchema sobjectSchema = new ObjectSchema();
            sobjectSchema.setId("urn:jsonschema:org:apache:camel:component:salesforce:dto:" + sobject.get("name").asText());
            sobjectSchema.setTitle(sobject.get("label").asText());
            allSchemas.add(sobjectSchema);
        }
        ObjectSchema schema = new ObjectSchema();
        schema.setOneOf(allSchemas);
        return schema;
    }

    static PropertyPair createFieldPairPropertyFromSchemaEntry(Map.Entry<String, JsonSchema> e) {
        return new PropertyPair(e.getKey(), ((SimpleTypeSchema)e.getValue()).getTitle());
    }

    static PropertyPair createObjectPairPropertyFromNode(JsonNode node) {
        String value = node.get("name").asText();
        String displayValue = node.get("label").asText();
        return new PropertyPair(value, displayValue);
    }

    static ObjectSchema inputOutputSchemaFor(Set<ObjectSchema> schemasToConsider, String objectName) {
        for (ObjectSchema schema : schemasToConsider) {
            if (!schema.getId().contains(":" + objectName)) continue;
            return SalesforceMetadataAdapter.adaptSchema((ObjectSchema)schema);
        }
        throw new IllegalArgumentException("Unable to find object schema for: " + objectName);
    }

    static boolean isIdLookup(JsonSchema property) {
        String description = property.getDescription();
        if (description == null) {
            return false;
        }
        return description.contains("idLookup");
    }

    static boolean isObjectSchema(Object obj) {
        ObjectSchema schema = (ObjectSchema)obj;
        String id = schema.getId();
        return !id.contains(":QueryRecords");
    }

    static boolean isPresent(Map<String, Object> properties, String property) {
        return properties != null && properties.containsKey(property);
    }

    static boolean isPresentAndNonNull(Map<String, Object> properties, String property) {
        return SalesforceMetadataAdapter.isPresent(properties, (String)property) && properties.get(property) != null;
    }

    static PropertyPair nameAndTitlePropertyPairOf(ObjectSchema schema) {
        String id = schema.getId();
        String objectName = id.substring(id.lastIndexOf(58) + 1);
        String objectLabel = schema.getTitle();
        return new PropertyPair(objectName, objectLabel);
    }

    static ObjectSchema objectSchemaFrom(ObjectSchema schema) {
        if (schema.getOneOf().isEmpty()) {
            return schema;
        }
        return (ObjectSchema)schema.getOneOf().stream().filter(ObjectSchema.class::isInstance).filter(SalesforceMetadataAdapter::isObjectSchema).findFirst().orElseThrow(() -> new IllegalStateException("The resulting schema does not contain an non query records object schema in `oneOf`"));
    }

    static ObjectSchema schemaPayload(MetaDataExtension.MetaData metadata) {
        Object payload = metadata.getPayload();
        if (payload instanceof ObjectSchema) {
            return (ObjectSchema)payload;
        }
        if (payload instanceof JsonNode) {
            return SalesforceMetadataAdapter.convertSalesforceGlobalObjectJsonToSchema((JsonNode)((JsonNode)payload));
        }
        throw new IllegalArgumentException("Unsupported metadata payload: " + payload);
    }
}

