/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier.v1.metadata;

import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import io.syndesis.connector.ColumnMode;
import io.syndesis.connector.StoredProcedureColumn;
import io.syndesis.connector.StoredProcedureMetadata;
import io.syndesis.verifier.v1.metadata.MetadataAdapter;
import io.syndesis.verifier.v1.metadata.PropertyPair;
import io.syndesis.verifier.v1.metadata.SqlStoredMetadataAdapter;
import io.syndesis.verifier.v1.metadata.SyndesisMetadata;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.extension.MetaDataExtension;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="sql-stored-connector-adapter")
public final class SqlStoredMetadataAdapter
implements MetadataAdapter<JsonSchema> {
    static final String PROCEDURE_NAME = "procedureName";
    static final String PROCEDURE_TEMPLATE = "template";

    public SyndesisMetadata<JsonSchema> adapt(Map<String, Object> properties, MetaDataExtension.MetaData metadata) {
        HashMap enrichedProperties = new HashMap();
        if (SqlStoredMetadataAdapter.isPresentAndNonNull(properties, (String)"procedureName")) {
            ArrayList<PropertyPair> ppList = new ArrayList<PropertyPair>();
            Map procedureMap = (Map)metadata.getPayload();
            String procedureName = (String)properties.get("procedureName");
            StoredProcedureMetadata storedProcedure = (StoredProcedureMetadata)procedureMap.get(procedureName);
            ppList.add(new PropertyPair(storedProcedure.getTemplate(), "template"));
            enrichedProperties.put("template", ppList);
            ObjectSchema builderIn = new ObjectSchema();
            builderIn.set$schema("http://json-schema.org/schema#");
            builderIn.setTitle(procedureName + "_IN");
            ObjectSchema builderOut = new ObjectSchema();
            builderOut.setTitle(procedureName + "_OUT");
            builderOut.set$schema("http://json-schema.org/schema#");
            if (storedProcedure.getColumnList() != null && !storedProcedure.getColumnList().isEmpty()) {
                for (StoredProcedureColumn column : storedProcedure.getColumnList()) {
                    if (column.getMode().equals((Object)ColumnMode.IN) || column.getMode().equals((Object)ColumnMode.INOUT)) {
                        builderIn.putProperty(column.getName(), SqlStoredMetadataAdapter.schemaFor((JDBCType)column.getJdbcType()));
                    }
                    if (!column.getMode().equals((Object)ColumnMode.OUT) && !column.getMode().equals((Object)ColumnMode.INOUT)) continue;
                    builderOut.putProperty(column.getName(), SqlStoredMetadataAdapter.schemaFor((JDBCType)column.getJdbcType()));
                }
            }
            return new SyndesisMetadata(enrichedProperties, (Object)builderIn, (Object)builderOut);
        }
        ArrayList<PropertyPair> ppList = new ArrayList<PropertyPair>();
        Map procedureMap = (Map)metadata.getPayload();
        for (String storedProcedureName : procedureMap.keySet()) {
            PropertyPair pp = new PropertyPair(storedProcedureName, storedProcedureName);
            ppList.add(pp);
        }
        enrichedProperties.put("procedureName", ppList);
        return new SyndesisMetadata(enrichedProperties, null, null);
    }

    static boolean isPresent(Map<String, Object> properties, String property) {
        return properties != null && properties.containsKey(property);
    }

    static boolean isPresentAndNonNull(Map<String, Object> properties, String property) {
        return SqlStoredMetadataAdapter.isPresent(properties, (String)property) && properties.get(property) != null;
    }

    static JsonSchema schemaFor(JDBCType jdbcType) {
        JsonSchemaFactory factory = new JsonSchemaFactory();
        switch (1.$SwitchMap$java$sql$JDBCType[jdbcType.ordinal()]) {
            case 1: {
                return factory.arraySchema();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                ArraySchema binary = factory.arraySchema();
                binary.setItemsSchema((JsonSchema)factory.integerSchema());
                return binary;
            }
            case 6: 
            case 7: {
                return factory.booleanSchema();
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return factory.stringSchema();
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                StringSchema date = factory.stringSchema();
                date.setFormat(JsonValueFormat.DATE_TIME);
                return date;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return factory.numberSchema();
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return factory.integerSchema();
            }
            case 33: {
                return factory.nullSchema();
            }
        }
        return factory.anySchema();
    }
}

