/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier;

import javax.servlet.Filter;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ExplicitCamelContextNameStrategy;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

@SpringBootApplication
public class Application {
    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean
    public static Filter requestLoggingFilter() {
        CommonsRequestLoggingFilter loggingFilter = new CommonsRequestLoggingFilter();
        loggingFilter.setIncludePayload(true);
        loggingFilter.setMaxPayloadLength(512);
        return loggingFilter;
    }

    @Scope(value="singleton")
    @Bean(name={"verifier-context"}, initMethod="start", destroyMethod="stop")
    public static CamelContext verifierContext() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.setNameStrategy((CamelContextNameStrategy)new ExplicitCamelContextNameStrategy("verifier-context"));
        context.disableJMX();
        return context;
    }
}

