/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier;

import io.syndesis.verifier.VerifierExceptionMapper;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringJoiner;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

@Component
@Provider
public class VerifierExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(VerifierExceptionMapper.class);

    public Response toResponse(Throwable exception) {
        HttpServletRequest request = (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
        LOG.error("Exception while handling request: {} {}", new Object[]{request.getMethod(), request.getRequestURI(), exception});
        if (LOG.isDebugEnabled()) {
            ContentCachingRequestWrapper requestCache = (ContentCachingRequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, ContentCachingRequestWrapper.class);
            Enumeration headers = request.getHeaderNames();
            StringJoiner headersJoined = new StringJoiner("\n");
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                headersJoined.add(header + ": " + String.join((CharSequence)"|", Collections.list(request.getHeaders(header))));
            }
            LOG.debug("Headers: \n{}", (Object)headersJoined.toString());
            LOG.debug("Request content: \n{}", (Object)new String(requestCache.getContentAsByteArray(), Charset.defaultCharset()));
        }
        Error error = new Error(Integer.valueOf(500), this.rootCauseMessage(exception), exception.getMessage());
        return Response.serverError().entity((Object)error).build();
    }

    private String rootCauseMessage(Throwable exception) {
        Throwable rootCause = exception;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        return rootCause.getMessage();
    }
}

