/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier.v1;

import io.syndesis.verifier.api.MetadataAdapter;
import io.syndesis.verifier.api.SyndesisMetadata;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.component.extension.MetaDataExtension;

class MetadataEndpoint {
    private final CamelContext camelContext;
    private final MetadataAdapter<?> adapter;
    private final String connectorId;
    private static final Set<String> CONNECTORS_WITH_DIFFERENT_METADATA_PER_ACTION = new HashSet<String>(Arrays.asList("sql"));

    MetadataEndpoint(CamelContext camelContext, String connectorId, MetadataAdapter<?> adapter) {
        this.camelContext = camelContext;
        this.connectorId = connectorId;
        this.adapter = adapter;
    }

    protected final SyndesisMetadata<?> fetchMetadata(String actionId, Map<String, Object> properties) {
        try {
            String componentId = this.connectorId;
            if (CONNECTORS_WITH_DIFFERENT_METADATA_PER_ACTION.contains(this.connectorId)) {
                componentId = actionId;
            }
            MetaDataExtension metadataExtension = (MetaDataExtension)this.camelContext.getComponent(componentId, true, false).getExtension(MetaDataExtension.class).orElseThrow(() -> new IllegalArgumentException("No Metadata extension present for action: " + actionId));
            Map<String, Object> propertiesForMetadataExtension = properties.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            MetaDataExtension.MetaData metaData = (MetaDataExtension.MetaData)metadataExtension.meta(propertiesForMetadataExtension).orElseThrow(() -> new IllegalArgumentException("No Metadata returned by the metadata extension"));
            return this.adapter.adapt(actionId, properties, metaData);
        }
        catch (Exception e2) {
            throw new IllegalStateException("Unable to fetch and process metadata", e2);
        }
    }
}

