/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier.v1;

import io.syndesis.verifier.api.Verifier;
import io.syndesis.verifier.api.VerifierResponse;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.FactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
@Path(value="/verifier")
public class VerifierEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifierEndpoint.class);
    private static final String RESOURCE_PATH = "META-INF/syndesis/connector/verifier/";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CamelContext camelContext;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{id}")
    public List<VerifierResponse> verify(@PathParam(value="id") String connectorId, Map<String, Object> parameters) {
        List answer;
        Verifier verifier;
        try {
            verifier = (Verifier)this.applicationContext.getBean(connectorId, Verifier.class);
        }
        catch (NoSuchBeanException | NoSuchBeanDefinitionException ignored) {
            LOGGER.debug("No bean of type: {} with id: {} found in application context, switch to factory finder", (Object)Verifier.class.getName(), (Object)connectorId);
            verifier = null;
            try {
                FactoryFinder finder = this.camelContext.getFactoryFinder(RESOURCE_PATH);
                Class type = finder.findClass(connectorId);
                verifier = (Verifier)this.camelContext.getInjector().newInstance(type);
            }
            catch (Exception e) {
                LOGGER.warn("No factory finder of type: {} for id: {}", new Object[]{Verifier.class.getName(), connectorId, e});
            }
        }
        if (verifier != null) {
            answer = verifier.verify(this.camelContext, connectorId, parameters);
            answer = this.filterExceptions(answer);
        } else {
            answer = Collections.singletonList(this.createUnsupportedResponse(connectorId));
        }
        return answer;
    }

    private List<VerifierResponse> filterExceptions(List<VerifierResponse> responses) {
        for (VerifierResponse response : responses) {
            List errors = response.getErrors();
            if (errors == null) continue;
            for (VerifierResponse.Error error : errors) {
                Map attributes = error.getAttributes();
                if (attributes == null) continue;
                HashSet toRemove = new HashSet();
                for (Map.Entry entry : attributes.entrySet()) {
                    if (!(entry.getValue() instanceof Exception)) continue;
                    toRemove.add(entry.getKey());
                }
                for (String key : toRemove) {
                    attributes.remove(key);
                }
            }
        }
        return responses;
    }

    private VerifierResponse createUnsupportedResponse(String connectorId) {
        return new VerifierResponse.Builder(Verifier.Status.UNSUPPORTED, Verifier.Scope.PARAMETERS).error("unknown-connector", String.format("No connector for ID %s registered", connectorId)).build();
    }
}

