/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.verifier.v1.metadata;

import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import io.syndesis.connector.sql.SqlParam;
import io.syndesis.connector.sql.SqlStatementMetaData;
import io.syndesis.connector.sql.stored.ColumnMode;
import io.syndesis.connector.sql.stored.StoredProcedureColumn;
import io.syndesis.connector.sql.stored.StoredProcedureMetadata;
import io.syndesis.verifier.api.MetadataAdapter;
import io.syndesis.verifier.api.PropertyPair;
import io.syndesis.verifier.api.SyndesisMetadata;
import io.syndesis.verifier.v1.metadata.SqlMetadataAdapter;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.extension.MetaDataExtension;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="sql-adapter")
public final class SqlMetadataAdapter
implements MetadataAdapter<JsonSchema> {
    static final String PROCEDURE_NAME = "procedureName";
    static final String PROCEDURE_TEMPLATE = "template";
    static final String PATTERN = "Pattern";
    static final String FROM_PATTERN = "From";
    static final String QUERY = "query";

    public SyndesisMetadata<JsonSchema> adapt(String actionId, Map<String, Object> properties, MetaDataExtension.MetaData metadata) {
        if (actionId.startsWith("sql-stored")) {
            return this.adaptForStoredSql(actionId, properties, metadata);
        }
        return this.adaptForSql(actionId, properties, metadata);
    }

    public SyndesisMetadata<JsonSchema> adaptForSql(String actionId, Map<String, Object> properties, MetaDataExtension.MetaData metadata) {
        HashMap enrichedProperties = new HashMap();
        ArrayList<PropertyPair> ppList = new ArrayList<PropertyPair>();
        SqlStatementMetaData sqlStatementMetaData = (SqlStatementMetaData)metadata.getPayload();
        if (sqlStatementMetaData != null) {
            ppList.add(new PropertyPair(sqlStatementMetaData.getSqlStatement(), "query"));
            enrichedProperties.put("query", ppList);
            ObjectSchema builderIn = new ObjectSchema();
            builderIn.set$schema("http://json-schema.org/schema#");
            builderIn.setTitle("SQL_PARAM_IN");
            for (SqlParam inParam : sqlStatementMetaData.getInParams()) {
                builderIn.putProperty(inParam.getName(), SqlMetadataAdapter.schemaFor((JDBCType)inParam.getJdbcType()));
            }
            ObjectSchema builderOut = new ObjectSchema();
            builderOut.setTitle("SQL_PARAM_OUT");
            builderOut.set$schema("http://json-schema.org/schema#");
            for (SqlParam outParam : sqlStatementMetaData.getOutParams()) {
                builderOut.putProperty(outParam.getName(), SqlMetadataAdapter.schemaFor((JDBCType)outParam.getJdbcType()));
            }
            return new SyndesisMetadata(enrichedProperties, (Object)builderIn, (Object)builderOut);
        }
        return new SyndesisMetadata(enrichedProperties, null, null);
    }

    public SyndesisMetadata<JsonSchema> adaptForStoredSql(String actionId, Map<String, Object> properties, MetaDataExtension.MetaData metadata) {
        HashMap<String, List> enrichedProperties = new HashMap<String, List>();
        if (SqlMetadataAdapter.isPresentAndNonNull(properties, (String)"procedureName")) {
            ArrayList<PropertyPair> ppList = new ArrayList<PropertyPair>();
            Map procedureMap = (Map)metadata.getPayload();
            String procedureName = (String)properties.get("procedureName");
            StoredProcedureMetadata storedProcedure = (StoredProcedureMetadata)procedureMap.get(procedureName);
            ppList.add(new PropertyPair(storedProcedure.getTemplate(), "template"));
            enrichedProperties.put("template", ppList);
            ObjectSchema builderIn = new ObjectSchema();
            builderIn.set$schema("http://json-schema.org/schema#");
            builderIn.setTitle(procedureName + "_IN");
            ObjectSchema builderOut = new ObjectSchema();
            builderOut.setTitle(procedureName + "_OUT");
            builderOut.set$schema("http://json-schema.org/schema#");
            if (storedProcedure.getColumnList() != null && !storedProcedure.getColumnList().isEmpty()) {
                for (StoredProcedureColumn column : storedProcedure.getColumnList()) {
                    if (column.getMode().equals((Object)ColumnMode.IN) || column.getMode().equals((Object)ColumnMode.INOUT)) {
                        builderIn.putProperty(column.getName(), SqlMetadataAdapter.schemaFor((JDBCType)column.getJdbcType()));
                    }
                    if (!column.getMode().equals((Object)ColumnMode.OUT) && !column.getMode().equals((Object)ColumnMode.INOUT)) continue;
                    builderOut.putProperty(column.getName(), SqlMetadataAdapter.schemaFor((JDBCType)column.getJdbcType()));
                }
            }
            return new SyndesisMetadata(enrichedProperties, (Object)builderIn, (Object)builderOut);
        }
        Map procedureMap = (Map)metadata.getPayload();
        if (SqlMetadataAdapter.isPresentAndNonNull(properties, (String)"Pattern") && "From".equalsIgnoreCase(String.valueOf(properties.get("Pattern")))) {
            enrichedProperties.put("procedureName", this.obtainFromProcedureList(procedureMap));
        } else {
            enrichedProperties.put("procedureName", this.obtainToProcedureList(procedureMap));
        }
        return new SyndesisMetadata(enrichedProperties, null, null);
    }

    private List<PropertyPair> obtainToProcedureList(Map<String, StoredProcedureMetadata> procedureMap) {
        ArrayList<PropertyPair> ppList = new ArrayList<PropertyPair>();
        for (String storedProcedureName : procedureMap.keySet()) {
            PropertyPair pp = new PropertyPair(storedProcedureName, storedProcedureName);
            ppList.add(pp);
        }
        return ppList;
    }

    private List<PropertyPair> obtainFromProcedureList(Map<String, StoredProcedureMetadata> procedureMap) {
        ArrayList<PropertyPair> ppList = new ArrayList<PropertyPair>();
        for (StoredProcedureMetadata storedProcedure : procedureMap.values()) {
            if (this.containsInputParams(storedProcedure)) continue;
            PropertyPair pp = new PropertyPair(storedProcedure.getName(), storedProcedure.getName());
            ppList.add(pp);
        }
        return ppList;
    }

    private boolean containsInputParams(StoredProcedureMetadata storedProcedure) {
        if (storedProcedure.getColumnList() != null && !storedProcedure.getColumnList().isEmpty()) {
            for (StoredProcedureColumn column : storedProcedure.getColumnList()) {
                if (!column.getMode().equals((Object)ColumnMode.IN) && !column.getMode().equals((Object)ColumnMode.INOUT)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isPresent(Map<String, Object> properties, String property) {
        return properties != null && properties.containsKey(property);
    }

    static boolean isPresentAndNonNull(Map<String, Object> properties, String property) {
        return SqlMetadataAdapter.isPresent(properties, (String)property) && properties.get(property) != null;
    }

    static JsonSchema schemaFor(JDBCType jdbcType) {
        JsonSchemaFactory factory = new JsonSchemaFactory();
        switch (1.$SwitchMap$java$sql$JDBCType[jdbcType.ordinal()]) {
            case 1: {
                return factory.arraySchema();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                ArraySchema binary = factory.arraySchema();
                binary.setItemsSchema((JsonSchema)factory.integerSchema());
                return binary;
            }
            case 6: 
            case 7: {
                return factory.booleanSchema();
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return factory.stringSchema();
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                StringSchema date = factory.stringSchema();
                date.setFormat(JsonValueFormat.DATE_TIME);
                return date;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return factory.numberSchema();
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return factory.integerSchema();
            }
            case 33: {
                return factory.nullSchema();
            }
        }
        return factory.anySchema();
    }
}

