package io.taig.taigless.validation

import cats.data.{NonEmptyList, Validated, ValidatedNel}
import io.taig.taigless.mapping.Mapping

trait MappingValidation {
  def apply[A, B](mapping: Mapping[A, B])(value: B): ValidatedNel[String, A] =
    Validated.fromOption(mapping.inverse(value), NonEmptyList.one(s"Invalid key '$value'"))
}

object MappingValidation extends MappingValidation
