/*
 * Decompiled with CFR 0.152.
 */
package io.takari.aether.concurrency;

import io.tesla.filelock.FileLockManager;
import io.tesla.filelock.Lock;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.io.FileProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class LockingFileProcessor
implements FileProcessor {
    private static Boolean IS_SET_LAST_MODIFIED_SAFE;
    private Logger logger = LoggerFactory.getLogger(LockingFileProcessor.class);
    private FileLockManager fileLockManager;

    @Inject
    public LockingFileProcessor(FileLockManager fileLockManager) {
        this.fileLockManager = fileLockManager;
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.logger.warn("Failed to close file: " + e);
            }
        }
    }

    private void unlock(Lock lock) {
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (IOException e) {
                this.logger.warn("Failed to unlock file " + lock.getFile() + ": " + e);
            }
        }
    }

    public boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    public void copy(File source, File target) throws IOException {
        this.copy(source, target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copy(File source, File target, FileProcessor.ProgressListener listener) throws IOException {
        Lock sourceLock = this.fileLockManager.readLock(source);
        Lock targetLock = this.fileLockManager.writeLock(target);
        try {
            this.mkdirs(target.getParentFile());
            sourceLock.lock();
            targetLock.lock();
            long l = this.copy(sourceLock.getRandomAccessFile(), targetLock.getRandomAccessFile(), listener);
            return l;
        }
        finally {
            this.unlock(sourceLock);
            this.unlock(targetLock);
        }
    }

    private long copy(RandomAccessFile rafIn, RandomAccessFile rafOut, FileProcessor.ProgressListener listener) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        long total = 0L;
        while (true) {
            int bytes;
            if ((bytes = rafIn.read(array)) < 0) break;
            rafOut.write(array, 0, bytes);
            total += (long)bytes;
            if (listener == null || bytes <= 0) continue;
            try {
                buffer.rewind();
                buffer.limit(bytes);
                listener.progressed(buffer);
            }
            catch (Exception e) {
                this.logger.debug("Failed to invoke copy progress listener", (Throwable)e);
            }
        }
        rafOut.setLength(rafOut.getFilePointer());
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, InputStream source) throws IOException {
        Lock lock = this.fileLockManager.writeLock(file);
        try {
            this.mkdirs(file.getParentFile());
            lock.lock();
            RandomAccessFile raf = lock.getRandomAccessFile();
            raf.seek(0L);
            if (source != null) {
                int len;
                byte[] buffer = new byte[1024];
                while ((len = source.read(buffer)) != -1) {
                    raf.write(buffer, 0, len);
                }
            }
            raf.setLength(raf.getFilePointer());
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, String data) throws IOException {
        Lock lock = this.fileLockManager.writeLock(file);
        try {
            this.mkdirs(file.getParentFile());
            lock.lock();
            RandomAccessFile raf = lock.getRandomAccessFile();
            raf.seek(0L);
            if (data != null) {
                raf.write(data.getBytes("UTF-8"));
            }
            raf.setLength(raf.getFilePointer());
        }
        finally {
            this.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(File source, File target) throws IOException {
        Lock sourceLock = this.fileLockManager.writeLock(source);
        Lock targetLock = this.fileLockManager.writeLock(target);
        try {
            this.mkdirs(target.getParentFile());
            sourceLock.lock();
            targetLock.lock();
            if (!source.renameTo(target)) {
                this.copy(sourceLock.getRandomAccessFile(), targetLock.getRandomAccessFile(), null);
                if (IS_SET_LAST_MODIFIED_SAFE == null) {
                    IS_SET_LAST_MODIFIED_SAFE = target.setLastModified(source.lastModified());
                    this.logger.debug("Updates of file modification timestamp are safe: " + IS_SET_LAST_MODIFIED_SAFE);
                }
                this.close(targetLock.getRandomAccessFile());
                if (IS_SET_LAST_MODIFIED_SAFE.booleanValue()) {
                    target.setLastModified(source.lastModified());
                }
                this.close(sourceLock.getRandomAccessFile());
                source.delete();
            }
        }
        finally {
            this.unlock(sourceLock);
            this.unlock(targetLock);
        }
    }
}

