/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.api;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Variables
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Variables parent;
    private final LinkedHashMap<String, Object> values;

    public Variables() {
        this((Variables)null);
    }

    public Variables(Variables parent) {
        this.parent = parent;
        this.values = new LinkedHashMap();
    }

    public Variables(Map<String, Object> values) {
        this.parent = null;
        this.values = new LinkedHashMap<String, Object>(values);
    }

    private Variables(Variables parent, LinkedHashMap<String, Object> values) {
        this.parent = parent;
        this.values = values;
    }

    public Variables getParent() {
        return this.parent;
    }

    public Variables setVariable(String key, Object value) {
        LinkedHashMap<String, Object> next = new LinkedHashMap<String, Object>(this.values);
        next.put(key, value);
        return new Variables(this.parent, next);
    }

    public Variables setVariables(Map<String, Object> m) {
        LinkedHashMap<String, Object> next = new LinkedHashMap<String, Object>(this.values);
        next.putAll(m);
        return new Variables(this.parent, next);
    }

    public Object getVariable(String key) {
        if (this.values.containsKey(key)) {
            return this.values.get(key);
        }
        return this.parent != null ? this.parent.getVariable(key) : null;
    }

    public Set<String> getVariableNames() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.values.keySet());
        return result;
    }

    public boolean hasVariable(String key) {
        return this.values.containsKey(key) || this.parent != null && this.parent.hasVariable(key);
    }

    public Variables removeVariable(String key) {
        if (this.values.containsKey(key)) {
            LinkedHashMap<String, Object> next = new LinkedHashMap<String, Object>(this.values);
            next.remove(key);
            return new Variables(this.parent, next);
        }
        if (this.parent == null) {
            return this;
        }
        return new Variables(this.parent.removeVariable(key), this.values);
    }

    public Map<String, Object> asMap() {
        return this.values;
    }
}

