/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.model;

import io.takari.bpm.model.AbstractElement;
import io.takari.bpm.model.ExpressionType;
import java.util.Arrays;

public class SequenceFlow
extends AbstractElement {
    private static final long serialVersionUID = 1L;
    private String name;
    private final String from;
    private final String to;
    private final String expression;
    private final ExecutionListener[] listeners;

    public SequenceFlow(String id, String from, String to) {
        this(id, from, to, (String)null, (ExecutionListener[])null);
    }

    public SequenceFlow(String id, String from, String to, String expression) {
        this(id, from, to, expression, null);
    }

    public SequenceFlow(String id, String from, String to, ExecutionListener ... listeners) {
        this(id, from, to, (String)null, listeners);
    }

    public SequenceFlow(String id, String from, String to, String expression, ExecutionListener ... listeners) {
        super(id);
        this.from = from;
        this.to = to;
        this.expression = expression;
        this.listeners = listeners;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getExpression() {
        return this.expression;
    }

    public ExecutionListener[] getListeners() {
        return this.listeners;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "SequenceFlow (" + this.getId() + ") {" + "name='" + this.name + '\'' + ", " + this.from + " -> " + this.to + '\'' + ", expression='" + this.expression + '\'' + ", listeners=" + Arrays.toString(this.listeners) + '}';
    }

    public static final class ExecutionListener {
        private final String event;
        private final ExpressionType type;
        private final String expression;

        public ExecutionListener(String event, ExpressionType type, String expression) {
            this.event = event;
            this.type = type;
            this.expression = expression;
        }

        public String getEvent() {
            return this.event;
        }

        public ExpressionType getType() {
            return this.type;
        }

        public String getExpression() {
            return this.expression;
        }
    }
}

