/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.model;

import io.takari.bpm.model.AbstractElement;
import io.takari.bpm.model.BoundaryEvent;
import io.takari.bpm.model.CallActivity;
import io.takari.bpm.model.EndEvent;
import io.takari.bpm.model.EventBasedGateway;
import io.takari.bpm.model.ExclusiveGateway;
import io.takari.bpm.model.ExpressionType;
import io.takari.bpm.model.InclusiveGateway;
import io.takari.bpm.model.IntermediateCatchEvent;
import io.takari.bpm.model.ParallelGateway;
import io.takari.bpm.model.ScriptTask;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.model.ServiceTask;
import io.takari.bpm.model.SourceAwareProcessDefinition;
import io.takari.bpm.model.SourceMap;
import io.takari.bpm.model.StartEvent;
import io.takari.bpm.model.SubProcess;
import io.takari.bpm.model.TerminateEvent;
import io.takari.bpm.model.UserTask;
import io.takari.bpm.model.VariableMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class ProcessDefinitionBuilder {
    public static Process newProcess(String id) {
        return new ProcessImpl(id);
    }

    private static class FlowFactory {
        private SeqImpl<?, ?> seq;
        boolean primed = false;
        String name;
        String expression;

        public FlowFactory(SeqImpl<?, ?> seq) {
            this.seq = seq;
        }

        void prime(String name, String expression) {
            this.primed = true;
            this.name = name;
            this.expression = expression;
        }

        SequenceFlow newFlow(String from, String to) {
            if (this.primed) {
                this.primed = false;
                String id = this.name;
                if (id == null) {
                    id = this.seq.nextFlowId(from, to);
                }
                return new SequenceFlow(id, from, to, this.expression);
            }
            return new SequenceFlow(this.seq.nextFlowId(from, to), from, to);
        }
    }

    public static interface Fork<P extends Seq>
    extends TypedSeq<Fork<P>, P> {
        public P joinTo(String var1);

        public P loop();
    }

    private static class ForkImpl<P extends Seq>
    extends SeqImpl<Fork<P>, P>
    implements Fork<P> {
        private SeqImpl<?, ?> parent;

        ForkImpl(SeqImpl<?, ?> parent, String lastId, AbstractElement lastElement) {
            super(parent.prefix);
            this.parent = parent;
            this.lastId = lastId;
            this.lastElement = lastElement;
        }

        ForkImpl(SeqImpl<?, ?> parent, AbstractElement start) {
            this(parent, start.getId(), start);
            this.addElement(start);
        }

        @Override
        public P parent() {
            return (P)this.parent;
        }

        @Override
        protected String nextFlowId(String from, String to) {
            return this.parent.nextFlowId(from, to);
        }

        @Override
        public String nextStepId() {
            return this.parent.nextStepId();
        }

        @Override
        protected String nextEndId() {
            return this.parent.nextEndId();
        }

        @Override
        public P joinTo(String joinName) {
            Object p = this.done();
            String flowName = this.flows.primed ? this.flows.name : null;
            String flowExpr = this.flows.primed ? this.flows.expression : null;
            this.parent.doJoin(joinName, this.lastId, this.lastElement, flowName, flowExpr, this.getActiveDanglingItems());
            return (P)p;
        }

        @Override
        public P loop() {
            return this.joinTo(this.parent.loopJoin());
        }

        @Override
        protected P done() {
            this.parent.getElements().addAll(this.getElements());
            return (P)this.parent;
        }

        private List<Tail> getActiveDanglingItems() {
            if (this.joinPoint == null) {
                return Collections.emptyList();
            }
            JoinData j = (JoinData)this.joins.get(this.joinPoint);
            if (j == null) {
                return Collections.emptyList();
            }
            return j.danglingJoins;
        }

        @Override
        public Fork<P> sourceMap(SourceMap.Significance sig, int line, int col, String desc) {
            this.sourceMap(this.lastId, sig, line, col, desc);
            return this;
        }

        @Override
        protected void sourceMap(String id, SourceMap.Significance sig, int line, int col, String desc) {
            this.parent.sourceMap(id, sig, line, col, desc);
        }
    }

    private static class JoinData {
        private String target;
        private List<Tail> danglingJoins = new ArrayList<Tail>();

        private JoinData() {
        }
    }

    public static interface Process
    extends TypedSeq<Process, SourceAwareProcessDefinition> {
    }

    public static class ProcessImpl
    extends SeqImpl<Process, SourceAwareProcessDefinition>
    implements Process {
        private String id;
        private final Map<String, SourceMap> sourceMaps = new HashMap<String, SourceMap>();

        ProcessImpl(String id) {
            super(String.valueOf(id) + "_");
            this.id = id;
            this.addStart();
        }

        @Override
        protected SourceAwareProcessDefinition done() {
            return new SourceAwareProcessDefinition(this.id, this.getElements(), Collections.emptyMap(), this.sourceMaps);
        }

        @Override
        public SourceAwareProcessDefinition parent() {
            return null;
        }

        @Override
        public Process sourceMap(SourceMap.Significance sig, int line, int col, String desc) {
            this.sourceMap(this.lastId, sig, line, col, desc);
            return this;
        }

        @Override
        protected void sourceMap(String id, SourceMap.Significance sig, int line, int col, String desc) {
            SourceMap old = this.sourceMaps.put(id, new SourceMap(sig, null, line, col, desc));
            if (old != null) {
                throw new IllegalArgumentException("Duplicate source map ID: " + id);
            }
        }
    }

    public static interface Seq {
        public Seq add(Function<String, AbstractElement> var1);

        public Seq task(ExpressionType var1, String var2);

        public Seq task(ExpressionType var1, String var2, Set<VariableMapping> var3, Set<VariableMapping> var4);

        public Seq task(ExpressionType var1, String var2, Set<VariableMapping> var3, Set<VariableMapping> var4, boolean var5);

        public Seq task(String var1);

        public Seq task(String var1, Set<VariableMapping> var2, Set<VariableMapping> var3);

        public Seq task(String var1, Set<VariableMapping> var2, Set<VariableMapping> var3, boolean var4);

        public Seq taskDelegate(String var1);

        public Seq userTask(List<UserTask.Extension> var1);

        public Seq script(ScriptTask.Type var1, String var2, String var3);

        public Seq script(ScriptTask.Type var1, String var2, String var3, boolean var4);

        public Seq call(String var1);

        public Seq call(String var1, boolean var2);

        public Seq call(String var1, Set<VariableMapping> var2, Set<VariableMapping> var3);

        public Seq call(String var1, Set<VariableMapping> var2, Set<VariableMapping> var3, boolean var4);

        public Seq call(String var1, String var2, Set<VariableMapping> var3, Set<VariableMapping> var4, boolean var5);

        public Seq eventGate();

        public Seq parallelGate();

        public Seq inclusiveGate();

        public Seq exclusiveGate();

        public Seq exclusiveGate(String var1);

        public Seq flow(String var1);

        public Seq flowExpr(String var1);

        public Seq flowExpr(String var1, String var2);

        public Seq catchEvent();

        public Seq catchEvent(String var1);

        public Seq catchEventExpr(String var1);

        public Seq catchEvent(String var1, String var2, String var3);

        public Seq catchEventExpr(String var1, String var2, String var3);

        public Sub<? extends Seq> sub();

        public Sub<? extends Seq> sub(boolean var1);

        public Sub<? extends Seq> sub(boolean var1, Set<VariableMapping> var2);

        public Fork<? extends Seq> fork();

        public Fork<? extends Seq> boundaryEvent();

        public Fork<? extends Seq> boundaryEvent(String var1);

        public Fork<? extends Seq> boundaryEvent(String var1, String var2);

        public Seq joinPoint(String var1);

        public Seq joinAll(String var1);

        public Seq tieForks();

        public Seq apply(Function<? super Seq, ?> var1);

        public <E> Seq applyEach(Collection<? extends E> var1, BiFunction<? super Seq, E, ?> var2);

        public Object endEvent();

        public Object endEvent(String var1);

        public Object end();

        public Object end(SourceMap.Significance var1, int var2, int var3, String var4);

        public Object end(String var1);

        public Object end(String var1, String var2);

        public Object end(String var1, String var2, SourceMap.Significance var3, int var4, int var5, String var6);

        public Object terminate();

        public Seq sourceMap(SourceMap.Significance var1, int var2, int var3, String var4);
    }

    private static abstract class SeqImpl<T extends TypedSeq<T, P>, P>
    implements TypedSeq<T, P> {
        private final List<AbstractElement> elements = new ArrayList<AbstractElement>();
        protected final String prefix;
        protected int stepCounter = 0;
        protected int endCounter = 0;
        protected String lastId;
        protected AbstractElement lastElement;
        protected FlowFactory flows = new FlowFactory(this);
        protected Map<String, JoinData> joins;
        protected String joinPoint;
        private boolean joinPointAll;

        SeqImpl(String prefix) {
            this.prefix = prefix;
        }

        protected List<AbstractElement> getElements() {
            return this.elements;
        }

        protected String nextFlowId(String from, String to) {
            if (from.startsWith(this.prefix)) {
                from = from.substring(this.prefix.length());
            }
            if (to.startsWith(this.prefix)) {
                to = to.substring(this.prefix.length());
            }
            return String.valueOf(this.prefix) + "flow_" + from + "_" + to;
        }

        @Override
        public String nextStepId() {
            return String.valueOf(this.prefix) + ++this.stepCounter;
        }

        protected String startId() {
            return String.valueOf(this.prefix) + "start";
        }

        protected String nextEndId() {
            if (this.endCounter++ == 0) {
                return String.valueOf(this.prefix) + "end";
            }
            return String.valueOf(this.prefix) + "end" + this.endCounter;
        }

        protected String loopJoin() {
            return "__loop_" + this.lastId;
        }

        protected T ret() {
            return (T)this;
        }

        protected abstract P done();

        protected void addFlow(String from, String to) {
            this.addElement(this.flows.newFlow(from, to));
        }

        @Override
        public T flow(String name) {
            this.flows.prime(name, null);
            return this.ret();
        }

        @Override
        public T flowExpr(String expression) {
            this.flows.prime(null, expression);
            return this.ret();
        }

        @Override
        public T flowExpr(String name, String expression) {
            this.flows.prime(name, expression);
            return this.ret();
        }

        protected void addStart() {
            this.add(new StartEvent(this.startId()));
        }

        protected void addEnd(String errorRef, String causeExpression) {
            this.addEnd(errorRef, causeExpression, null, -1, -1, null);
        }

        protected void addEnd(String errorRef, String causeExpression, SourceMap.Significance sig, int line, int col, String desc) {
            this.add(new EndEvent(this.nextEndId(), errorRef, causeExpression));
            if (sig != null) {
                this.sourceMap(sig, line, col, desc);
            }
            this.validate();
        }

        protected void addElement(AbstractElement e) {
            this.elements.add(e);
        }

        @Override
        public T add(AbstractElement elem) {
            String newId = elem.getId();
            String loopJoin = this.loopJoin();
            if (this.joinPoint == null && this.hasJoins(loopJoin)) {
                this.joinPoint(loopJoin);
            }
            String flowName = null;
            String flowExpr = null;
            if (this.flows.primed) {
                flowName = this.flows.name;
                flowExpr = this.flows.expression;
            }
            this.doJoinPoint(newId);
            if (this.lastId != null) {
                if (flowName != null || flowExpr != null) {
                    this.flows.prime(flowName, flowExpr);
                }
                this.addFlow(this.lastId, newId);
            }
            this.addElement(elem);
            this.lastId = newId;
            this.lastElement = elem;
            return this.ret();
        }

        public T endEvent() {
            this.addEnd(null, null);
            return this.ret();
        }

        public T endEvent(String errorRef) {
            this.addEnd(errorRef, null);
            return this.ret();
        }

        @Override
        public P end() {
            if (!(this.lastElement instanceof EndEvent)) {
                this.addEnd(null, null);
            }
            return this.done();
        }

        @Override
        public P end(SourceMap.Significance sig, int line, int col, String desc) {
            this.addEnd(null, null, sig, line, col, desc);
            return this.done();
        }

        @Override
        public P end(String errorRef) {
            this.addEnd(errorRef, null);
            return this.done();
        }

        @Override
        public P end(String errorRef, String causeExpression) {
            this.addEnd(errorRef, causeExpression);
            return this.done();
        }

        @Override
        public P end(String errorRef, String causeExpression, SourceMap.Significance sig, int line, int col, String desc) {
            this.addEnd(errorRef, causeExpression, sig, line, col, desc);
            return this.done();
        }

        public void addTerminate() {
            this.add(new TerminateEvent(this.nextEndId()));
            this.validate();
        }

        @Override
        public P terminate() {
            if (!(this.lastElement instanceof TerminateEvent)) {
                this.addTerminate();
            }
            return this.done();
        }

        @Override
        public SubImpl<T> sub() {
            return this.sub(false);
        }

        @Override
        public SubImpl<T> sub(boolean useSeparateContext) {
            return this.sub(useSeparateContext, Collections.emptySet());
        }

        @Override
        public SubImpl<T> sub(boolean useSeparateContext, Set<VariableMapping> out) {
            return new SubImpl(this, this.nextStepId(), useSeparateContext, out);
        }

        @Override
        public ForkImpl<T> fork() {
            return new ForkImpl(this, this.lastId, this.lastElement);
        }

        @Override
        public ForkImpl<T> boundaryEvent() {
            return this.boundaryEvent(null);
        }

        @Override
        public ForkImpl<T> boundaryEvent(String errorRef) {
            return this.boundaryEvent(errorRef, null);
        }

        @Override
        public ForkImpl<T> boundaryEvent(String errorRef, String timeDuration) {
            return new ForkImpl(this, new BoundaryEvent(this.nextStepId(), this.lastId, errorRef, timeDuration));
        }

        @Override
        public T joinPoint(String joinName) {
            return this.join(joinName, false);
        }

        @Override
        public T joinAll(String joinName) {
            return this.join(joinName, true);
        }

        @Override
        public T tieForks() {
            return this.join(this.loopJoin(), true);
        }

        private T join(String joinName, boolean all) {
            this.joinPoint = joinName;
            this.joinPointAll = all;
            return this.ret();
        }

        protected void doJoin(String joinName, String id, AbstractElement element, String flowName, String flowExpr, List<Tail> additionalDanglingJoins) {
            JoinData j = this.getJoin(joinName);
            if (!(element instanceof EndEvent)) {
                if (additionalDanglingJoins.isEmpty()) {
                    j.danglingJoins.add(new Tail(id, flowName, flowExpr));
                }
                j.danglingJoins.addAll(additionalDanglingJoins);
            }
            this.flushJoins(j);
        }

        protected void doJoinPoint(String id) {
            if (this.joinPoint != null) {
                JoinData j = this.getJoin(this.joinPoint);
                if (j.target != null) {
                    throw new IllegalStateException("Join " + this.joinPoint + " target is already defined as " + j.target);
                }
                j.target = id;
                this.flushJoins(j);
                if (this.joinPointAll) {
                    this.lastId = null;
                    this.lastElement = null;
                }
                this.joinPoint = null;
                this.joinPointAll = false;
            }
        }

        private JoinData getJoin(String joinName) {
            JoinData j;
            if (this.joins == null) {
                this.joins = new HashMap<String, JoinData>();
            }
            if ((j = this.joins.get(joinName)) == null) {
                j = new JoinData();
                this.joins.put(joinName, j);
            }
            return j;
        }

        private boolean hasJoins(String joinName) {
            return this.joins != null && this.joins.containsKey(joinName);
        }

        private void flushJoins(JoinData j) {
            if (j.target != null) {
                for (Tail tail : j.danglingJoins) {
                    if (tail.flowName != null || tail.flowExpression != null) {
                        this.flows.prime(tail.flowName, tail.flowExpression);
                    }
                    this.addFlow(tail.id, j.target);
                }
                j.danglingJoins.clear();
            }
        }

        protected void validate() {
            if (this.joins != null) {
                for (Map.Entry<String, JoinData> e : this.joins.entrySet()) {
                    String k = e.getKey();
                    JoinData j = e.getValue();
                    if (j.danglingJoins.isEmpty()) continue;
                    throw new IllegalStateException("Not all tails were joined into " + k + " (" + j.danglingJoins + ")");
                }
            }
        }

        protected abstract void sourceMap(String var1, SourceMap.Significance var2, int var3, int var4, String var5);
    }

    public static interface Sub<P extends Seq>
    extends TypedSeq<Sub<P>, P> {
    }

    private static class SubImpl<P extends Seq>
    extends SeqImpl<Sub<P>, P>
    implements Sub<P> {
        private SeqImpl<?, ?> parent;
        private String id;
        private boolean useSeparateContext;
        private Set<VariableMapping> out;

        SubImpl(SeqImpl<?, ?> parent, String id, boolean useSeparateContext, Set<VariableMapping> out) {
            super(String.valueOf(id) + "_");
            this.parent = parent;
            this.id = id;
            this.useSeparateContext = useSeparateContext;
            this.out = out;
            this.addStart();
        }

        @Override
        protected P done() {
            this.parent.add(new SubProcess(this.id, this.useSeparateContext, this.out, this.getElements()));
            return (P)this.parent();
        }

        @Override
        public P parent() {
            return (P)this.parent;
        }

        @Override
        public Sub<P> sourceMap(SourceMap.Significance sig, int line, int col, String desc) {
            this.sourceMap(this.lastId, sig, line, col, desc);
            return this;
        }

        @Override
        protected void sourceMap(String id, SourceMap.Significance sig, int line, int col, String desc) {
            this.parent.sourceMap(id, sig, line, col, desc);
        }
    }

    private static class Tail {
        final String id;
        final String flowName;
        final String flowExpression;

        public Tail(String id, String flowName, String flowExpression) {
            this.id = id;
            this.flowName = flowName;
            this.flowExpression = flowExpression;
        }
    }

    public static interface TypedSeq<T extends TypedSeq<T, P>, P>
    extends Seq {
        public String nextStepId();

        public T add(AbstractElement var1);

        default public T add(Function<String, AbstractElement> elemFun) {
            return this.add(elemFun.apply(this.nextStepId()));
        }

        default public T task(ExpressionType expType, String expr) {
            return (T)this.task(expType, expr, (Set)null, (Set)null);
        }

        default public T task(ExpressionType expType, String expr, Set<VariableMapping> in, Set<VariableMapping> out) {
            return (T)this.task(expType, expr, (Set)in, (Set)out, false);
        }

        default public T task(ExpressionType expType, String expr, Set<VariableMapping> in, Set<VariableMapping> out, boolean copyAllVariables) {
            return this.add(new ServiceTask(this.nextStepId(), expType, expr, in, out, copyAllVariables));
        }

        default public T task(String expr) {
            return (T)this.task(ExpressionType.SIMPLE, expr);
        }

        default public T task(String expr, Set<VariableMapping> in, Set<VariableMapping> out) {
            return (T)this.task(ExpressionType.SIMPLE, expr, (Set)in, (Set)out);
        }

        default public T task(String expr, Set<VariableMapping> in, Set<VariableMapping> out, boolean copyAllVariables) {
            return (T)this.task(ExpressionType.SIMPLE, expr, (Set)in, (Set)out, copyAllVariables);
        }

        default public T taskDelegate(String expr) {
            return (T)this.task(ExpressionType.DELEGATE, expr);
        }

        @Override
        default public Seq userTask(List<UserTask.Extension> extensions) {
            return this.add(new UserTask(this.nextStepId(), extensions));
        }

        default public T script(ScriptTask.Type type, String language, String content) {
            return (T)this.script(type, language, content, false);
        }

        default public T script(ScriptTask.Type type, String language, String content, boolean copyAllVariables) {
            return this.add(new ScriptTask(this.nextStepId(), type, language, content, copyAllVariables));
        }

        default public T call(String calledElement) {
            return this.add(new CallActivity(this.nextStepId(), calledElement));
        }

        default public T call(String calledElement, boolean copyAllVariables) {
            return this.add(new CallActivity(this.nextStepId(), calledElement, copyAllVariables));
        }

        default public T call(String calledElement, Set<VariableMapping> in, Set<VariableMapping> out) {
            return this.add(new CallActivity(this.nextStepId(), calledElement, in, out));
        }

        default public T call(String calledElement, Set<VariableMapping> in, Set<VariableMapping> out, boolean copyAllVariables) {
            return this.add(new CallActivity(this.nextStepId(), calledElement, in, out, copyAllVariables));
        }

        default public T call(String calledElement, String calledElementExpr, Set<VariableMapping> in, Set<VariableMapping> out, boolean copyAllVariables) {
            return this.add(new CallActivity(this.nextStepId(), calledElement, calledElementExpr, in, out, copyAllVariables));
        }

        default public T eventGate() {
            return this.add(new EventBasedGateway(this.nextStepId()));
        }

        default public T parallelGate() {
            return this.add(new ParallelGateway(this.nextStepId()));
        }

        default public T inclusiveGate() {
            return this.add(new InclusiveGateway(this.nextStepId()));
        }

        default public T exclusiveGate() {
            return this.add(new ExclusiveGateway(this.nextStepId()));
        }

        default public T exclusiveGate(String defaultFlow) {
            return this.add(new ExclusiveGateway(this.nextStepId(), defaultFlow));
        }

        public T flow(String var1);

        public T flowExpr(String var1);

        public T flowExpr(String var1, String var2);

        default public T catchEvent() {
            return this.add(new IntermediateCatchEvent(this.nextStepId()));
        }

        default public T catchEvent(String messageRef) {
            return (T)this.catchEvent(messageRef, null, null);
        }

        default public T catchEventExpr(String messageRefExpr) {
            return (T)this.catchEventExpr(messageRefExpr, null, null);
        }

        default public T catchEvent(String messageRef, String timeDate, String timeDuration) {
            return this.add(new IntermediateCatchEvent(this.nextStepId(), messageRef, timeDate, timeDuration));
        }

        default public T catchEventExpr(String messageRefExpr, String timeDate, String timeDuration) {
            return this.add(new IntermediateCatchEvent(this.nextStepId(), null, messageRefExpr, timeDate, timeDuration, null));
        }

        default public T apply(Function<? super Seq, ?> f) {
            Object s;
            if (f != null && (s = f.apply(this)) != this) {
                throw new IllegalStateException("Function did not return what was passed in");
            }
            TypedSeq t = this;
            return (T)t;
        }

        default public <E> T applyEach(Collection<? extends E> elements, BiFunction<? super Seq, E, ?> f) {
            for (E e : elements) {
                Object s = f.apply(this, e);
                if (s == this) continue;
                throw new IllegalStateException("Function did not return what was passed in");
            }
            TypedSeq t = this;
            return (T)t;
        }

        default public T applySub(Function<? super T, ?> function) {
            Function<? super T, ?> f = function;
            return (T)this.apply(f);
        }

        default public P applyEnd(Function<? super T, ?> function) {
            TypedSeq t = this;
            Object par = function.apply(t);
            if (this.parent() != null && par != this.parent()) {
                throw new IllegalStateException("Function did not return the correct parent");
            }
            return (P)par;
        }

        public Sub<T> sub();

        public Sub<T> sub(boolean var1);

        public Sub<T> sub(boolean var1, Set<VariableMapping> var2);

        public Fork<T> fork();

        public Fork<T> boundaryEvent();

        public Fork<T> boundaryEvent(String var1);

        public Fork<T> boundaryEvent(String var1, String var2);

        public T joinPoint(String var1);

        public T joinAll(String var1);

        public T tieForks();

        public P end();

        public P end(SourceMap.Significance var1, int var2, int var3, String var4);

        public P end(String var1);

        public P end(String var1, String var2);

        public P end(String var1, String var2, SourceMap.Significance var3, int var4, int var5, String var6);

        public P terminate();

        public P parent();

        public T sourceMap(SourceMap.Significance var1, int var2, int var3, String var4);
    }
}

