/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.model;

import io.takari.bpm.model.AbstractElement;
import io.takari.bpm.model.BoundaryEvent;
import io.takari.bpm.model.ProcessDefinition;
import io.takari.bpm.model.SequenceFlow;
import io.takari.bpm.model.ServiceTask;
import io.takari.bpm.model.SourceAwareProcessDefinition;
import io.takari.bpm.model.SourceMap;
import java.util.Collections;
import java.util.Map;

public final class ProcessDefinitionHelper {
    public static String dump(ProcessDefinition pd) {
        Map<String, SourceMap> sms = Collections.emptyMap();
        if (pd instanceof SourceAwareProcessDefinition) {
            sms = ((SourceAwareProcessDefinition)pd).getSourceMaps();
        }
        StringBuilder b = new StringBuilder();
        b.append("===================================\n").append("\tID: ").append(pd.getId()).append("\n");
        ProcessDefinitionHelper.dump(b, pd, sms, 2);
        return b.toString();
    }

    private static StringBuilder pad(StringBuilder b, int level) {
        int i = 0;
        while (i < level) {
            b.append("\t");
            ++i;
        }
        return b;
    }

    private static void dump(StringBuilder b, ProcessDefinition pd, Map<String, SourceMap> sourceMaps, int level) {
        for (AbstractElement e : pd.getChildren()) {
            ProcessDefinitionHelper.pad(b, level).append(e.getClass().getSimpleName()).append(" [").append(e.getId()).append("]");
            if (e instanceof SequenceFlow) {
                SequenceFlow f = (SequenceFlow)e;
                b.append(" ").append(f.getFrom()).append(" -> ").append(f.getTo());
                if (f.getExpression() != null) {
                    b.append(" ").append(f.getExpression());
                }
            } else if (e instanceof ServiceTask) {
                ServiceTask t = (ServiceTask)e;
                b.append(" ").append((Object)t.getType()).append(" ").append(t.getExpression());
                if (t.getIn() != null) {
                    ProcessDefinitionHelper.pad(b.append("\n"), level + 1).append("IN: ").append(t.getIn());
                }
                if (t.getOut() != null) {
                    ProcessDefinitionHelper.pad(b.append("\n"), level + 1).append("OUT: ").append(t.getOut());
                }
            } else if (e instanceof BoundaryEvent) {
                BoundaryEvent ev = (BoundaryEvent)e;
                b.append(" ").append(ev.getErrorRef()).append(" @ ").append(ev.getAttachedToRef());
            }
            b.append("\n");
            SourceMap sm = sourceMaps.get(e.getId());
            if (sm != null) {
                ProcessDefinitionHelper.pad(b, level + 1).append("source: ").append(sm).append("\n");
            }
            if (!(e instanceof ProcessDefinition)) continue;
            ProcessDefinitionHelper.dump(b, (ProcessDefinition)e, sourceMaps, level + 1);
        }
    }

    private ProcessDefinitionHelper() {
    }
}

