/*
 * Decompiled with CFR 0.152.
 */
package io.takari.bpm.model.form;

import io.takari.bpm.misc.CoverageIgnore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class FormField
implements Serializable {
    private static final transient Map<String, OptionIndex> allowedOptions = new HashMap<String, OptionIndex>();
    private final String name;
    private final String type;
    private final String label;
    private final Object defaultValue;
    private final Object allowedValue;
    private final Cardinality cardinality;
    private final Map<String, Object> options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CoverageIgnore
    public static <T> Option<T> registerOption(String fieldType, String name, Class<T> type) {
        Map<String, OptionIndex> map = allowedOptions;
        synchronized (map) {
            OptionIndex idx = allowedOptions.get(fieldType);
            if (idx == null) {
                idx = new OptionIndex(Option::new);
                allowedOptions.put(fieldType, idx);
            }
            return idx.register(name, type);
        }
    }

    public FormField(String name, String type, String label, Object defaultValue, Object allowedValue, Cardinality cardinality, Map<String, Object> options) {
        this.name = name;
        this.type = type;
        this.label = label;
        this.defaultValue = defaultValue;
        this.allowedValue = allowedValue;
        this.cardinality = cardinality;
        this.options = options;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getAllowedValue() {
        return this.allowedValue;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public <T> T getOption(Option<T> o) {
        if (this.options == null) {
            return null;
        }
        Object v = this.options.get(((Option)o).name);
        if (v == null) {
            return null;
        }
        return o.cast(v);
    }

    public static final class Builder {
        private final String name;
        private final String type;
        private String label;
        private Object defaultValue;
        private Object allowedValue;
        private Cardinality cardinality;
        private Map<String, Object> options;

        public Builder(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public Builder(FormField prev) {
            this.name = prev.getName();
            this.type = prev.getType();
            this.label = prev.getLabel();
            this.defaultValue = prev.getDefaultValue();
            this.allowedValue = prev.getAllowedValue();
            this.cardinality = prev.getCardinality();
            this.options = prev.getOptions();
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder allowedValue(Object allowedValue) {
            this.allowedValue = allowedValue;
            return this;
        }

        public Builder cardinality(Cardinality cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        public Builder options(Map<Option<?>, ?> other) {
            if (this.options == null) {
                this.options = new HashMap<String, Object>();
            }
            for (Map.Entry<Option<?>, ?> e : other.entrySet()) {
                String k = ((Option)e.getKey()).name;
                Object v = e.getValue();
                this.options.put(k, v);
            }
            return this;
        }

        public <T> Builder option(Option<T> o, T value) {
            OptionIndex idx = (OptionIndex)allowedOptions.get(this.type);
            if (idx == null || !idx.contains(o)) {
                throw new IllegalArgumentException("Type '" + this.type + "' doesn't allow " + o);
            }
            if (value == null) {
                return this;
            }
            if (this.options == null) {
                this.options = new HashMap<String, Object>();
            }
            this.options.put(((Option)o).name, value);
            return this;
        }

        public FormField build() {
            if (this.label == null) {
                this.label = this.name;
            }
            if (this.cardinality == null) {
                this.cardinality = Cardinality.ONE_AND_ONLY_ONE;
            }
            return new FormField(this.name, this.type, this.label, this.defaultValue, this.allowedValue, this.cardinality, this.options);
        }
    }

    public static enum Cardinality {
        ONE_AND_ONLY_ONE,
        ONE_OR_NONE,
        AT_LEAST_ONE,
        ANY;


        public String toSymbol() {
            switch (this) {
                case ONE_AND_ONLY_ONE: {
                    return "";
                }
                case ONE_OR_NONE: {
                    return "?";
                }
                case AT_LEAST_ONE: {
                    return "+";
                }
                case ANY: {
                    return "*";
                }
            }
            throw new IllegalArgumentException("Unknown cardinality type: " + (Object)((Object)this));
        }

        public static Cardinality fromSymbol(String s) {
            if (s == null || s.isEmpty()) {
                return ONE_AND_ONLY_ONE;
            }
            switch (s) {
                case "?": {
                    return ONE_OR_NONE;
                }
                case "+": {
                    return AT_LEAST_ONE;
                }
                case "*": {
                    return ANY;
                }
            }
            return ONE_AND_ONLY_ONE;
        }
    }

    public static final class Option<T> {
        private final String name;
        private final Class<T> type;

        public Option(String name, Class<T> type) {
            this.name = name;
            this.type = type;
        }

        public T cast(Object v) {
            if (v == null) {
                return null;
            }
            Class<?> other = v.getClass();
            if (!this.type.isAssignableFrom(other)) {
                throw new IllegalArgumentException("Invalid value type: expected " + this.type + ", got " + other);
            }
            return this.type.cast(v);
        }

        @CoverageIgnore
        public String toString() {
            return "Option{name='" + this.name + '\'' + ", type=" + this.type + '}';
        }
    }

    public static final class OptionIndex {
        private final Map<String, Option<?>> options = new HashMap();
        private final BiFunction<String, Class<?>, Option<?>> optionMaker;

        public OptionIndex(BiFunction<String, Class<?>, Option<?>> optionMaker) {
            this.optionMaker = optionMaker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Option<?> register(String name, Class<?> type) {
            Map<String, Option<?>> map = this.options;
            synchronized (map) {
                if (this.options.containsKey(name)) {
                    throw new IllegalStateException("Option '" + name + "' is already registered in this context. " + "Check for duplicate declarations in the code");
                }
                Option<?> o = this.optionMaker.apply(name, type);
                this.options.put(name, o);
                return o;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Option<?> o) {
            Map<String, Option<?>> map = this.options;
            synchronized (map) {
                Option<?> q = this.options.get(((Option)o).name);
                return q != null && ((Option)q).type.equals(((Option)o).type);
            }
        }
    }
}

